/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.fi.fea.enums.ExpressionType;
import kd.fi.fea.util.EntityFieldTreeOption;
import kd.fi.fea.util.EntityFieldTreeResult;
import kd.fi.fea.util.EntityTreeUtil;
import kd.fi.fea.util.FeaUtil;

public class FomulaFormPlugin
extends AbstractFormPlugin {
    private static final String SOURCETYPE = "sourcetype";
    private static final String RADIO_FIX = "1";
    private static final String RADIO_EXP = "2";
    private static final String RADIO_VALTRANS = "3";
    private static final String FIXPANEL = "fixpanel";
    private static final String VALPANEL = "valpanel";
    private static final String EXPPANEL = "exppanel";
    private static final String FIXVALUE = "fixvalue";
    private static final String EXPDESC = "expdesc";
    private static final String EXPVALUE = "expvalue";
    private static final String PROP = "prop";
    private static final String VALUE = "value";
    private static final String DESC = "desc";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, EXPDESC});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "expdesc": {
                this.showFormulaForm(key);
            }
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        String sourcetype = (String)model.getValue(SOURCETYPE);
        String value = null;
        String valuedesc = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(SOURCETYPE, sourcetype);
        switch (sourcetype) {
            case "1": {
                String valResult;
                value = valuedesc = (String)model.getValue(FIXVALUE);
                FormShowParameter par = this.getView().getFormShowParameter();
                Map map = (Map)par.getCustomParam("datatype");
                if (map != null && StringUtils.isNotEmpty((CharSequence)(valResult = FeaUtil.validateDataType((Map)map, (String)value)))) {
                    this.getView().showTipNotification(valResult);
                    return;
                }
                valueMap.put(VALUE, value);
                break;
            }
            case "2": {
                valuedesc = (String)model.getValue(EXPDESC);
                value = (String)model.getValue(EXPVALUE);
                valueMap.put(VALUE, value);
                break;
            }
            case "3": {
                DynamicObjectCollection entry = model.getEntryEntity(ENTRYENTITY);
                HashMap<String, String> entryMap = new HashMap<String, String>();
                for (DynamicObject row : entry) {
                    entryMap.put(row.getString(PROP), row.getString(VALUE));
                }
                valueMap.put(VALUE, entryMap);
                valuedesc = ((Object)entryMap).toString();
                break;
            }
        }
        returnMap.put("valuedesc", valuedesc);
        returnMap.put(VALUE, valueMap);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private void showFormulaForm(String key) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fea_commonformula");
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        showParameter.getCustomParams().put("entitynumber", sourceBill);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String expvalue = (String)this.getModel().getValue(EXPVALUE);
        String expdesc = (String)this.getModel().getValue(EXPDESC);
        if (!StringUtils.isEmpty((CharSequence)expdesc)) {
            CRCondition condition = new CRCondition();
            condition.setExpression(expvalue);
            LocaleString description = new LocaleString();
            description.put(Lang.defaultLang().toString(), (Object)expdesc);
            String formulaJson = SerializationUtils.toJsonString((Object)condition);
            showParameter.getCustomParams().put("formula", formulaJson);
        }
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)sourceBill));
        option.setReadEntryEntity(true);
        option.setExprType(ExpressionType.Formula);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        String toJson = SerializationUtils.toJsonString((Object)tree);
        showParameter.getCustomParams().put("treenodes", toJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "sourcetype": {
                String value = (String)e.getChangeSet()[0].getNewValue();
                this.hidePanel(value);
                break;
            }
        }
    }

    private void hidePanel(String value) {
        switch (value) {
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPPANEL, VALPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{FIXPANEL});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FIXPANEL, VALPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{EXPPANEL});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FIXPANEL, EXPPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{VALPANEL});
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter par = view.getFormShowParameter();
        String valuedesc = (String)par.getCustomParam("valuedesc");
        String value = (String)par.getCustomParam(VALUE);
        Map map = null;
        if (!StringUtils.isEmpty((CharSequence)valuedesc)) {
            JSONObject valueMap = JSONObject.parseObject((String)value);
            IDataModel model = this.getModel();
            String sourcetpye = (String)valueMap.get(SOURCETYPE);
            model.setValue(SOURCETYPE, (Object)sourcetpye);
            switch (sourcetpye) {
                case "1": {
                    model.setValue(FIXVALUE, (Object)valuedesc);
                    break;
                }
                case "2": {
                    model.setValue(EXPDESC, (Object)valuedesc);
                    model.setValue(EXPVALUE, valueMap.get(VALUE));
                    break;
                }
                case "3": {
                    map = (Map)valueMap.get(VALUE);
                    break;
                }
            }
        }
        this.buildEntry(map);
    }

    private void buildEntry(Map<String, String> map) {
        IDataModel model = this.getModel();
        if (map != null) {
            model.batchCreateNewEntryRow(ENTRYENTITY, map.size());
            int index = 0;
            String idValue = map.get("id");
            if (idValue != null) {
                model.setValue(PROP, (Object)"id", index);
                model.setValue(VALUE, (Object)idValue, index++);
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                if ("id".equals(key)) continue;
                model.setValue(PROP, (Object)key, index);
                model.setValue(VALUE, (Object)entry.getValue(), index++);
            }
        } else {
            model.createNewEntryRow(ENTRYENTITY);
            model.setValue(PROP, (Object)"id", 0);
        }
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{PROP});
    }

    public void afterBindData(EventObject e) {
        String radiogroupVal = (String)this.getModel().getValue(SOURCETYPE);
        this.hidePanel(radiogroupVal);
    }

    public void closedCallBack(ClosedCallBackEvent close) {
        String key = close.getActionId();
        Object returnData = close.getReturnData();
        if (returnData != null) {
            switch (key) {
                case "expdesc": {
                    Map map = (Map)returnData;
                    String value = (String)map.get(VALUE);
                    String desc = (String)map.get(DESC);
                    this.getModel().setValue(EXPDESC, (Object)desc);
                    this.getModel().setValue(EXPVALUE, (Object)value);
                }
            }
        }
    }
}

