/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datatype;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fea.enums.datatype.DataTypeEnum;
import kd.fi.fea.enums.datatype.DateTimeFormatterEnum;
import kd.fi.fea.enums.datatype.StrLenRangeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataTypeEditPlugin
extends AbstractFormPlugin {
    private static final String PANEL_STRING = "stringpanel";
    private static final String PANEL_DOUBLE = "doublepanel";
    private static final String PANEL_INT = "intpanel";
    private static final String PANEL_DATE_TIME = "datetimepanel";
    private static final int TOTAL_LEN_MAX = 30;
    private static final int TOTAL_LEN_MIN = 1;
    private static final int DECIMAL_LEN_MAX = 10;
    private static final int DECIMAL_LEN_MIN = 1;
    private static final int SHORT_LEN_MAX = 5;
    private static final int SHORT_LEN_MIN = 1;
    private static final int INT_LEN_MAX = 10;
    private static final int INT_LEN_MIN = 1;
    private static final String CACHE_STANDARD_ID = "cache_standard_id";

    public void beforeBindData(EventObject e) {
        this.buildDataTypeCombo();
        FormShowParameter param = this.getView().getFormShowParameter();
        OperationStatus status = param.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            String type = (String)this.getModel().getValue("type");
            if (type == null) {
                this.setPanelVisible("");
            } else {
                this.setPanelVisible(type);
            }
            String standardIdStr = this.getPageCache().get(CACHE_STANDARD_ID);
            if (StringUtils.isNotBlank((CharSequence)standardIdStr)) {
                this.getModel().setValue("group", (Object)NumberUtils.toLong((String)standardIdStr, (long)0L));
            }
        } else if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            String type = (String)this.getModel().getValue("type");
            this.setPanelVisible(type);
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("type".equals(key)) {
            String type = (String)this.getModel().getValue("type");
            this.setPanelVisible(type);
        }
        if (this.getChangeDesFields().contains(key)) {
            this.setValueDescription();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            if (!this.dataValidityCheck()) {
                args.setCancel(true);
            } else {
                this.clearIndependentData();
                if (source instanceof SaveAndNew) {
                    DynamicObject standard = (DynamicObject)this.getModel().getValue("group");
                    this.getPageCache().put(CACHE_STANDARD_ID, standard.getPkValue().toString());
                }
            }
        }
    }

    private void clearIndependentData() {
        String type = (String)this.getModel().getValue("type");
        if (!DataTypeEnum.STRING.getValue().equals(type)) {
            this.getModel().setValue("lengthrange", (Object)NumberUtils.INTEGER_ZERO);
            this.getModel().setValue("length", (Object)NumberUtils.INTEGER_ZERO);
        }
        if (!DataTypeEnum.DOUBLE.getValue().equals(type) && !DataTypeEnum.DECIMAL.getValue().equals(type)) {
            this.getModel().setValue("totallength", (Object)NumberUtils.INTEGER_ZERO);
            this.getModel().setValue("decimallength", (Object)NumberUtils.INTEGER_ZERO);
        }
        if (!(DataTypeEnum.INT.getValue().equals(type) || DataTypeEnum.SHORT.getValue().equals(type) || DataTypeEnum.NONNEGATIVEINTEGER.getValue().equals(type))) {
            this.getModel().setValue("integerlength", (Object)NumberUtils.INTEGER_ZERO);
        }
        if (!DataTypeEnum.DATE.getValue().equals(type) && !DataTypeEnum.TIME.getValue().equals(type)) {
            this.getModel().setValue("formatter", (Object)"");
        }
    }

    private boolean dataValidityCheck() {
        String formatter;
        int integerLength;
        String type = (String)this.getModel().getValue("type");
        if (DataTypeEnum.STRING.getValue().equals(type)) {
            String lengthRange = (String)this.getModel().getValue("lengthrange");
            int length = (Integer)this.getModel().getValue("length");
            if (StringUtils.isBlank((CharSequence)lengthRange)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u957f\u5ea6\u8303\u56f4\u3002", (String)"DataTypeEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u957f\u5ea6\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\u3002", (String)"DataTypeEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (DataTypeEnum.DOUBLE.getValue().equals(type) || DataTypeEnum.DECIMAL.getValue().equals(type)) {
            int totalLength = (Integer)this.getModel().getValue("totallength");
            int decimalLength = (Integer)this.getModel().getValue("decimallength");
            if (totalLength < 1 || totalLength > 30) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u603b\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u7684\u6570\u636e\u8303\u56f4\uff1a%1$d~%2$d", (String)"DataTypeEditPlugin_13", (String)"fi-fea-formplugin", (Object[])new Object[0]), 1, 30));
                return false;
            }
            if (decimalLength < 1 || decimalLength > 10) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5c0f\u6570\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u7684\u6570\u636e\u8303\u56f4\uff1a%1$d~%2$d", (String)"DataTypeEditPlugin_14", (String)"fi-fea-formplugin", (Object[])new Object[0]), 1, 10));
                return false;
            }
            if (totalLength <= decimalLength) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u603b\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e\u5c0f\u6570\u4f4d\u6570\u3002", (String)"DataTypeEditPlugin_4", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (DataTypeEnum.SHORT.getValue().equals(type) && ((integerLength = ((Integer)this.getModel().getValue("integerlength")).intValue()) < 1 || integerLength > 5)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u7684\u6570\u636e\u8303\u56f4\uff1a%1$d~%2$d", (String)"DataTypeEditPlugin_15", (String)"fi-fea-formplugin", (Object[])new Object[0]), 1, 5));
            return false;
        }
        if (DataTypeEnum.INT.getValue().equals(type) && ((integerLength = ((Integer)this.getModel().getValue("integerlength")).intValue()) < 1 || integerLength > 10)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u7684\u6570\u636e\u8303\u56f4\uff1a%1$d~%2$d", (String)"DataTypeEditPlugin_15", (String)"fi-fea-formplugin", (Object[])new Object[0]), 1, 10));
            return false;
        }
        if ((DataTypeEnum.DATE.getValue().equals(type) || DataTypeEnum.TIME.getValue().equals(type)) && StringUtils.isBlank((CharSequence)(formatter = (String)this.getModel().getValue("formatter")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u683c\u5f0f", (String)"DataTypeEditPlugin_6", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setValueDescription() {
        String type = (String)this.getModel().getValue("type");
        String valueDescription = "";
        if (DataTypeEnum.STRING.getValue().equals(type)) {
            String lengthRange = (String)this.getModel().getValue("lengthrange");
            int length = (Integer)this.getModel().getValue("length");
            if (StrLenRangeEnum.FIXED_VALUE.getValue().equals(lengthRange)) {
                valueDescription = String.format(ResManager.loadKDString((String)"\u56fa\u5b9a\u957f\u5ea6%d", (String)"DataTypeEditPlugin_7", (String)"fi-fea-formplugin", (Object[])new Object[0]), length);
            } else if (StrLenRangeEnum.MAXIMUM.getValue().equals(lengthRange)) {
                valueDescription = String.format(ResManager.loadKDString((String)"\u6700\u5927\u957f\u5ea6%d", (String)"DataTypeEditPlugin_8", (String)"fi-fea-formplugin", (Object[])new Object[0]), length);
            }
        }
        if (DataTypeEnum.DATE.getValue().equals(type) || DataTypeEnum.TIME.getValue().equals(type)) {
            String formatter = (String)this.getModel().getValue("formatter");
            valueDescription = String.format(ResManager.loadKDString((String)"\u957f\u5ea6%d", (String)"DataTypeEditPlugin_9", (String)"fi-fea-formplugin", (Object[])new Object[0]), formatter == null ? 0 : formatter.length());
        }
        if (DataTypeEnum.ANYURI.getValue().equals(type)) {
            valueDescription = ResManager.loadKDString((String)"\u7f51\u5740", (String)"DataTypeEditPlugin_10", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        }
        if (DataTypeEnum.DOUBLE.getValue().equals(type) || DataTypeEnum.DECIMAL.getValue().equals(type)) {
            int totalLength = (Integer)this.getModel().getValue("totallength");
            int decimalLength = (Integer)this.getModel().getValue("decimallength");
            valueDescription = String.format(ResManager.loadKDString((String)"\u6700\u5927\u4f4d\u6570%1$d\uff0c\u5c0f\u6570\u4f4d\u6570%2$d", (String)"DataTypeEditPlugin_16", (String)"fi-fea-formplugin", (Object[])new Object[0]), totalLength, decimalLength);
        }
        if (DataTypeEnum.INT.getValue().equals(type) || DataTypeEnum.SHORT.getValue().equals(type) || DataTypeEnum.NONNEGATIVEINTEGER.getValue().equals(type)) {
            int integerLength = (Integer)this.getModel().getValue("integerlength");
            valueDescription = String.format(ResManager.loadKDString((String)"\u6700\u5927\u4f4d\u6570%d", (String)"DataTypeEditPlugin_12", (String)"fi-fea-formplugin", (Object[])new Object[0]), integerLength);
        }
        this.getModel().setValue("description", (Object)valueDescription);
    }

    private void setPanelVisible(String type) {
        if (DataTypeEnum.STRING.getValue().equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_STRING});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DOUBLE, PANEL_INT, PANEL_DATE_TIME});
        } else if (DataTypeEnum.DATE.getValue().equals(type) || DataTypeEnum.TIME.getValue().equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_DATE_TIME});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DOUBLE, PANEL_INT, PANEL_STRING});
            this.buildDateTimeFormatterCombo(DataTypeEnum.DATE.getValue().equals(type));
            if (this.getModel().getDataChanged()) {
                this.getModel().setValue("formatter", null);
            }
        } else if (DataTypeEnum.DOUBLE.getValue().equals(type) || DataTypeEnum.DECIMAL.getValue().equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_DOUBLE});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_STRING, PANEL_INT, PANEL_DATE_TIME});
        } else if (DataTypeEnum.INT.getValue().equals(type) || DataTypeEnum.SHORT.getValue().equals(type) || DataTypeEnum.NONNEGATIVEINTEGER.getValue().equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_INT});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_DOUBLE, PANEL_STRING, PANEL_DATE_TIME});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_STRING, PANEL_DOUBLE, PANEL_INT, PANEL_DATE_TIME});
        }
    }

    private void buildDataTypeCombo() {
        DataTypeEnum[] typeEnums;
        ComboEdit type = (ComboEdit)this.getView().getControl("type");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (DataTypeEnum typeEnum : typeEnums = DataTypeEnum.values()) {
            String value = typeEnum.getValue();
            ComboItem item = new ComboItem(new LocaleString(value), value);
            items.add(item);
        }
        type.setComboItems(items);
    }

    private void buildDateTimeFormatterCombo(boolean isDate) {
        ComboEdit formatter = (ComboEdit)this.getView().getControl("formatter");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        DateTimeFormatterEnum[] formatterEnums = isDate ? DateTimeFormatterEnum.getDateFormatterEnums() : DateTimeFormatterEnum.getTimeFormatterEnums();
        for (DateTimeFormatterEnum formatterEnum : formatterEnums) {
            String value = formatterEnum.getValue();
            ComboItem item = new ComboItem(new LocaleString(value), value);
            items.add(item);
        }
        formatter.setComboItems(items);
    }

    private List<String> getChangeDesFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("type");
        fields.add("lengthrange");
        fields.add("length");
        fields.add("totallength");
        fields.add("decimallength");
        fields.add("integerlength");
        fields.add("formatter");
        return fields;
    }
}

