/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.element;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class ElementEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BOS_TEMPLATE_TREE_LIST = "bos_templatetreelist";
    private static final String CACHE_STANDARD_ID = "cache_standard_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getView().getControl("type");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String standardIdStr = this.getPageCache().get(CACHE_STANDARD_ID);
        if (StringUtils.isNotBlank((CharSequence)standardIdStr)) {
            this.getModel().setValue("group", (Object)NumberUtils.toLong((String)standardIdStr, (long)0L));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        OperationStatus status = param.getStatus();
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        } else if (OperationStatus.ADDNEW == status) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
        Boolean isAssist = (Boolean)this.getModel().getValue("assistitem");
        if (isAssist.booleanValue()) {
            this.setTipByAssistCount();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            this.checkIsCommon();
            if (source instanceof SaveAndNew) {
                DynamicObject standard = (DynamicObject)this.getModel().getValue("group");
                this.getPageCache().put(CACHE_STANDARD_ID, standard.getPkValue().toString());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "group": {
                this.getModel().setValue("type", null);
                break;
            }
            case "count": {
                this.setTipByAssistCount();
                break;
            }
        }
    }

    private void setTipByAssistCount() {
        int count = (Integer)this.getModel().getValue("count");
        Label label = (Label)this.getControl("assgrprange");
        if (count >= 1) {
            label.setText("1~" + count);
        } else {
            label.setText("");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("type".equals(propName)) {
            DynamicObject standard = (DynamicObject)this.getModel().getValue("group");
            if (standard == null) {
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = param.getListFilterParameter();
            QFilter standardFilter = new QFilter("group", "=", standard.getPkValue());
            filterParam.getQFilters().add(standardFilter);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        Object group;
        super.initImportData(e);
        List dataList = e.getSourceDataList();
        HashSet<String> groupNumSet = new HashSet<String>(4);
        HashSet<String> typeNumSet = new HashSet<String>(10);
        for (Map data : dataList) {
            Map group2 = (Map)data.get("group");
            String groupNumber = (String)group2.get("number");
            groupNumSet.add(groupNumber);
            Map type = (Map)data.get("type");
            String typeNumber = (String)type.get("number");
            typeNumSet.add(typeNumber);
        }
        DynamicObjectCollection groupTypes = QueryServiceHelper.query((String)"fea_datatype", (String)"group.number group, id, number", (QFilter[])new QFilter[]{new QFilter("group.number", "in", groupNumSet), new QFilter("number", "in", typeNumSet)}, (String)"");
        HashMap<String, DynamicObject> groupTypeMap = new HashMap<String, DynamicObject>();
        for (DynamicObject item : groupTypes) {
            group = item.getString("group");
            String number = item.getString("number");
            groupTypeMap.put((String)group + "-" + number, item);
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map data = (Map)dataList.get(i);
            group = (Map)data.get("group");
            String groupNumber = (String)group.get("number");
            Map type = (Map)data.get("type");
            String typeNumber = (String)type.get("number");
            DynamicObject typeItem = (DynamicObject)groupTypeMap.get(groupNumber + "-" + typeNumber);
            if (typeItem == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u6807\u51c6(%1$s)\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a(%2$s)\u7684\u6570\u636e\u7c7b\u578b", (String)"ElementEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]), groupNumber, typeNumber));
                continue;
            }
            type.put("id", typeItem.getLong("id"));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.getModel().setValue("iscommon", (Object)Boolean.TRUE);
    }

    private void checkIsCommon() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (parentView instanceof ListView) {
            String billFormId = parentView.getFormShowParameter().getFormId();
            if (BOS_TEMPLATE_TREE_LIST.equals(billFormId)) {
                this.getModel().setValue("iscommon", (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue("iscommon", (Object)Boolean.FALSE);
            }
        } else {
            this.getModel().setValue("iscommon", (Object)Boolean.FALSE);
        }
    }
}

