/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.export;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.annotation.PluginEvent;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.model.DSField;
import kd.fi.fea.util.AcctTableComAssistUtil;

public class ExportPlanComAssistPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ExportPlanComAssistPlugin.class);
    private static String KEY_COMASSIST = "comassist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit comAssistEdit = (MulBasedataEdit)this.getControl(KEY_COMASSIST);
        comAssistEdit.addBeforeF7SelectListener(evt -> {
            String comAssistFieldStr = this.getPageCache().get("comAssistField");
            if (StringUtils.isEmpty((String)comAssistFieldStr)) {
                return;
            }
            DSField dsField = (DSField)SerializationUtils.deSerializeFromBase64((String)comAssistFieldStr);
            if ("2".equals(dsField.getDataType())) {
                evt.getCustomQFilters().add(new QFilter("group", "=", (Object)dsField.getGroupId()));
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_COMASSIST});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("org".equals(key) || "book".equals(key) || "plan".equals(key)) {
            DSField comAssistField = this.canShowComAssist();
            if (comAssistField == null) {
                this.getModel().setValue(KEY_COMASSIST, null);
                this.getPageCache().remove("comAssistField");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_COMASSIST});
                return;
            }
            MulBasedataEdit bdEdit = (MulBasedataEdit)this.getControl(KEY_COMASSIST);
            bdEdit.setCaption(comAssistField.getFieldName());
            this.getPageCache().put("comAssistField", SerializationUtils.serializeToBase64((Object)comAssistField));
            this.getView().updateControlMetadata(KEY_COMASSIST, bdEdit.createClientConfig());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_COMASSIST});
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        String comAssistFieldStr = this.getPageCache().get("comAssistField");
        if (StringUtils.isEmpty((String)comAssistFieldStr)) {
            return;
        }
        DSField comAssistField = (DSField)SerializationUtils.deSerializeFromBase64((String)comAssistFieldStr);
        MainEntityType oldMainEntityType = e.getOriginalEntityType();
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)oldMainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
        MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperties().get((Object)comAssistField.getFieldKey());
        prop.setBaseEntityId(comAssistField.getEntityId());
        prop.setDbIgnore(false);
        BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
        bPropMul.setBaseEntityId(comAssistField.getEntityId());
        MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)comAssistField.getEntityId());
        bPropMul.setComplexType((IDataEntityType)newDT);
        DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
        bPropMul.setRefIdProp((IDataEntityProperty)refProp);
        bPropMul.setRefIdPropName(refProp.getName());
        bPropMul.setDbIgnore(true);
        e.setNewEntityType(newEntityType);
    }

    @PluginEvent(enableOverride=true)
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate c = (FormOperate)args.getSource();
        String operateKey = c.getOperateKey();
        if (!"export".equals(operateKey)) {
            return;
        }
        DynamicObjectCollection filterComAssist = (DynamicObjectCollection)this.getModel().getValue(KEY_COMASSIST);
        if (filterComAssist.isEmpty()) {
            return;
        }
        String comAssistFieldStr = this.getPageCache().get("comAssistField");
        if (StringUtils.isEmpty((String)comAssistFieldStr)) {
            return;
        }
        DynamicObject planDyn = (DynamicObject)this.getModel().getValue("plan");
        DynamicObject exportPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)planDyn.getPkValue(), (String)planDyn.getDataEntityType().getName());
        DynamicObjectCollection entryentity = exportPlan.getDynamicObjectCollection("entryentity");
        Set structureid = entryentity.stream().map(entry -> entry.getLong("structureid")).collect(Collectors.toSet());
        DynamicObject[] structDyns = BusinessDataServiceHelper.load((String)"fea_datastructure", (String)"id,entity", (QFilter[])new QFilter[]{new QFilter("id", "in", structureid)});
        Set entitySet = Arrays.stream(structDyns).map(row -> row.getString("entity")).collect(Collectors.toSet());
        if (entitySet.contains("bd_accountview") && entitySet.contains("gl_balance") && entitySet.contains("gl_voucher")) {
            return;
        }
        DSField comAssistField = (DSField)SerializationUtils.deSerializeFromBase64((String)comAssistFieldStr);
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\u4e2d\u6ca1\u6709\u5305\u542b\u603b\u8d26\u79d1\u76ee\u3001\u51ed\u8bc1\u6216\u79d1\u76ee\u4f59\u989d\uff0c\u4e0d\u652f\u6301%2$s\u5bfc\u51fa\u3002", (String)"ExportPlanComAssistPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]), planDyn.getString("name"), comAssistField.getFieldName().getLocaleValue()));
    }

    private DSField canShowComAssist() {
        DynamicObject planDyn = (DynamicObject)this.getModel().getValue("plan");
        if (planDyn == null) {
            return null;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.isEmpty()) {
            return null;
        }
        Long bookTypeId = (Long)this.getModel().getValue("book_id");
        if (bookTypeId == null || bookTypeId.equals(0L)) {
            return null;
        }
        DynamicObject standard = BusinessDataServiceHelper.loadSingleFromCache((String)"fea_standard", (String)"filetype", (QFilter[])new QFilter("id", "=", (Object)planDyn.getLong("group.id")).toArray());
        String fileType = standard.getString("filetype");
        FileTypeEnum fileTypeEnum = FileTypeEnum.fromValue((String)fileType);
        if (FileTypeEnum.xml != fileTypeEnum) {
            return null;
        }
        if (!AcctTableComAssistUtil.isSupportComAssist()) {
            return null;
        }
        HashSet<Long> orgList = new HashSet<Long>(orgs.size());
        for (DynamicObject x : orgs) {
            Long fbasedataid_id = x.getLong("fbasedataid_id");
            orgList.add(fbasedataid_id);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(orgList, (long)bookTypeId);
        if (bookInfoList.size() != orgList.size()) {
            logger.info("\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u5230\u7684\u4f1a\u8ba1\u8d26\u7c3f\u6570\u91cf\u4e0d\u7b49\u4e8e\u7ec4\u7ec7\u6570\u91cf");
            return null;
        }
        long acctTableId = 0L;
        for (AccountBookInfo bookInfo : bookInfoList) {
            long orgAcctTableId = bookInfo.getAccountTableId();
            if (orgAcctTableId == 0L) {
                return null;
            }
            if (acctTableId == 0L) {
                acctTableId = orgAcctTableId;
            }
            if (orgAcctTableId == acctTableId) continue;
            return null;
        }
        DSField comAssistField = AcctTableComAssistUtil.queryAcctTableComAssist((long)acctTableId);
        if (comAssistField != null) {
            comAssistField.setFieldKey(KEY_COMASSIST);
        }
        return comAssistField;
    }
}

