/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.enums.PermissonType;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.model.DSField;
import kd.fi.fea.model.FeaOpLogInfo;
import kd.fi.fea.opservice.export.task.TaskFileUtil;
import kd.fi.fea.util.FeaOperateLogUtil;

public class ExportPlanPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ExportPlanPlugin.class);
    private static final String OP_CONFIRM = "export";
    public static final String FROMVIEW = "fromview";
    public static final String USEDEXPORTPLANTEMPLATEVIEW = "usedexportplantemplate";

    public void initialize() {
        super.initialize();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fromview = (String)formShowParameter.getCustomParam(FROMVIEW);
        if (null != fromview && USEDEXPORTPLANTEMPLATEVIEW.equals(fromview)) {
            this.getModel().setValue("org", (Object)new Long[]{Long.parseLong((String)formShowParameter.getCustomParam("org"))});
            this.getModel().setValue("plan", formShowParameter.getCustomParam("plan"));
            DynamicObject plan = QueryServiceHelper.queryOne((String)"fea_plan", (String)"group.filetype fileType", (QFilter[])new QFilter("id", "=", formShowParameter.getCustomParam("plan")).toArray());
            this.getModel().setValue("filetype", plan.get("fileType"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "org": {
                DynamicObjectCollection orgs = (DynamicObjectCollection)value;
                if (orgs.isEmpty()) {
                    return;
                }
                ArrayList<Long> orgList = new ArrayList<Long>();
                for (DynamicObject x : orgs) {
                    Long fbasedataid_id = x.getLong("fbasedataid_id");
                    orgList.add(fbasedataid_id);
                }
                if (orgList.size() == 1) {
                    long id = (Long)orgList.get(0);
                    this.setEntityBookType(id);
                    this.setDefaultPlan(id);
                    break;
                }
                this.setMulBookType(orgList);
                this.setMulPlan(orgList);
                break;
            }
            case "beginperiod": {
                long sp = ((DynamicObject)value).getLong("id");
                long ep = (Long)this.getModel().getValue("endperiod_id");
                if (ep != 0L && ep >= sp) break;
                this.getModel().setValue("endperiod", (Object)sp);
                break;
            }
            case "endperiod": {
                long endPeriod = ((DynamicObject)value).getLong("id");
                long startPeriod = (Long)this.getModel().getValue("beginperiod_id");
                if (startPeriod != 0L && startPeriod <= endPeriod) break;
                this.getModel().setValue("beginperiod", (Object)endPeriod);
                break;
            }
            case "book": {
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
            case "periodtype": {
                String str = this.getPageCache().get("ptSpMap");
                Map ptSpMap = (Map)this.fromSerializedString(str);
                long periodType = ((DynamicObject)value).getLong("id");
                this.setPeriodFilter(periodType, ptSpMap);
                break;
            }
            case "plan": {
                DynamicObject standard = BusinessDataServiceHelper.loadSingleFromCache((String)"fea_standard", (String)"filetype", (QFilter[])new QFilter("id", "=", (Object)((DynamicObject)value).getLong("group.id")).toArray());
                String fileType = standard.getString("filetype");
                this.getModel().setValue("filetype", (Object)(StringUtils.isEmpty((CharSequence)fileType) ? "0" : fileType));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_CONFIRM, (CharSequence)operateKey)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("org");
            HashSet<Object> orgIds = new HashSet<Object>(orgs.size());
            for (DynamicObject orgObj : orgs) {
                DynamicObject org = orgObj.getDynamicObject("fbasedataid");
                orgIds.add(org.getPkValue());
            }
            DynamicObject bookTypeObj = (DynamicObject)model.getValue("book");
            if (bookTypeObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportPlanPlugin_10", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            }
            Object bookType = bookTypeObj.getPkValue();
            String bookTypeName = bookTypeObj.getString("name");
            QFilter[] qFilterList = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("bookstype", "=", bookType)};
            Map accountBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"id, org.id", (QFilter[])qFilterList);
            HashMap<Long, Long> acctBookMap = new HashMap<Long, Long>(accountBooks.size());
            for (DynamicObject acctBook : accountBooks.values()) {
                acctBookMap.put(acctBook.getLong("org.id"), acctBook.getLong("id"));
            }
            for (DynamicObject orgObj : orgs) {
                DynamicObject org = orgObj.getDynamicObject("fbasedataid");
                if (acctBookMap.containsKey(org.getPkValue())) continue;
                String orgName = org.getString("name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"ExportPlanPlugin_9", (String)"fi-fea-formplugin", (Object[])new Object[0]), orgName, bookTypeName));
            }
            this.getPageCache().put("mark", "start");
            ((ProgressBar)this.getControl("progressbarap")).start();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5bfc\u51fa\u6587\u4ef6\uff0c\u8bf7\u7a0d\u7b49...", (String)"ExportPlanPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0])));
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String test = this.getPageCache().get("mark");
        if ("packaging".equalsIgnoreCase(test)) {
            return;
        }
        if (!"finish".equals(test) && !"start".equals(test)) {
            String exportId = this.getPageCache().get("exportId");
            DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(exportId), (String)"fea_export_task");
            if (exportTask != null) {
                String taskStatus = exportTask.getString("taskstatus");
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                if ("B".equals(taskStatus)) {
                    int process = exportTask.getInt("totalprocess");
                    bar.setPercent(process);
                } else if ("C".equals(taskStatus)) {
                    bar.setPercent(100);
                    this.getPageCache().put("mark", "finish");
                } else if ("D".equals(taskStatus)) {
                    log.error("\u5bfc\u51fa\u5931\u8d25,\u5bfc\u51fa\u4efb\u52a1\u72b6\u6001:{}", (Object)taskStatus);
                    this.getPageCache().put("mark", "finish");
                    this.getPageCache().put("result", "error");
                    this.getPageCache().put("msg", ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u5230\u5bfc\u51fa\u4efb\u52a1\u9875\u9762\u67e5\u770b\u5931\u8d25\u539f\u56e0\u3002", (String)"ExportPlanPlugin_6", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("start".equals(test)) {
            this.getPageCache().put("mark", "doing");
            ((ProgressBar)this.getControl("progressbarap")).start();
            IDataModel model = this.getModel();
            try {
                DynamicObject exportTask = this.buildExportTask(model);
                this.getPageCache().put("exportId", exportTask.getPkValue().toString());
            }
            catch (Exception e) {
                log.error("build export task error", (Throwable)e);
                this.getPageCache().put("mark", "finish");
                this.getPageCache().put("result", "error");
                this.getPageCache().put("msg", e.getMessage());
            }
        } else {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.stop();
            String result = this.getPageCache().get("result");
            if ("error".equals(result)) {
                this.getView().hideLoading();
                String errMsg = this.getPageCache().get("msg");
                this.getView().showErrorNotification(errMsg);
                return;
            }
            String exportId = this.getPageCache().get("exportId");
            DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(exportId), (String)"fea_export_task");
            if (exportTask == null) {
                this.getView().hideLoading();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ExportPlanPlugin_7", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskStatus = exportTask.getString("taskstatus");
            if ("D".equals(taskStatus)) {
                log.error("\u5bfc\u51fa\u5931\u8d25,\u5bfc\u51fa\u4efb\u52a1\u72b6\u6001:{}", (Object)taskStatus);
                this.getView().hideLoading();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u5230\u5bfc\u51fa\u4efb\u52a1\u9875\u9762\u67e5\u770b\u5931\u8d25\u539f\u56e0\u3002", (String)"ExportPlanPlugin_6", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("mark", "packaging");
            log.info("\u5f00\u59cb\u6253\u5305\u5bfc\u51fa\u6587\u4ef6\uff0cexportId = {}", (Object)exportId);
            String downloadUrl = TaskFileUtil.handleExportTaskDownloadFile((String)exportId, (DynamicObject)exportTask, null, null);
            log.info("\u7ed3\u675f\u6253\u5305\u5bfc\u51fa\u6587\u4ef6\uff0cexportId = {}", (Object)exportId);
            this.getPageCache().put("msg", ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ExportPlanPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("result", "success");
            this.getPageCache().put("mark", "finish");
            this.getView().download(downloadUrl);
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
            Set<Long> idSet = orgs.stream().map(orgObj -> (Long)orgObj.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            this.addBatchLog(false, idSet);
            this.getView().hideLoading();
            this.getView().showSuccessNotification(this.getPageCache().get("msg"), Integer.valueOf(5000));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void createExportLog(DynamicObjectCollection orgs, DynamicObject plan, DynamicObject group, DynamicObject exportTask) {
        ArrayList<DynamicObject> saveLogs = new ArrayList<DynamicObject>(orgs.size());
        for (DynamicObject org : orgs) {
            DynamicObject exportLog = BusinessDataServiceHelper.newDynamicObject((String)"fea_exportlog");
            exportLog.set("user", (Object)RequestContext.get().getCurrUserId());
            exportLog.set("datetime", (Object)exportTask.getDate("createtime"));
            exportLog.set("filetype", (Object)FileTypeEnum.getName((String)group.getString("filetype")));
            exportLog.set("org", org.getDynamicObject("fbasedataid").getPkValue());
            exportLog.set("plan", plan.getPkValue());
            saveLogs.add(exportLog);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"fea_exportlog", (DynamicObject[])saveLogs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    private DynamicObject buildExportTask(IDataModel model) {
        Object comAssistFieldStr;
        QFilter statusFilter;
        QFilter periodFilter;
        QFilter bookFilter;
        QFilter orgFilter;
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("org");
        HashSet<Object> orgIds = new HashSet<Object>(orgs.size());
        for (DynamicObject orgObj : orgs) {
            DynamicObject org = orgObj.getDynamicObject("fbasedataid");
            orgIds.add(org.getPkValue());
        }
        Object periodType = model.getValue("periodtype_id");
        Object bookType = model.getValue("book_id");
        Object planId = model.getValue("plan_id");
        QFilter planFilter = new QFilter("exportplan_id", "=", planId);
        DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"fea_export_task", (String)"number,taskentry.org.name orgname, taskentry.org orgid", (QFilter[])new QFilter[]{planFilter, orgFilter = new QFilter("taskentry.org", "in", orgIds), bookFilter = new QFilter("book_id", "=", bookType), periodFilter = new QFilter("periodtype_id", "=", periodType), statusFilter = new QFilter("taskstatus", "in", (Object)new String[]{"A", "B"})});
        if (!runningTasks.isEmpty()) {
            ArrayList<String> orgNames = new ArrayList<String>(runningTasks.size());
            HashSet<Long> existsOrgIds = new HashSet<Long>(runningTasks.size());
            for (DynamicObject task : runningTasks) {
                String orgName = task.getString("orgname");
                Long orgId = task.getLong("orgid");
                if (existsOrgIds.contains(orgId)) continue;
                existsOrgIds.add(orgId);
                orgNames.add(orgName);
            }
            throw new KDBizException(ResManager.loadKDString((String)"[%s]\u7ec4\u7ec7\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"ExportPlanPlugin_8", (String)"fi-fea-formplugin", (Object[])new Object[]{String.join((CharSequence)",", orgNames)}));
        }
        DynamicObject exportPlan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"fea_plan");
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)exportPlan.get("group_id"), (String)"fea_standard");
        DynamicObjectCollection planStructs = exportPlan.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> structMap = planStructs.stream().collect(Collectors.toMap(s -> s.getLong("structureid"), s -> s));
        HashMap groupStructMap = new HashMap(5, 1.0f);
        for (DynamicObject struct : planStructs) {
            Long groupId = struct.getLong("standardentryid");
            if (groupStructMap.containsKey(groupId)) {
                ((List)groupStructMap.get(groupId)).add(struct.getLong("structureid"));
                continue;
            }
            ArrayList<Long> structs = new ArrayList<Long>(10);
            structs.add(struct.getLong("structureid"));
            groupStructMap.put(groupId, structs);
        }
        Map structs = BusinessDataServiceHelper.loadFromCache((Object[])structMap.keySet().toArray(), (String)"fea_datastructure");
        Map<Object, String> structEntityMap = structs.values().stream().collect(Collectors.toMap(d -> d.getPkValue(), d -> d.getString("entity")));
        String fileType = FileTypeEnum.getName((String)group.getString("filetype"));
        boolean needAddSingleFile = false;
        Set<Object> needAddSingleEntities = new HashSet(6);
        QFilter bizObjFilter = new QFilter("bizobj.number", "in", structEntityMap.values());
        QFilter singleFilter = new QFilter("singlefile", "=", (Object)true);
        QFilter fileTypeFilter = null;
        fileTypeFilter = FileTypeEnum.xml.getName().equals(fileType) ? new QFilter("filetype", "in", Arrays.asList("2", "0")) : new QFilter("filetype", "in", Arrays.asList("2", "1"));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection singleFileBizObjs = QueryServiceHelper.query((String)"fea_exportpageconfig", (String)"bizobj.number bizobj", (QFilter[])new QFilter[]{bizObjFilter, singleFilter, fileTypeFilter, enableFilter});
        needAddSingleEntities = singleFileBizObjs.stream().map(d -> d.getString("bizobj")).collect(Collectors.toSet());
        needAddSingleFile = !singleFileBizObjs.isEmpty();
        MainEntityType changeBillType = EntityMetadataCache.getDataEntityType((String)"fea_export_task");
        DynamicObject exportTask = new DynamicObject((DynamicObjectType)changeBillType);
        String taskNum = DBServiceHelper.genStringId();
        exportTask.set("number", (Object)taskNum);
        exportTask.set("taskstatus", (Object)"A");
        exportTask.set("exportplan", (Object)exportPlan);
        exportTask.set("book", bookType);
        exportTask.set("periodtype", periodType);
        exportTask.set("beginperiod", model.getValue("beginperiod_id"));
        exportTask.set("endperiod", model.getValue("endperiod_id"));
        DynamicObjectCollection filterComAssist = (DynamicObjectCollection)this.getModel().getValue("comassist");
        if (filterComAssist != null && filterComAssist.size() > 0 && StringUtils.isNotEmpty((CharSequence)(comAssistFieldStr = this.getPageCache().get("comAssistField")))) {
            DSField comAssistField = (DSField)SerializationUtils.deSerializeFromBase64((String)comAssistFieldStr);
            ArrayList<String> names = new ArrayList<String>(filterComAssist.size());
            ArrayList<String> pks = new ArrayList<String>(filterComAssist.size());
            for (DynamicObject filterRow : filterComAssist) {
                Iterator row = filterRow.getDynamicObject("fbasedataid");
                long id = row.getLong("id");
                String name = row.getString("name");
                pks.add(String.valueOf(id));
                names.add(name);
            }
            String joinName = comAssistField.getFieldName().getLocaleValue() + ":" + String.join((CharSequence)";", names);
            exportTask.set("comassistfilter", (Object)(joinName.length() > 80 ? joinName.substring(0, 80) : joinName));
            exportTask.set("comassistfilter_tag", (Object)String.join((CharSequence)",", pks));
        }
        exportTask.set("creater", (Object)RequestContext.get().getCurrUserId());
        exportTask.set("starttime", (Object)KDDateUtils.now());
        for (DynamicObject orgObj : orgs) {
            DynamicObjectCollection taskEntries = exportTask.getDynamicObjectCollection("taskentry");
            DynamicObject org = orgObj.getDynamicObject("fbasedataid");
            DynamicObjectCollection standardEntries = group.getDynamicObjectCollection("standardentry");
            int entrySeq = 0;
            for (DynamicObject fileEntry : standardEntries) {
                List structIds;
                boolean disable = fileEntry.getBoolean("disable");
                Object groupId = fileEntry.getPkValue();
                if (disable) continue;
                if (needAddSingleFile && (structIds = (List)groupStructMap.get(groupId)) != null && structIds.size() > 0) {
                    boolean removeRootFile = false;
                    for (Long structId : structIds) {
                        String bizObjNumber = structEntityMap.get(structId);
                        if (!needAddSingleEntities.contains(bizObjNumber)) continue;
                        DynamicObject taskEntry = taskEntries.addNew();
                        taskEntry.set("seq", (Object)entrySeq++);
                        taskEntry.set("standardentry", fileEntry.getPkValue());
                        taskEntry.set("org", org.getPkValue());
                        taskEntry.set("subtaskstatus", (Object)"A");
                        DynamicObject structObj = (DynamicObject)structs.get(structId);
                        taskEntry.set("zipname", (Object)(fileEntry.getString("filename") + "_" + structObj.getString("name")));
                        taskEntry.set("struct_id", (Object)structId);
                        if (!FileTypeEnum.csv.getName().equals(fileType)) continue;
                        removeRootFile = true;
                    }
                    if (removeRootFile) continue;
                }
                DynamicObject taskEntry = taskEntries.addNew();
                taskEntry.set("seq", (Object)entrySeq++);
                taskEntry.set("standardentry", fileEntry.getPkValue());
                taskEntry.set("org", org.getPkValue());
                taskEntry.set("subtaskstatus", (Object)"A");
                taskEntry.set("zipname", (Object)fileEntry.getString("filename"));
            }
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            OperateOption operateOption = OperateOption.create();
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fea_export_task", (DynamicObject[])new DynamicObject[]{exportTask}, (OperateOption)operateOption);
            if (result.isSuccess()) {
                DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
                HashMap<String, Object> publishBody = new HashMap<String, Object>();
                publishBody.put("exportId", exportTask.getPkValue());
                publishBody.put("planId", planId);
                publishBody.put("periodType", periodType);
                publishBody.put("bookType", bookType);
                publishBody.put("encoding", group.getString("xmlencoding"));
                publishBody.put("fileType", FileTypeEnum.getName((String)group.getString("filetype")));
                publishBody.put("beginPeriod", model.getValue("beginperiod_id"));
                publishBody.put("endPeriod", model.getValue("endperiod_id"));
                MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.fea.task_queue");
                for (DynamicObject task : taskEntry) {
                    publishBody.put("subTask", task.getPkValue());
                    publishBody.put("retry", false);
                    pub.publishInDbTranscation("" + exportPlan.getPkValue(), publishBody);
                }
                pub.close();
                this.createExportLog(orgs, exportPlan, group, exportTask);
                Iterator iterator = exportTask;
                return iterator;
            }
            try {
                try {
                    throw new KDBizException(result.getMessage());
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void setF7ClickFilter(BasedataEdit edit, QFilter qFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (qFilter != null) {
            list.add(qFilter);
        }
        edit.setQFilters(list);
    }

    private void initOrg() {
        boolean isSupVir = false;
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)isSupVir, (PermissonType)PermissonType.VIEW);
        this.setF7ClickFilter(orgEdit, new QFilter("id", "in", (Object)orgList));
        Long orgId = this.getDefaultOrg(orgList);
        if (orgId == null) {
            return;
        }
        this.setDefaultOrg(orgId);
        this.setEntityBookType(orgId);
        this.setDefaultPlan(orgId);
    }

    private void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("org", null);
        } else {
            this.getModel().setValue("org", (Object)new Long[]{orgId});
        }
    }

    private Long getDefaultOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }

    private void setDefaultPlan(Long orgId) {
        long planId = this.getDefaultPlan(orgId);
        if (0L != planId) {
            BasedataEdit planEdit = (BasedataEdit)this.getControl("plan");
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fea_plan", (Long)orgId);
            this.setF7ClickFilter(planEdit, baseDataFilter);
            this.getModel().setValue("plan", (Object)planId);
            DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
            DynamicObject standard = QueryServiceHelper.queryOne((String)"fea_standard", (String)"filetype", (QFilter[])new QFilter("id", "=", (Object)plan.getLong("group.id")).toArray());
            String fileType = standard.getString("filetype");
            this.getModel().setValue("filetype", (Object)(StringUtils.isEmpty((CharSequence)fileType) ? "0" : fileType));
        } else {
            this.getModel().setValue("plan", null);
        }
    }

    private long getDefaultPlan(Long orgId) {
        long planId = 0L;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fea_plan", (Long)orgId);
        QFilter[] qFilters = new QFilter[]{baseDataFilter};
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"fea_plan", (String)"id", (QFilter[])qFilters);
        if (null != plans && plans.length > 0) {
            planId = plans[0].getLong("id");
        }
        return planId;
    }

    private void setMulPlan(List<Long> orgList) {
        Long orgId = this.getDefaultOrg(orgList);
        this.setDefaultPlan(orgId);
    }

    private void setEntityBookType(Long orgId) {
        HashSet<Long> childOrg = new HashSet<Long>();
        childOrg.add(orgId);
        this.getPageCache().put("_childOrgSet", this.toSerializedString(childOrg));
        Long defaultBookType = null;
        List bookTypes = AccSysUtil.getAllBookTypeByOrg((long)orgId);
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.get(0);
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBT(Collection<Long> bookTypes, long defaultBookType) {
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("book");
        this.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", bookTypes));
        this.getModel().setValue("book", (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    private void setMulBookType(List<Long> orgList) {
        Long defaultBookType = null;
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        QFilter orgFiler = new QFilter("org", "in", orgList);
        List ids = AccSysUtil.getBookTypeDataPermission(orgList);
        if (ids != null) {
            orgFiler = orgFiler.and(new QFilter("bookstype", "in", (Object)ids));
        }
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler, entityFilter});
        HashSet<Long> childOrg = new HashSet<Long>();
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if ("1".equals(bt.getString("type"))) {
                defaultBookType = bt.getLong("id");
            }
            childOrg.add(bt.getLong("org"));
        }
        this.getPageCache().put("_childOrgSet", this.toSerializedString(childOrg));
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.iterator().next();
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBook(Long bookTypeId) {
        IDataModel model = this.getModel();
        Set childOrgSet = new HashSet();
        String str = this.getPageCache().get("_childOrgSet");
        if (str != null) {
            childOrgSet = (Set)this.fromSerializedString(str);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        HashSet<Long> periodTypes = new HashSet<Long>(bookInfoList.size());
        long defaultPeriodType = 0L;
        Long defaultCurPeriod = 0L;
        HashMap<Long, Set<Long>> ptSpMap = new HashMap<Long, Set<Long>>();
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long periodtype = book.getPeriodTypeId();
            long startperiod = book.getStartPeriodId();
            this.putMap(ptSpMap, periodtype, startperiod);
            periodTypes.add(periodtype);
            if (i != 0) continue;
            defaultPeriodType = periodtype;
            defaultCurPeriod = book.getCurPeriodId();
        }
        this.getPageCache().put("ptSpMap", this.toSerializedString(ptSpMap));
        this.setPeriodFilter(defaultPeriodType, ptSpMap);
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl("periodtype");
        this.setF7ClickFilter(periodTypeEdit, new QFilter("id", "in", periodTypes));
        model.setValue("periodtype", (Object)defaultPeriodType);
        model.setValue("beginperiod", (Object)defaultCurPeriod);
        model.setValue("endperiod", (Object)defaultCurPeriod);
    }

    private void setPeriodFilter(long periodType, Map<Long, Set<Long>> ptSpMap) {
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("beginperiod");
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        Set<Long> spSet = ptSpMap.get(periodType);
        Long minPeriod = spSet == null || spSet.size() == 0 ? null : Collections.min(spSet);
        this.setF7ClickFilter(startPeriod, new QFilter("id", ">=", (Object)minPeriod));
        this.setF7ClickFilter(startPeriod, new QFilter("periodtype", "=", (Object)periodType));
        this.setF7ClickFilter(endPeriod, new QFilter("id", ">=", (Object)minPeriod));
        this.setF7ClickFilter(endPeriod, new QFilter("periodtype", "=", (Object)periodType));
        this.getModel().setValue("beginperiod", (Object)minPeriod);
        this.getModel().setValue("endperiod", (Object)minPeriod);
    }

    private <K, V> void putMap(Map<K, Set<V>> map, K key, V value) {
        Set<V> accSet = map.get(key);
        if (null != accSet) {
            accSet.add(value);
            map.put(key, accSet);
        } else {
            accSet = new HashSet<V>();
            accSet.add(value);
            map.put(key, accSet);
        }
    }

    private String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void addBatchLog(boolean isError, Set<Long> orgs) {
        String opName = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ExportPlanPlugin_3", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        String description = ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ExportPlanPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        if (isError) {
            description = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"ExportPlanPlugin_4", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        }
        if (null == orgs || orgs.size() == 0) {
            return;
        }
        if (orgs.size() == 1) {
            FeaOpLogInfo logInfo = FeaOperateLogUtil.buildOpLog((String)"fea_exportplan", (String)opName, (String)description, (long)orgs.iterator().next());
            FeaOperateLogUtil.addLog((FeaOpLogInfo)logInfo);
        } else {
            ArrayList<FeaOpLogInfo> appLogInfos = new ArrayList<FeaOpLogInfo>(orgs.size());
            for (Long org : orgs) {
                appLogInfos.add(FeaOperateLogUtil.buildOpLog((String)"fea_exportplan", (String)opName, (String)description, (long)org));
            }
            FeaOperateLogUtil.addBatchLog(appLogInfos);
        }
    }
}

