/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.export;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fea.opservice.export.task.TaskFileUtil;
import kd.fi.fea.util.ThrowableHelper;
import org.apache.commons.collections4.MapUtils;

public class ExportTaskDownTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ExportTaskDownTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        Object taskId = param.get("task");
        boolean onlyEntry = MapUtils.getBoolean(param, (Object)"onlyEntry");
        DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fea_export_task");
        try {
            String downUrl = "";
            if (onlyEntry) {
                DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
                Collection entryIdSet = (Collection)param.get("entryIdSet");
                DynamicObjectCollection downEntry = new DynamicObjectCollection();
                for (DynamicObject entry : taskEntry) {
                    Object entryPk = entry.getPkValue();
                    if (!entryIdSet.contains(entryPk)) continue;
                    downEntry.add((Object)entry);
                }
                downUrl = TaskFileUtil.handleExportTaskDownloadFile((String)taskId.toString(), (DynamicObjectCollection)downEntry, arg_0 -> ((ExportTaskDownTask)this).feedbackProgress(arg_0), this::isUserStop);
            } else {
                downUrl = TaskFileUtil.handleExportTaskDownloadFile((String)taskId.toString(), (DynamicObject)exportTask, arg_0 -> ((ExportTaskDownTask)this).feedbackProgress(arg_0), this::isUserStop);
            }
            try {
                DynamicObjectCollection taskEntries = exportTask.getDynamicObjectCollection("taskentry");
                long planId = exportTask.getLong("exportplan_id");
                HashSet<Long> orgIds = new HashSet<Long>(taskEntries.size());
                for (DynamicObject task : taskEntries) {
                    long orgId = task.getLong("org_id");
                    orgIds.add(orgId);
                }
                TaskFileUtil.saveDownloadLog(orgIds, (long)planId);
            }
            catch (Exception e) {
                logger.info("\u5bfc\u51fa\u6210\u529f\uff0c\u4f46\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Object)e);
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("success", "true");
            result.put("downUrl", downUrl);
            this.feedbackCustomdata(result);
        }
        catch (Throwable e) {
            String errorMsg = ThrowableHelper.toString((Throwable)e);
            logger.error(errorMsg);
            throw new KDBizException(errorMsg);
        }
    }

    private boolean isUserStop() {
        boolean stop = this.isStop();
        if (stop) {
            this.stop();
        }
        return stop;
    }

    public static void createAndDispatchTask(Object taskPk, Set<Object> entryIdSet, IFormPlugin formPlugin, IFormView view) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("fea");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d", (String)"ExportTaskDownTask_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        jobInfo.setId("task" + taskPk);
        jobInfo.setTaskClassname("kd.fi.fea.export.ExportTaskDownTask");
        jobInfo.setCanStop(Boolean.valueOf(true));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("task", taskPk);
        params.put("onlyEntry", CollectionUtils.isNotEmpty(entryIdSet));
        params.put("entryIdSet", entryIdSet);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack(formPlugin, "taskcloseback");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setCanStop(true);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setClickClassName("kd.fi.fea.export.ExportTaskDownClick");
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }
}

