/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.export;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.export.ExportTaskDownTask;
import kd.fi.fea.opservice.export.task.TaskFileUtil;

public class ExportTaskEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObject exportPlan = (DynamicObject)model.getValue("exportplan");
        DynamicObject standardGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)exportPlan.getLong("group_id"), (String)"fea_standard");
        DynamicObjectCollection standardEntries = standardGroup.getDynamicObjectCollection("standardentry");
        HashMap<Long, String> entryNameMap = new HashMap<Long, String>(standardEntries.size(), 1.0f);
        for (DynamicObject entry : standardEntries) {
            String fileName = entry.getString("filename");
            entryNameMap.put((Long)entry.getPkValue(), fileName);
        }
        Date now = KDDateUtils.now();
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
        for (DynamicObject task : taskEntry) {
            long standardEntry = task.getLong("standardentry");
            String fileName = (String)entryNameMap.get(standardEntry);
            task.set("standardentrytext", (Object)fileName);
            String status = task.getString("subtaskstatus");
            if (!"C".equals(status)) continue;
            Date expireTime = task.getDate("fileexpiretime");
            if (expireTime != null && !now.before(expireTime)) {
                task.set("filetimeout", (Object)true);
                continue;
            }
            task.set("filetimeout", (Object)false);
        }
        model.setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        IDataModel model = this.getModel();
        if ("bar_totaldown".equals(itemkey)) {
            Object exportId = model.getDataEntity().getPkValue();
            DynamicObjectCollection taskEntry = this.getModel().getDataEntity().getDynamicObjectCollection("taskentry");
            TaskFileUtil.checkFileExistsByTime((DynamicObjectCollection)taskEntry);
            ExportTaskDownTask.createAndDispatchTask(exportId.toString(), null, (IFormPlugin)this, this.getView());
        } else if ("bar_download".equals(itemkey)) {
            this.entryDownload(model);
        } else if ("bar_retry".equals(itemkey)) {
            this.entryRetryTask(model);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("taskcloseback".equals(evt.getActionId())) {
            this.taskcloseback(evt.getReturnData());
        }
    }

    private void taskcloseback(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result = (Map)returnData;
        if (result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map downData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            String downUrl = (String)downData.get("downUrl");
            this.getView().download(downUrl);
        }
    }

    private void entryRetryTask(IDataModel model) {
        DynamicObject exportTask = model.getDataEntity();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("taskentry").getSelectedRows();
        if (rowIndexs.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6267\u884c\u3002", (String)"ExportTaskEditPlugin_4", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
        for (int index : rowIndexs) {
            DynamicObject task = (DynamicObject)taskEntry.get(index);
            String status = task.getString("subtaskstatus");
            if (!"A".equals(status) && !"B".equals(status)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7b49\u5f85\u548c\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u4e0d\u80fd\u91cd\u65b0\u5f00\u59cb\u3002", (String)"ExportTaskEditPlugin_3", (String)"fi-fea-formplugin", (Object[])new Object[]{index + 1}));
        }
        Long planId = exportTask.getLong("exportplan_id");
        DynamicObject exportPlan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"fea_plan");
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)exportPlan.get("group_id"), (String)"fea_standard");
        HashMap<String, Object> publishBody = new HashMap<String, Object>(16);
        publishBody.put("exportId", exportTask.getPkValue());
        publishBody.put("planId", planId);
        publishBody.put("periodType", exportTask.getLong("periodtype_id"));
        publishBody.put("bookType", exportTask.getLong("book_id"));
        publishBody.put("encoding", group.getString("xmlencoding"));
        publishBody.put("fileType", FileTypeEnum.getName((String)group.getString("filetype")));
        publishBody.put("beginPeriod", exportTask.getLong("beginperiod_id"));
        publishBody.put("endPeriod", exportTask.getLong("endperiod_id"));
        MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.fea.task_queue");
        for (int index : rowIndexs) {
            DynamicObject task = (DynamicObject)taskEntry.get(index);
            publishBody.put("subTask", task.getPkValue());
            publishBody.put("retry", true);
            pub.publish(publishBody);
        }
        pub.close();
    }

    private void entryDownload(IDataModel model) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("taskentry").getSelectedRows();
        if (rowIndexs.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u4e0b\u8f7d\u3002", (String)"ExportTaskEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
        Date now = KDDateUtils.now();
        HashSet<Object> entryIdSet = new HashSet<Object>(rowIndexs.length);
        for (int index : rowIndexs) {
            DynamicObject entry = (DynamicObject)taskEntry.get(index);
            Object entryPk = entry.getPkValue();
            String status = entry.getString("subtaskstatus");
            if (!"C".equals(status)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u7684\u4efb\u52a1\u4e0d\u80fd\u9009\u62e9\u4e0b\u8f7d\u3002", (String)"ExportTaskEditPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[]{index + 1}));
            }
            Date expireTime = entry.getDate("fileexpiretime");
            if (expireTime != null && !now.before(expireTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u3002", (String)"ExportTaskEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[]{index + 1}));
            }
            entryIdSet.add(entryPk);
        }
        ExportTaskDownTask.createAndDispatchTask(this.getModel().getDataEntity().getPkValue(), entryIdSet, (IFormPlugin)this, this.getView());
    }
}

