/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.export;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.export.ExportTaskDownTask;
import kd.fi.fea.opservice.export.task.TaskFileUtil;

public class ExportTaskListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(ExportTaskListPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IListView view = (IListView)this.getView();
        if ("btn_download".equals(key)) {
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            if (selectedRows.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u4e0b\u8f7d\u3002", (String)"ExportTaskListPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            }
            if (selectedRows.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u4e0b\u8f7d\u3002", (String)"ExportTaskListPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            }
            Object pkValue = selectedRows.getPrimaryKeyValues()[0];
            DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"fea_export_task");
            if (exportTask == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ExportTaskListPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            }
            String taskStatus = exportTask.getString("taskstatus");
            if (!"C".equals(taskStatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u624d\u80fd\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6\u3002", (String)"ExportTaskListPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
            TaskFileUtil.checkFileExistsByTime((DynamicObjectCollection)taskEntry);
            ExportTaskDownTask.createAndDispatchTask(pkValue, null, (IFormPlugin)this, this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("taskcloseback".equals(evt.getActionId())) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            this.taskcloseback(returnData);
        }
    }

    private void taskcloseback(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result = (Map)returnData;
        if (result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map downData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            String downUrl = (String)downData.get("downUrl");
            this.getView().download(downUrl);
        }
    }
}

