/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.index;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.enums.PermissonType;

public class FeaHomePlugin
extends AbstractFormPlugin {
    public static final String ORGID = "orgid";
    private static final String CACHE_IS_RECOVERY_ORG = "cache_is_recovery_org";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)"fea", (String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)true);
        List orgList = allPermOrgs.getHasPermOrgs();
        Long org = AccSysUtil.getDefaultAcctOrg((List)orgList);
        this.getModel().setValue(ORGID, (Object)org);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(ORGID);
        final String entityId = this.getView().getEntityId();
        orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
                if (filters == null) {
                    filters = new ArrayList<QFilter>(1);
                    param.getListFilterParameter().setQFilters(filters);
                }
                HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)"fea", (String)entityId, (String)"47150e89000000ac", (boolean)true);
                List orgList = allPermOrgs.getHasPermOrgs();
                filters.add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CACHE_IS_RECOVERY_ORG))) {
            return;
        }
        switch (propertyName = e.getProperty().getName()) {
            case "orgid": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue == null) {
                    this.getPageCache().put(CACHE_IS_RECOVERY_ORG, "true");
                    this.getModel().setValue(ORGID, e.getChangeSet()[0].getOldValue());
                    this.getPageCache().remove(CACHE_IS_RECOVERY_ORG);
                    return;
                }
                this.refreshView();
                break;
            }
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap(16);
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    private List<Long> getPermOrgRs() {
        String appId = AppMetadataCache.getAppInfo((String)"fea").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        if (!permOrgRs.hasAllOrgPerm() && permOrgRs.getHasPermOrgs().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5916\u90e8\u5ba1\u8ba1\u9996\u9875\u6743\u9650\uff0c\u8bf7\u5148\u5206\u914d\u6743\u9650", (String)"FeaHomePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
        if (orgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5df2\u542f\u7528\u7684\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e", (String)"FeaHomePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        return orgList;
    }
}

