/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.plan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fea.util.StructureUtil;
import org.apache.commons.lang3.StringUtils;

public class ExportPlanEditPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener {
    private static final String DELETEENTRY = "deleteentry";
    private static final String MOVEUP = "moveup";
    private static final String MOVEDOWN = "movedown";
    private static final int DIR_UP = -1;
    private static final int DIR_DOWN = 1;
    private static final String TREE_CTRL = "tv_fields";
    private static final String EID = "eid";
    private static final String FILENAME = "filename";
    private static final String GROUP = "group";
    private static final String TREEVIEWPANEL = "splitpanelap";
    private static final String TOOLBARAP = "advcontoolbarap";
    private static final String FEA_PLANENTRY = "t_fea_planentry";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STRANDARDENTRYID = "standardentryid";
    private static final String STRUCTUREID = "structureid";
    private static final String LASTTREENODE = "lasttreenode";
    private static final String[] ENTRYFIELDS = new String[]{"id", "standardentryid", "structureid"};
    private static final String[] ELEMENTFIELDS = new String[]{"refid", "refentryid", "pid", "type", "multype", "value", "valuedesc", "id"};

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "baritemaddsub": {
                StructureUtil.showF7ListView(key, this.getView(), (IFormPlugin)this);
                break;
            }
            case "deleteentry": {
                this.deleteEntry();
                break;
            }
            case "moveup": {
                this.moveEntry(-1);
                break;
            }
            case "movedown": {
                this.moveEntry(1);
                break;
            }
        }
    }

    private void moveEntry(int direction) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
            return;
        }
        long standardentryid = Long.parseLong(focusNodeId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(TREEENTRYENTITY).getSelectedRows();
        if (rowIndexs.length > 0) {
            ArrayList<Long> selectStructureIds = new ArrayList<Long>(rowIndexs.length);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getService(IDataModel.class);
            for (int i : rowIndexs) {
                DynamicObject dyo;
                DynamicObject row = model.getEntryEntity(TREEENTRYENTITY, i);
                String multype = row.getString("multype");
                if (!"fea_datastructure".equals(multype) || row.getLong("pid") != 0L || (dyo = row.getDynamicObject("refid")) == null) continue;
                selectStructureIds.add(dyo.getLong("id"));
            }
            if (!selectStructureIds.isEmpty()) {
                DynamicObjectCollection entry = model.getEntityEntity(ENTRYENTITY);
                ArrayList<Integer> allStructsIndexs = new ArrayList<Integer>(selectStructureIds.size());
                ArrayList<Integer> selectStructsIndexs = new ArrayList<Integer>(selectStructureIds.size());
                ArrayList<Long> allStructIds = new ArrayList<Long>(selectStructureIds.size());
                for (int i = 0; i < entry.size(); ++i) {
                    DynamicObject row = (DynamicObject)entry.get(i);
                    long curStandardId = row.getLong(STRANDARDENTRYID);
                    long structureId = row.getLong(STRUCTUREID);
                    if (standardentryid != curStandardId) continue;
                    allStructIds.add(structureId);
                    allStructsIndexs.add(i);
                    if (!selectStructureIds.contains(structureId)) continue;
                    selectStructsIndexs.add(allStructsIndexs.size() - 1 + direction);
                }
                if (selectStructsIndexs.isEmpty() || (Integer)selectStructsIndexs.get(0) < 0 || (Integer)selectStructsIndexs.get(selectStructsIndexs.size() - 1) > allStructsIndexs.size() - 1) {
                    return;
                }
                if (direction == -1) {
                    model.moveEntryRowsUp(TREEENTRYENTITY, rowIndexs);
                } else {
                    model.moveEntryRowsDown(TREEENTRYENTITY, rowIndexs);
                }
                model.beginInit();
                allStructIds.removeAll(selectStructureIds);
                int unSelectIndex = 0;
                for (int i = 0; i < allStructsIndexs.size(); ++i) {
                    int realIndex = (Integer)allStructsIndexs.get(i);
                    int selectIndex = selectStructsIndexs.indexOf(i);
                    if (selectIndex != -1) {
                        model.setValue(STRUCTUREID, selectStructureIds.get(selectIndex), realIndex);
                        continue;
                    }
                    model.setValue(STRUCTUREID, allStructIds.get(unSelectIndex++), realIndex);
                }
                model.endInit();
                this.getView().updateView(ENTRYENTITY);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExportPlanEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteEntry() {
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(TREEENTRYENTITY).getSelectedRows();
        if (rowIndexs.length > 0 && rowIndexs[0] != -1) {
            DynamicObjectCollection treeentry = model.getEntryEntity(TREEENTRYENTITY);
            ArrayList<Long> structeIds = new ArrayList<Long>(5);
            for (int index : rowIndexs) {
                DynamicObject row = (DynamicObject)treeentry.get(index);
                DynamicObject refid = row.getDynamicObject("refid");
                if (row.getLong("pid") != 0L || refid == null) continue;
                structeIds.add(refid.getLong("id"));
            }
            DynamicObjectCollection entry = model.getEntryEntity(ENTRYENTITY);
            ArrayList<Integer> delEntryIndexs = new ArrayList<Integer>(structeIds.size());
            for (int i = 0; i < entry.size(); ++i) {
                long structureid = ((DynamicObject)entry.get(i)).getLong(STRUCTUREID);
                if (!structeIds.contains(structureid)) continue;
                delEntryIndexs.add(i);
            }
            int[] delEntryIds = new int[delEntryIndexs.size()];
            for (int i = 0; i < delEntryIds.length; ++i) {
                delEntryIds[i] = (Integer)delEntryIndexs.get(i);
            }
            model.deleteEntryRows(TREEENTRYENTITY, rowIndexs);
            model.deleteEntryRows(ENTRYENTITY, delEntryIds);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExportPlanEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterLoadData(EventObject e) {
        DynamicObject standard = (DynamicObject)this.getModel().getValue(GROUP);
        if (standard != null) {
            this.initTree(standard.getLong("id"));
            TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
            long standardentryid = Long.parseLong(tree.getTreeState().getFocusNodeId());
            Object[] ids = (Object[])this.getEntryIdTuple((long)standardentryid).t2;
            if (ids.length != 0) {
                this.rebuildEntry(standardentryid, ids);
            }
        }
    }

    public void afterBindData(EventObject e) {
        Boolean iscopy;
        DynamicObject standard;
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        OperationStatus status = param.getStatus();
        if (status == OperationStatus.ADDNEW && (standard = (DynamicObject)this.getModel().getValue(GROUP)) != null) {
            this.initTree(standard.getLong("id"));
        }
        if ((iscopy = (Boolean)param.getCustomParam("iscopy")) != null && iscopy.booleanValue()) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
            long[] entryids = DBServiceHelper.genLongIds((String)FEA_PLANENTRY, (int)entry.size());
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                row.set("id", (Object)entryids[i]);
            }
            TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
            Map nodeMap = tree.getTreeState().getFocusNode();
            long standardentryid = Long.parseLong(String.valueOf(nodeMap.get("id")));
            Object[] ids = (Object[])this.getEntryIdTuple((long)standardentryid).t2;
            if (ids.length != 0) {
                this.rebuildEntry(standardentryid, ids);
            }
        }
    }

    private void initTree(long id) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
        tree.deleteAllNodes();
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        QFilter disableFilter = new QFilter("standardentry.disable", "=", (Object)"0");
        DynamicObjectCollection standards = QueryServiceHelper.query((String)"fea_standard", (String)"standardentry.filename filename,standardentry.id eid", (QFilter[])new QFilter[]{idFilter, disableFilter});
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(standards.size());
        for (DynamicObject standard : standards) {
            TreeNode root = new TreeNode();
            root.setId(standard.getString(EID));
            root.setText(standard.getString(FILENAME));
            root.setIsOpened(true);
            nodes.add(root);
        }
        tree.addNodes(nodes);
        this.getPageCache().put(LASTTREENODE, ((TreeNode)nodes.get(0)).getId());
        tree.focusNode((TreeNode)nodes.get(0));
        this.getView().setVisible(Boolean.valueOf(standards.size() != 1), new String[]{TREEVIEWPANEL});
    }

    private Tuple2<Map<Object, Object>, Object[]> getEntryIdTuple(long standardentryid) {
        ArrayList<Long> idsList = new ArrayList<Long>(5);
        HashMap<Long, Long> entryidMap = new HashMap<Long, Long>(5);
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject row : entry) {
            long rowstandardentryid = row.getLong(STRANDARDENTRYID);
            long structureid = row.getLong(STRUCTUREID);
            if (rowstandardentryid != standardentryid) continue;
            entryidMap.put(structureid, row.getLong("id"));
            idsList.add(structureid);
        }
        return new Tuple2(entryidMap, (Object)idsList.toArray());
    }

    private void addEntryLevel(long standardentryid, Object[] ids) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(ids.length);
        long[] entryids = DBServiceHelper.genLongIds((String)FEA_PLANENTRY, (int)ids.length);
        for (int i = 0; i < ids.length; ++i) {
            ArrayList<Object> row = new ArrayList<Object>(3);
            row.add(entryids[i]);
            row.add(standardentryid);
            row.add(ids[i]);
            rows.add(row);
        }
        StructureUtil.addLevel(ENTRYFIELDS, rows, this.getView(), ENTRYENTITY);
    }

    private void rebuildEntry(long standardentryid, Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getModel().deleteEntryData(TREEENTRYENTITY);
        } else {
            List<List<Object>> rows = StructureUtil.getLevelRows(ids, "baritemaddsub", false, (Map)this.getEntryIdTuple((long)standardentryid).t1);
            StructureUtil.addLevel(ELEMENTFIELDS, rows, this.getView(), TREEENTRYENTITY);
            StructureUtil.fillEntry(this.getModel());
        }
    }

    public void closedCallBack(ClosedCallBackEvent close) {
        super.closedCallBack(close);
        String key = close.getActionId();
        Object returnData = close.getReturnData();
        switch (key) {
            case "baritemaddsub": {
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection selects = (ListSelectedRowCollection)returnData;
                Object[] ids = selects.getPrimaryKeyValues();
                TreeView tree = (TreeView)this.getView().getControl(TREE_CTRL);
                Map nodeMap = tree.getTreeState().getFocusNode();
                if (nodeMap == null || nodeMap.get("id") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9", (String)"ExportPlanEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                    return;
                }
                long standardentryid = Long.parseLong(String.valueOf(nodeMap.get("id")));
                this.addEntryLevel(standardentryid, ids);
                this.rebuildEntry(standardentryid, ids);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IPageCache pagecache = this.getPageCache();
        String nodeId = (String)evt.getNodeId();
        String lastNodeId = pagecache.get(LASTTREENODE);
        if (lastNodeId != null && !lastNodeId.equals(nodeId)) {
            pagecache.put(LASTTREENODE, nodeId);
            long standardentryid = Long.parseLong(nodeId);
            this.rebuildEntry(standardentryid, null);
            Object[] ids = (Object[])this.getEntryIdTuple((long)standardentryid).t2;
            if (ids.length != 0) {
                this.rebuildEntry(standardentryid, ids);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        switch (keyName = e.getProperty().getName()) {
            case "group": {
                DynamicObject group = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().deleteEntryData(TREEENTRYENTITY);
                if (group == null) break;
                this.initTree(group.getLong("id"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        e.getOperateKey();
    }
}

