/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.record;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.fea.util.FeaPermissionUtils;
import kd.fi.fea.util.FeaUtil;

public class FeaRecordFilterList
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void setFilter(SetFilterEvent e) {
        this.appendFilter(e);
        e.setOrderBy("datetime desc");
    }

    protected void appendFilter(SetFilterEvent e) {
        String filterStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("appendedFilter") != null && StringUtils.isNotBlank((CharSequence)(filterStr = (String)customParams.get("appendedFilter")))) {
            QFilter filter = QFilter.fromSerializedString((String)filterStr);
            e.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
        }
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String field = commFilter.getFieldName();
            if (!"org.name".equals(field) && !"org.number".equals(field) && !"org.id".equals(field)) continue;
            String defaultOrgid = "";
            String orgFilterObjId = (String)paramMap.get("org");
            String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getBillFormId();
            List comboItems = FeaPermissionUtils.getAllEnablePermissionOrgsCombos((String)billFormID);
            commFilter.setComboItems(comboItems);
            if (null == comboItems || comboItems.size() <= 0) continue;
            defaultOrgid = orgFilterObjId != null ? orgFilterObjId : FeaUtil.getDefaultOrgId((List)comboItems);
            this.getPageCache().put("org", defaultOrgid);
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) continue;
            commFilter.setDefaultValue(defaultOrgid);
            if (sFilter == null) continue;
            String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(v -> v.getValue()).map(Object::toString).reduce("", String::concat);
            commFilter.setDefaultValue(transOrg);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        if (customlist != null) {
            if (customlist.size() == 0) {
                return;
            }
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("org.id")) continue;
                    String key = (String)listValue.get(j);
                    this.getPageCache().put("org", key);
                    this.getPageCache().put(IS_CLICK_ORG, "yes");
                }
            }
        } else if (schemelist != null ? schemelist.size() == 0 : fastlist != null && fastlist.size() == 0) {
            return;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
    }
}

