/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.standard;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fea.enums.XmlEncodingEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StandardEditPlugin
extends AbstractFormPlugin {
    private static final String CALL_BACK_XML_STATEMENT = "call_back_xml_statement";
    private static final String CACHE_EDIT_ROW = "cache_edit_row";
    private static final Log log = LogFactory.getLog(StandardEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"xmlstatement"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setXmlStatement();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fileType = (String)this.getModel().getValue("filetype");
        this.setEncodingItems(fileType);
    }

    private void setEncodingItems(String fileType) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        if ("1".equals(fileType)) {
            ComboItem gbkItem = new ComboItem(new LocaleString(XmlEncodingEnum.GBK.getName()), "2");
            items.add(gbkItem);
            ComboItem utf8Item = new ComboItem(new LocaleString(XmlEncodingEnum.OTHER.getName()), "1");
            items.add(utf8Item);
        } else {
            ComboItem gbItem = new ComboItem(new LocaleString(XmlEncodingEnum.COMPANY.getName()), "0");
            items.add(gbItem);
            ComboItem utf8Item = new ComboItem(new LocaleString(XmlEncodingEnum.OTHER.getName()), "1");
            items.add(utf8Item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("xmlencoding");
        comboEdit.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("xmlstatement".equals(key)) {
            EntryGrid standardEntry = (EntryGrid)this.getView().getControl("standardentry");
            int rowIndex = standardEntry.getSelectRows()[0];
            this.showSubEntryForm(rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("xmlstatement")) {
            ChangeData changeData2 = e.getChangeSet()[0];
            if (changeData2.getNewValue() == null || StringUtils.isEmpty((CharSequence)changeData2.getNewValue().toString())) {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("standardentry");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("standardentry", currentRowIndex);
                DynamicObjectCollection subEntry = rowEntity.getDynamicObjectCollection("standardsubentry");
                subEntry.clear();
            }
        } else if ("filetype".equals(key) && (changeData = e.getChangeSet()[0]) != null && changeData.getNewValue() != null) {
            if ("1".equals(changeData.getNewValue().toString())) {
                this.setEncodingItems("1");
                this.getModel().setValue("xmlencoding", (Object)"1");
            } else {
                this.setEncodingItems("0");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String res;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && StringUtils.isNotBlank((CharSequence)(res = this.checkEntryData()))) {
            this.getView().showTipNotification(res);
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (CALL_BACK_XML_STATEMENT.equals(key)) {
            this.updateEntry(evt);
        }
    }

    private void setXmlStatement() {
        DynamicObjectCollection standardEntry = this.getModel().getEntryEntity("standardentry");
        for (DynamicObject dyn : standardEntry) {
            DynamicObjectCollection subEntry = dyn.getDynamicObjectCollection("standardsubentry");
            if (standardEntry.isEmpty()) continue;
            String xmlStatement = this.buildXmlStatement(subEntry);
            dyn.set("xmlstatement", (Object)xmlStatement);
        }
        this.getModel().setDataChanged(false);
    }

    private void showSubEntryForm(int rowIndex) {
        DynamicObjectCollection standardEntry = this.getModel().getEntryEntity("standardentry");
        DynamicObjectCollection standardSubEntry = ((DynamicObject)standardEntry.get(rowIndex)).getDynamicObjectCollection("standardsubentry");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fea_xmlstatement");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_XML_STATEMENT));
        param.setCustomParam("standardSubEntry", (Object)standardSubEntry);
        this.getPageCache().put(CACHE_EDIT_ROW, String.valueOf(rowIndex));
        this.getView().showForm(param);
    }

    private String checkEntryData() {
        String fileType = this.getModel().getDataEntity().getString("filetype");
        DynamicObjectCollection standardEntry = this.getModel().getEntryEntity("standardentry");
        if (standardEntry.isEmpty()) {
            return ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandardEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        }
        boolean hasEnable = false;
        for (DynamicObject dyn : standardEntry) {
            String fileName = dyn.getString("filename");
            boolean disable = dyn.getBoolean("disable");
            if (disable) continue;
            DynamicObjectCollection subEntry = dyn.getDynamicObjectCollection("standardsubentry");
            if ("0".equalsIgnoreCase(fileType) && StringUtils.isBlank((CharSequence)fileName) && subEntry.isEmpty() || "1".equalsIgnoreCase(fileType) && StringUtils.isBlank((CharSequence)fileName)) {
                if (standardEntry.size() != 1) continue;
                return ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"StandardEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]);
            }
            hasEnable = true;
        }
        if (!hasEnable) {
            return ResManager.loadKDString((String)"\u6240\u6709\u884c\u90fd\u7981\u7528\uff0c\u5c06\u65e0\u6cd5\u5bfc\u51fa\u6587\u4ef6\u3002", (String)"StandardEditPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void updateEntry(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (!(returnData instanceof DynamicObjectCollection)) {
            log.error("kd.fi.fea.standard.StandardEditPlugin#updateEntry\uff1aXML\u58f0\u660e\u9875\u9762\u8fd4\u56de\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff01");
            return;
        }
        DynamicObjectCollection data = (DynamicObjectCollection)returnData;
        String rowStr = this.getPageCache().get(CACHE_EDIT_ROW);
        int rowIndex = NumberUtils.toInt((String)rowStr, (int)0);
        DynamicObjectCollection standardEntry = this.getModel().getEntryEntity("standardentry");
        DynamicObject dyn = (DynamicObject)standardEntry.get(rowIndex);
        DynamicObjectCollection subEntry = dyn.getDynamicObjectCollection("standardsubentry");
        subEntry.clear();
        for (DynamicObject row : data) {
            DynamicObject newDyn = subEntry.addNew();
            String prop = row.getString("prop");
            String value = row.getString("value");
            newDyn.set("prop", (Object)prop);
            newDyn.set("value", (Object)value);
        }
        dyn.set("xmlstatement", (Object)this.buildXmlStatement(data));
        this.getView().updateView("standardentry");
    }

    private String buildXmlStatement(DynamicObjectCollection data) {
        StringBuilder str = new StringBuilder();
        for (DynamicObject dyn : data) {
            if (str.length() > 0) {
                str.append(' ');
            }
            String prop = dyn.getString("prop");
            str.append(prop);
            str.append("=\"");
            String value = dyn.getString("value");
            str.append(value);
            str.append('\"');
        }
        return str.toString();
    }
}

