/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.standard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fea.enums.standard.XmlStatementPropEnum;
import org.apache.commons.lang3.StringUtils;

public class XmlStatementFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_PROP = "prop";
    private static final String FIELD_VALUE = "value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        this.setEntryData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key) && this.checkEntryData()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            this.getView().returnDataToParent((Object)entryEntity);
            this.getView().close();
        }
    }

    private boolean checkEntryData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Integer> emptyRow = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entryEntity.get(i);
            String prop = dyn.getString(FIELD_PROP);
            String value = dyn.getString(FIELD_VALUE);
            if (StringUtils.isBlank((CharSequence)prop) && StringUtils.isBlank((CharSequence)value)) {
                emptyRow.add(i);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)prop) && !StringUtils.isBlank((CharSequence)value)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199", (String)"XmlStatementFormPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!emptyRow.isEmpty()) {
            int[] rowArr = new int[emptyRow.size()];
            for (int i = 0; i < rowArr.length; ++i) {
                rowArr[i] = (Integer)emptyRow.get(i);
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, rowArr);
            this.getView().updateView(ENTRY_ENTITY);
        }
        return true;
    }

    private void setEntryData() {
        XmlStatementPropEnum[] propEnums;
        FormShowParameter param = this.getView().getFormShowParameter();
        JSONArray subEntryJson = (JSONArray)param.getCustomParam("standardSubEntry");
        if (subEntryJson == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!subEntryJson.isEmpty()) {
            model.deleteEntryData(ENTRY_ENTITY);
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_PROP, new Object[0]);
        vs.addField(FIELD_VALUE, new Object[0]);
        for (Object dyn : subEntryJson) {
            String prop = ((JSONObject)dyn).getString(FIELD_PROP);
            String value = ((JSONObject)dyn).getString(FIELD_VALUE);
            vs.addRow(new Object[]{prop, value});
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        ComboEdit prop = (ComboEdit)this.getView().getControl(FIELD_PROP);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        for (XmlStatementPropEnum propEnum : propEnums = XmlStatementPropEnum.values()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(propEnum.getValue()));
            item.setValue(propEnum.getValue());
            items.add(item);
        }
        prop.setComboItems(items);
        this.getView().updateView(ENTRY_ENTITY);
    }
}

