/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.webapi.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.StringUtil;
import kd.fi.fgptas.business.report.dto.WpsGetFileResult;
import kd.fi.fgptas.business.report.dto.WpsGetUserResult;
import kd.fi.fgptas.business.report.dto.WpsResult;
import kd.fi.fgptas.business.report.dto.WpsSaveFileInput;
import kd.fi.fgptas.business.report.dto.WpsSaveFileResult;
import kd.fi.fgptas.business.report.helper.AWSIndexHelper;
import kd.fi.fgptas.business.report.helper.ReportFileHelper;

@ApiController(value="wps", desc="WPS\u5728\u7ebf\u6587\u6863\u56de\u8c03")
@ApiMapping(value="wps")
public class ReportWpsApiService
implements Serializable {
    private static final Log log = LogFactory.getLog(ReportWpsApiService.class);

    @ApiGetMapping(value="/v1/3rd/file/info", desc="\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636e")
    public CustomApiResult<WpsGetFileResult> getFileInfo(@ApiParam(value="_w_fileid") @ApiParam(value="_w_fileid") String _w_fileid, @ApiParam(value="_w_signature") @ApiParam(value="_w_signature") String _w_signature) {
        log.info("AiWordWpsApiService.getFileInfo.begin w_fileid:" + _w_fileid + " _w_signature:" + _w_signature);
        try {
            WpsGetFileResult result = ReportFileHelper.fileInfo((String)_w_fileid);
            log.info("AiWordWpsApiService.getFileInfo.end success result:" + JSON.toJSONString((Object)result));
            return CustomApiResult.success((Object)result);
        }
        catch (Exception ex) {
            log.error("AiWordWpsApiService.getFileInfo.end error w_fileid:" + _w_fileid, (Throwable)ex);
            return CustomApiResult.success((Object)WpsGetFileResult.failEx((String)("getFileInfo error\uff1a" + ex.getMessage())));
        }
    }

    @ApiPostMapping(value="/v1/3rd/user/info", desc="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CustomApiResult<WpsGetUserResult> getUserInfo(@ApiParam(value="ids") @ApiParam(value="ids") List<String> ids) {
        log.info("AiWordWpsApiService.getUserInfo.begin userIds:" + JSONObject.toJSONString(ids));
        try {
            WpsGetUserResult result = ReportFileHelper.userInfo(ids);
            log.info("AiWordWpsApiService.getUserInfo.end success result:" + JSON.toJSONString((Object)result));
            return CustomApiResult.success((Object)result);
        }
        catch (Exception ex) {
            log.error("AiWordWpsApiService.getUserInfo.end error userIds:" + JSONObject.toJSONString(ids), (Throwable)ex);
            return CustomApiResult.success((Object)WpsGetUserResult.failEx((String)"getUserInfo error"));
        }
    }

    @ApiPostMapping(value="/v1/3rd/file/online", desc="\u901a\u77e5\u6b64\u6587\u4ef6\u76ee\u524d\u6709\u54ea\u4e9b\u4eba\u6b63\u5728\u534f\u4f5c")
    public CustomApiResult<WpsResult> online(@ApiParam(value="ids") @ApiParam(value="ids") List<String> ids) {
        log.info("AiWordWpsApiService.online userIds:" + ids == null ? "null" : JSONObject.toJSONString(ids));
        return CustomApiResult.success((Object)WpsResult.success());
    }

    @ApiPostMapping(value="/v1/3rd/file/save", desc="\u4e0a\u4f20\u6587\u4ef6\u65b0\u7248\u672c")
    public CustomApiResult<WpsSaveFileResult> fileSave(@ApiParam(value="request") @ApiParam(value="request") WpsSaveFileInput file) {
        if (file == null) {
            log.info("AiWordWpsApiService.fileSave begin:file is empty");
            return CustomApiResult.success((Object)WpsSaveFileResult.failEx((String)"file is empty"));
        }
        String w_fileid = "";
        try {
            String fileName = file.getFileName();
            if (StringUtil.isEmpty((String)fileName)) {
                log.info("AiWordWpsApiService.fileSave begin:fileName is empty");
                return CustomApiResult.success((Object)WpsSaveFileResult.failEx((String)"fileName is empty"));
            }
            w_fileid = fileName;
            if (fileName.indexOf(".") > 0) {
                w_fileid = fileName.substring(0, fileName.indexOf("."));
            }
            log.info("AiWordWpsApiService.fileSave begin w_fileid:" + w_fileid);
            byte[] fileData = file.getFileData();
            WpsSaveFileResult result = ReportFileHelper.fileSave((byte[])fileData, (String)w_fileid);
            log.info("AiWordWpsApiService.fileSave.end success result:" + JSON.toJSONString((Object)result));
            return CustomApiResult.success((Object)result);
        }
        catch (Exception ex) {
            log.error("AiWordWpsApiService.fileSave.end error w_fileid:" + w_fileid, (Throwable)ex);
            return CustomApiResult.success((Object)WpsSaveFileResult.failEx((String)"fileSave error"));
        }
    }

    @ApiGetMapping(value="/v1/3rd/file/version/", desc="\u83b7\u53d6\u7279\u5b9a\u7248\u672c\u7684\u6587\u4ef6\u4fe1\u606f")
    public CustomApiResult<WpsResult> getFileInfoByVersion() {
        log.info("AiWordWpsApiService.getFileInfoByVersion begin");
        return CustomApiResult.success((Object)WpsResult.fail((String)"Not Implements"));
    }

    @ApiPostMapping(value="/v1/3rd/file/rename", desc="\u7528\u6237\u5728H5\u9875\u9762\u4fee\u6539\u4e86\u6587\u4ef6\u540d\u540e\uff0c\u628a\u65b0\u7684\u6587\u4ef6\u540d\u4e0a\u4f20\u5230\u670d\u52a1\u7aef\u4fdd\u5b58")
    public CustomApiResult<WpsResult> rename(@ApiParam(value="_w_fileid") @ApiParam(value="_w_fileid") String _w_fileid, @ApiParam(value="name") @ApiParam(value="name") String name) {
        log.info("AiWordWpsApiService.rename.begin w_fileid:" + _w_fileid + ",name:" + name);
        return CustomApiResult.success((Object)WpsResult.fail((String)"Not Implements"));
    }

    @ApiPostMapping(value="/v1/3rd/file/history", desc="\u83b7\u53d6\u6240\u6709\u5386\u53f2\u7248\u672c\u6587\u4ef6\u4fe1\u606f")
    public CustomApiResult<JSONObject> getFileHistory(@ApiParam(value="id") @ApiParam(value="id") String id, @ApiParam(value="offset") @ApiParam(value="offset") int offset, @ApiParam(value="count") @ApiParam(value="count") int count) {
        log.info("AiWordWpsApiService.getFileHistory begin id:" + id + ",offset:" + offset + " count:" + count);
        JSONObject result = (JSONObject)JSONObject.toJSON((Object)WpsResult.success());
        result.put("histories", new ArrayList(2));
        return CustomApiResult.success((Object)result);
    }

    @ApiPostMapping(value="/v1/3rd/file/new", desc="\u65b0\u5efa\u6587\u4ef6")
    public CustomApiResult<WpsResult> fileNew() {
        log.info("AiWordWpsApiService.fileNew begin");
        return CustomApiResult.success((Object)WpsResult.fail((String)"Not Implements"));
    }

    @ApiPostMapping(value="/v1/3rd/onnotify", desc="\u5f00\u5173\u95ed\u6587\u4ef6\u56de\u8c03\u901a\u77e5")
    public CustomApiResult<WpsResult> onNotify() {
        log.info("AiWordWpsApiService.onNotify begin");
        return CustomApiResult.success((Object)WpsResult.fail((String)"Not Implements"));
    }

    @ApiPostMapping(value="queryIndexData", desc="\u67e5\u8be2\u6307\u6807\u6570\u636e\u6570\u636e")
    public CustomApiResult<Map<String, Object>> queryIndexData(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) @ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) Map<String, Object> param) {
        return CustomApiResult.success((Object)AWSIndexHelper.queryIndexValue(param));
    }

    @ApiPostMapping(value="queryIndexDataTwo", desc="\u67e5\u8be2\u6307\u6807\u6570\u636e\u6570\u636e2")
    public CustomApiResult<Map<String, Object>> queryIndexDataTwo(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) @ApiParam(value="\u8bf7\u6c42\u53c2\u6570", required=true) Map<String, Object> param) {
        return CustomApiResult.success((Object)AWSIndexHelper.queryIndexValueTwo(param));
    }
}

