/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.apphome;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.grid.DataGrid;
import kd.bos.form.control.grid.DataGridRow;
import kd.bos.form.control.grid.DataGridRowBuilder;
import kd.bos.form.control.grid.events.DataGridBindDataEvent;
import kd.bos.form.control.grid.events.DataGridBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fgptas.business.accesslog.GPTSkillAccesslogHelper;
import kd.fi.fgptas.common.enums.GlobalStatusEnum;
import kd.fi.fgptas.common.utils.FgptasLicenseUtil;
import kd.fi.fgptas.common.utils.PrivacyUtil;
import org.apache.commons.lang3.time.DateUtils;

public class AppHomeFormPlugin
extends AbstractFormPlugin
implements DataGridBindDataListener {
    private static final Log log = LogFactory.getLog(AppHomeFormPlugin.class);
    public static final String DATA_STATISTICS_BTN = "datastatisticsbtn";
    private static final String ACCESS_RANKING_BTN = "accessrankingbtn";
    private static final String ACCESSRANKING_GRID = "accessranking";
    private static final String USERS_LABEL = "users_label";
    private static final String TOTAL_LABEL = "total_label";
    private static final String SUCCESS_LABEL = "success_label";
    private static final String RESUME_LABEL = "resume_label";
    private static final String SKILLCOUNT_LABEL = "skillcount_label";
    private static final String ACCESSTIME = "accesstime";
    private static final String ACCESSTIME_STARTDATE = "accesstime_startdate";
    private static final String ACCESSTIME_ENDDATE = "accesstime_enddate";
    private static final String APPHOME_RIGHT_LIST = "apphome_right_list";
    private static final String SKILL_NUMBER_SELECT = "skillnumber";
    private static final String CLOSEFSP = "closefsp";
    private static final String TENANT_CLOSEFSP = "tenantclosefsp";
    private static final String RESOURCE = "fi-fgptas-formplugin";
    private static final String PRICACYtIPFSP = "pricacytipfsp";
    private static final String AGREEMENTCONFIRM = "agreementConfirm";
    private static final String SKILLBOX = "skillbox";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FgptasLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DATA_STATISTICS_BTN, ACCESS_RANKING_BTN, SKILL_NUMBER_SELECT});
    }

    public void beforeBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isAgreePrivacy();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateRangeEdit accesstime = (DateRangeEdit)this.getControl(ACCESSTIME);
        Date today = new Date();
        Date addDay = DateUtils.addDays((Date)today, (int)-29);
        accesstime.getModel().setValue(ACCESSTIME_STARTDATE, (Object)addDay);
        accesstime.getModel().setValue(ACCESSTIME_ENDDATE, (Object)today);
        this.getView().updateView(ACCESSTIME);
        this.dataStatistics();
        List rankingList = GPTSkillAccesslogHelper.accessRanking();
        this.setData2CustomCtrl(rankingList);
        try {
            ComboEdit indexMethod = (ComboEdit)this.getView().getControl(SKILL_NUMBER_SELECT);
            indexMethod.setComboItems(GPTSkillAccesslogHelper.getSelectIndex());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u63a5\u5165\u6280\u80fd\u5931\u8d25\uff1a%s", (String)"AppHomeFormPlugin_1", (String)RESOURCE, (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void initialize() {
        DataGrid dataGrid = (DataGrid)this.getControl(ACCESSRANKING_GRID);
        dataGrid.addBindDataListener((DataGridBindDataListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (DATA_STATISTICS_BTN.equals(key)) {
            DateRangeEdit accesstime = (DateRangeEdit)this.getControl(ACCESSTIME);
            Date startdate = (Date)accesstime.getModel().getValue(ACCESSTIME_STARTDATE);
            Date enddate = (Date)accesstime.getModel().getValue(ACCESSTIME_ENDDATE);
            if (Objects.isNull(startdate) || Objects.isNull(enddate)) {
                return;
            }
            try {
                ComboEdit indexMethod = (ComboEdit)this.getView().getControl(SKILL_NUMBER_SELECT);
                List selectIndex = GPTSkillAccesslogHelper.getSelectIndex();
                indexMethod.setComboItems(selectIndex);
                String skillNumber = (String)this.getModel().getValue(SKILL_NUMBER_SELECT);
                List values = selectIndex.stream().map(item -> item.getValue()).collect(Collectors.toList());
                if (!values.contains(skillNumber)) {
                    this.getModel().setValue(SKILL_NUMBER_SELECT, (Object)GlobalStatusEnum.GLOBAL_STATUS.getValue());
                }
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u63a5\u5165\u6280\u80fd\u5931\u8d25\uff1a%s", (String)"AppHomeFormPlugin_1", (String)RESOURCE, (Object[])new Object[0]), ex.getMessage()));
            }
            this.dataStatistics();
        } else if (ACCESS_RANKING_BTN.equals(key)) {
            List rankingList = GPTSkillAccesslogHelper.accessRanking();
            this.setData2CustomCtrl(rankingList);
        }
    }

    public void dataGridBindData(DataGridBindDataEvent e) {
        String key = ((Control)e.getSource()).getKey();
        if (ACCESSRANKING_GRID.equals(key)) {
            ArrayList list = new ArrayList(16);
            DataGridRowBuilder builder = e.getDataGridRowBuilder();
            List rankingList = GPTSkillAccesslogHelper.accessRanking();
            rankingList.forEach(map -> {
                DataGridRow row = builder.buildRow();
                map.entrySet().forEach(entry -> row.setValue((String)entry.getKey(), entry.getValue()));
                list.add(row.get());
            });
            e.setData(list);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.dataStatistics();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSEFSP.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (TENANT_CLOSEFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                this.getView().close();
                return;
            }
            this.getView().invokeOperation("refresh");
        } else if (PRICACYtIPFSP.equals(actionId) && StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            this.openDialog("gai_privacy_agreement", "userAgreement", CLOSEFSP);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (AGREEMENTCONFIRM.equals(callBackId) && MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }

    private Boolean isAgreePrivacy() {
        Map agreePrivacy = PrivacyUtil.isAgreePrivacy();
        if (((Boolean)agreePrivacy.get("error")).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42GPT\u5f00\u53d1\u5e73\u53f0\u534f\u8bae\u51fa\u9519", (String)"PrivacyTipPlugin_2", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return Boolean.FALSE;
        }
        if (((Boolean)agreePrivacy.get("isAdmin")).booleanValue() && !((Boolean)agreePrivacy.get("adminAgree")).booleanValue()) {
            this.openDialog("gai_privacy_agreement", "tenantAgreement", TENANT_CLOSEFSP);
            return Boolean.FALSE;
        }
        if (!((Boolean)agreePrivacy.get("isAdmin")).booleanValue() && !((Boolean)agreePrivacy.get("adminAgree")).booleanValue()) {
            HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>(2);
            btnNameMap.put(MessageBoxResult.OK.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86\u3002", (String)"AppHomeFormPlugin_2", (String)RESOURCE, (Object[])new Object[0]));
            String title = ResManager.loadKDString((String)"\u672a\u7b7e\u7f72\u670d\u52a1\u5904\u7406\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrivacyTipPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u60a8\u7684\u4f01\u4e1a\u8fd8\u672a\u7b7e\u7f72\u82cd\u7a79GPT\u670d\u52a1\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7b7e\u7f72\u3002", (String)"PrivacyTipPlugin_4", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showConfirm(title, msg, MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(AGREEMENTCONFIRM), btnNameMap);
            return Boolean.FALSE;
        }
        if (((Boolean)agreePrivacy.get("adminAgree")).booleanValue() && !((Boolean)agreePrivacy.get("userAgree")).booleanValue() && StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get(PRICACYtIPFSP))) {
            this.getView().getPageCache().put(PRICACYtIPFSP, "1");
            this.openDialog("fgptas_privacy_tip", "", PRICACYtIPFSP);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void openDialog(String dialogType, String agreeType, String actionId) {
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(dialogType);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)agreeType);
        fsp.setCustomParam("htmlTip", (Object)ResManager.loadKDString((String)"\u60a8\u5c1a\u672a\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\uff0c\u5efa\u8bae\u60a8\u901a\u8fc7\u9690\u79c1\u653f\u7b56\u8be6\u60c5\u8fdb\u884c\u7b7e\u7f72\uff0c\u4ee5\u5b8c\u6574\u4f53\u9a8cGPT\u8d22\u52a1\u52a9\u624b\u529f\u80fd\u3002", (String)"PrivacyTipPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    private void dataStatistics() {
        DateRangeEdit accesstime = (DateRangeEdit)this.getControl(ACCESSTIME);
        Date startdate = (Date)accesstime.getModel().getValue(ACCESSTIME_STARTDATE);
        Date enddate = (Date)accesstime.getModel().getValue(ACCESSTIME_ENDDATE);
        String skillNumber = (String)this.getModel().getValue(SKILL_NUMBER_SELECT);
        if (GlobalStatusEnum.GLOBAL_STATUS.getValue().equals(skillNumber)) {
            skillNumber = "";
        }
        if (Objects.isNull(startdate) || Objects.isNull(enddate)) {
            return;
        }
        Map dataStatistics = GPTSkillAccesslogHelper.dataStatistics((String)skillNumber, (Date)startdate, (Date)enddate);
        Label usersLabel = (Label)this.getControl(USERS_LABEL);
        usersLabel.setText(String.valueOf(dataStatistics.get("users")));
        Label totalLabel = (Label)this.getControl(TOTAL_LABEL);
        totalLabel.setText(String.valueOf(dataStatistics.get("total")));
        Label skillcountLabel = (Label)this.getControl(SKILLCOUNT_LABEL);
        skillcountLabel.setText(String.valueOf(dataStatistics.get("skillcount")));
        Label successLabel = (Label)this.getControl(SUCCESS_LABEL);
        successLabel.setText(String.valueOf(dataStatistics.get("successrate")));
        Label resumeLabel = (Label)this.getControl(RESUME_LABEL);
        resumeLabel.setText("--");
    }

    private void setData2CustomCtrl(List<Map<String, Object>> params) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(APPHOME_RIGHT_LIST);
        customcontrol.setData(params);
    }
}

