/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.apphome;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.skill.HomeSkillHelper;

public class HomeSkillDetailPlugin
extends AbstractFormPlugin
implements CellClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(HomeSkillDetailPlugin.class);
    private static final String SKILLBOX = "skillbox";
    private static final String SKILLDETAIL = "skilldetail";
    private static final String BACKBTN = "backbtn";
    private static final String FGPTAS_SKILL_GUIDE_PREVIE = "fgptas_skill_guide_previe";
    private static final String OPTION_CLICK = "optionclick";
    private static final String OPTION_UP_CLICK = "optionupclick";
    private static final String DETAIL_SKILLIMG = "detail_skillimg";
    private static final String DETAIL_SKILLNAME = "detail_skillname";
    private static final String DETAIL_SKILLDESC = "detail_skilldesc";
    private static final String RESOURCE = "fi-fgptas-formplugin";
    private static final String KNOWLEDGE_BASE = "KNOWLEDGE_BASE";
    private static final String REPORT_TEMPLATE = "REPORT_TEMPLATE";
    private static final String GPT_TASK = "GPT_TASK";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String skillId = (String)view.getFormShowParameter().getCustomParam("skillid");
        long id = Long.parseLong(skillId);
        this.refresh(view, model, id);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BACKBTN});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (key) {
            case "backbtn": {
                view.close();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = ((Control)evt.getSource()).getKey();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object returnData = closedCallBackEvent.getReturnData();
    }

    public void refresh(IFormView view, IDataModel model, long skillId) {
        HashMap<String, String> labelTextMap = new HashMap<String, String>(2);
        DynamicObject skillDetail = HomeSkillHelper.getSkillDetail((long)skillId);
        labelTextMap.put(DETAIL_SKILLNAME, skillDetail.getString("name"));
        labelTextMap.put(DETAIL_SKILLDESC, skillDetail.getString("description"));
        labelTextMap.entrySet().stream().forEach(e -> ((Label)this.getControl((String)e.getKey())).setText((String)e.getValue()));
        String webUrl = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
        Image img = (Image)this.getControl(DETAIL_SKILLIMG);
        img.setUrl(webUrl + skillDetail.getString("skillicon"));
        CustomControl customcontrol = (CustomControl)this.getView().getControl(FGPTAS_SKILL_GUIDE_PREVIE);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(1);
        map.put("edit", Boolean.TRUE);
        DynamicObjectCollection skillCards = skillDetail.getDynamicObjectCollection("fgptas_skillcard");
        ArrayList data = new ArrayList(3);
        for (DynamicObject card : skillCards) {
            HashMap<String, Object> map1 = new HashMap<String, Object>(3);
            map1.put("guideId", card.getString(0));
            map1.put("guideName", card.getString("cardname"));
            ArrayList data1 = new ArrayList(6);
            List cardOptions = HomeSkillHelper.getSkillCardOptions((long)card.getLong(0));
            for (Map option : cardOptions) {
                HashMap map2 = new HashMap(2);
                map2.put("optionId", option.get("detailid"));
                map2.put("optionName", option.get("optionname"));
                map2.put("optionCode", option.get("optioncode"));
                map2.put("optionJson", option.get("optionjson"));
                data1.add(map2);
                map1.put("guideOptions", data1);
            }
            data.add(map1);
        }
        map.put("data", data);
        customcontrol.setData(map);
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        if (OPTION_CLICK.equals(eventName)) {
            Map card = HomeSkillHelper.getSkillCardDetail((long)jsonObject.getLong("guideId"));
            Map option = HomeSkillHelper.getSkillCardOptionDetail((long)jsonObject.getLong("optionId"));
            String optionStr = (String)option.get("optionjson");
            if (StringUtils.isBlank((String)optionStr)) {
                return;
            }
            String datatype = (String)card.get("datatabletype");
            if (StringUtils.isBlank((String)datatype)) {
                return;
            }
            JSONObject optionJson = JSONObject.parseObject((String)optionStr);
            switch (datatype) {
                case "KNOWLEDGE_BASE": {
                    long areaid;
                    DynamicObject klgarea;
                    long org = RequestContext.get().getOrgId();
                    int hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)org, null, (String)"gptas", (String)"gptas_knowledge_area", (String)"3OX2NUQ005JC");
                    if (1 != hasPermission) {
                        String msg = ResManager.loadKDString((String)"\u65e0\u201c\u77e5\u8bc6\u9886\u57df\u7ba1\u7406\u201d\u7684\u201c\u8fdb\u5165\u77e5\u8bc6\u9886\u57df\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HomeSkillPlugin_2", (String)RESOURCE, (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    long pkId = optionJson.getLong("data_knowledge");
                    DynamicObject klgallocate = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"gptas_klg_allocates");
                    if (klgallocate == null) {
                        String msg = ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054\u77e5\u8bc6\u5e93\u3002", (String)"HomeSkillPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    if (klgallocate != null && (klgarea = BusinessDataServiceHelper.loadSingleFromCache((Object)(areaid = klgallocate.getLong("knowledgearea.masterid")), (String)"gptas_knowledge_area")) == null) {
                        String msg = ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u6240\u5728\u77e5\u8bc6\u9886\u57df\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054\u77e5\u8bc6\u5e93\u3002", (String)"HomeSkillPlugin_4", (String)RESOURCE, (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    BaseShowParameter klgallocates = new BaseShowParameter();
                    klgallocates.setFormId("gptas_klg_allocates");
                    klgallocates.setPkId((Object)pkId);
                    klgallocates.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)klgallocates);
                    break;
                }
                case "REPORT_TEMPLATE": {
                    long pkValue = optionJson.getLong("data_reporttpl");
                    DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"fgptas_fireport_template");
                    if (model == null) {
                        String msg = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054\u62a5\u544a\u6a21\u677f\u3002", (String)"HomeSkillPlugin_5", (String)RESOURCE, (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    BaseShowParameter showParam = new BaseShowParameter();
                    showParam.setFormId("fgptas_fireport_template");
                    showParam.setPkId((Object)pkValue);
                    showParam.setStatus(OperationStatus.VIEW);
                    showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParam);
                    break;
                }
                case "GPT_TASK": {
                    Boolean sidebar = (Boolean)optionJson.get((Object)"clicksidebar");
                    long taskId = (Long)optionJson.get((Object)"data_gpttask");
                    if (!sidebar.booleanValue()) break;
                    if (!HomeSkillHelper.getGPTTask((long)taskId).booleanValue()) {
                        String msg = ResManager.loadKDString((String)"GPT\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054GPT\u4efb\u52a1\u3002", (String)"HomeSkillPlugin_1", (String)RESOURCE, (Object[])new Object[0]);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    Map gptTaskDetail = HomeSkillHelper.getGPTTaskDetail((long)taskId);
                    this.openSideBar(taskId, (String)gptTaskDetail.get("desc"));
                }
            }
        } else if (OPTION_UP_CLICK.equals(eventName) && HomeSkillHelper.saveSkillCaRdOptionUp((long)jsonObject.getLong("optionId")).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7f6e\u9876\u6210\u529f", (String)"HomeSkillPlugin_6", (String)RESOURCE, (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String key = ((Control)cellClickEvent.getSource()).getKey();
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String key = ((Control)evt.getSource()).getKey();
    }

    private void openSideBar(long taskId, String desc) {
        IFormView mainView = this.getView().getMainView();
        IFormView view = mainView == null ? this.getView() : mainView;
        String rootPageId = view.getPageId();
        String assistant = desc;
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"selectProcessInSideBar", (Object[])new Object[]{taskId, rootPageId, assistant});
    }
}

