/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.apphome;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.skill.HomeSkillHelper;
import kd.fi.fgptas.common.enums.PermissionItemEnum;
import kd.fi.fgptas.common.enums.SkillInteractionModeEnum;

public class HomeSkillListPlugin
extends AbstractFormPlugin
implements CellClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(HomeSkillListPlugin.class);
    private static final String SKILLLISTBOX = "skilllistbox";
    private static final String SKILLBOX = "skillbox";
    private static final String SETTINGBTN = "settingbtn";
    private static final String SKILLLIST = "skilllist";
    public static final String SKILLIMG = "skillimg";
    public static final String SKILLID = "skillid";
    public static final String SKILLNAME = "skillname";
    public static final String SKILLDESC = "skilldesc";
    public static final String MAINTENANCEBTNPREMI = "maintenancebtnpremi";
    private static final String USEBTN = "usebtn";
    private static final String MAINTENANCEBTN = "maintenancebtn";
    private static final String CARDENTRYROWAP = "cardentryrowap";
    private static final String CARDENTRYFLEXPANELAP = "cardentryflexpanelap";
    private static final String SKILLLISTENTITY = "skilllistentity";
    private static final String CARDENTRYVIEWAP = "cardentryviewap";
    private static final String FGPTAS_GPTAPPHOME = "fgptas_gptapphome";
    private static final String DETAILBTN = "detailbtn";
    private static final String SKILLDETAIL = "skilldetail";
    private static final String FGPTAS_GUIDE_PRIVEW = "fgptas_guide_privew";
    private static final String BACKBTN = "backbtn";
    private static final String SKILLENTITYNAME = "fgptas_skill";
    private static final String RESOURCE = "fi-fgptas-formplugin";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{SKILLDETAIL});
        this.refreshSkillList(view, model, null);
        Boolean setting = this.checkPermission("4+QCBCX/I4LA");
        this.getView().setVisible(setting, new String[]{SETTINGBTN});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SETTINGBTN, CARDENTRYROWAP, CARDENTRYFLEXPANELAP, USEBTN, MAINTENANCEBTN, DETAILBTN, "datastatisticsbtn"});
        this.addItemClickListeners(new String[]{CARDENTRYROWAP, CARDENTRYFLEXPANELAP});
        ((AbstractGrid)this.getControl(SKILLLISTENTITY)).addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"HomeSkillPlugin_0", (String)RESOURCE, (Object[])new Object[0]);
        switch (key) {
            case "datastatisticsbtn": {
                this.afterCreateNewData(evt);
                break;
            }
            case "settingbtn": {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)SKILLENTITYNAME);
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)mainEntityType.getAppId(), (String)SKILLENTITYNAME, (String)PermissionItemEnum.QUERY.getId());
                log.info(String.format("appid\uff1a%s , formmetaid: %s, \u6743\u9650\uff1a", mainEntityType.getAppId(), SKILLENTITYNAME, hasPermission));
                if (!hasPermission) {
                    String finalMsg = String.format(msg, HomeSkillHelper.getMetaName((String)SKILLENTITYNAME));
                    this.getView().showErrorNotification(finalMsg);
                    return;
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.setBillFormId(SKILLENTITYNAME);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "usebtn": {
                int entryIndex = model.getEntryCurrentRowIndex(SKILLLISTENTITY);
                String value = (String)model.getValue(SKILLID, entryIndex);
                DynamicObject skillDetail = HomeSkillHelper.getSkillDetail((long)Long.parseLong(value));
                if (skillDetail == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6280\u80fd\u4e0d\u5b58\u5728\u3002", (String)"HomeSkillPlugin_10", (String)RESOURCE, (Object[])new Object[0]));
                    return;
                }
                DynamicObject gptTask = skillDetail.getDynamicObject("gpttaskid");
                DynamicObject formMeta = skillDetail.getDynamicObject("formmetaid");
                String interactionmode = skillDetail.getString("interactionmode");
                if (StringUtils.isBlank((String)interactionmode)) {
                    return;
                }
                if (SkillInteractionModeEnum.SIDEBAR.getType().equals(interactionmode)) {
                    DynamicObject skillDetailbyQuery = HomeSkillHelper.getSkillDetailbyQuery((long)Long.parseLong(value));
                    if ("0".equals(skillDetailbyQuery.getString("gpttaskid"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6eGPT\u4efb\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054\u3002", (String)"HomeSkillPlugin_7", (String)RESOURCE, (Object[])new Object[0]));
                        return;
                    }
                    long number = skillDetail.getLong("gpttaskid.id");
                    if (!HomeSkillHelper.getGPTTask((long)number).booleanValue()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"GPT\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054GPT\u4efb\u52a1\u3002", (String)"HomeSkillPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
                        return;
                    }
                    String desc = skillDetail.getString("gpttaskid.desc");
                    String name = skillDetail.getString("gpttaskid.name");
                    boolean gptprei = HomeSkillHelper.hasGPTTaskPrei((long)number);
                    if (!gptprei) {
                        String finalStr = String.format(ResManager.loadKDString((String)"\u672c\u5e94\u7528\u65e0\u201c%s\u201d\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"HomeSkillPlugin_8", (String)RESOURCE, (Object[])new Object[0]), name);
                        this.getView().showErrorNotification(finalStr);
                        return;
                    }
                    this.openSideBar(number, desc);
                }
                if (!SkillInteractionModeEnum.FUNCTION_INTERFACE.getType().equals(interactionmode)) break;
                if (formMeta == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u529f\u80fd\u9875\u9762\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5173\u8054\u3002", (String)"HomeSkillPlugin_9", (String)RESOURCE, (Object[])new Object[0]));
                    return;
                }
                this.openPage(skillDetail);
                break;
            }
            case "maintenancebtn": {
                int entryIndex1 = model.getEntryCurrentRowIndex(SKILLLISTENTITY);
                String value1 = (String)model.getValue(SKILLID, entryIndex1);
                DynamicObject skillDetail1 = HomeSkillHelper.getSkillDetail((long)Long.parseLong(value1));
                String formmetanum = skillDetail1.getString("configformmetaid.number");
                MainEntityType mainEntityType1 = EntityMetadataCache.getDataEntityType((String)formmetanum);
                boolean hasPermission1 = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)mainEntityType1.getAppId(), (String)formmetanum, (String)PermissionItemEnum.QUERY.getId());
                log.info(String.format("appid\uff1a%s , formmetaid: %s, \u6743\u9650\uff1a", mainEntityType1.getAppId(), formmetanum, hasPermission1));
                if (!hasPermission1) {
                    String finalMsg = String.format(msg, HomeSkillHelper.getMetaName((String)formmetanum));
                    this.getView().showErrorNotification(finalMsg);
                    return;
                }
                ListShowParameter showListParameter = new ListShowParameter();
                showListParameter.setFormId("bos_list");
                showListParameter.setBillFormId(formmetanum);
                showListParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showListParameter);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = ((Control)evt.getSource()).getKey();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object returnData = closedCallBackEvent.getReturnData();
        if (BACKBTN.equals(key)) {
            view.setVisible(Boolean.TRUE, new String[]{SKILLLISTBOX});
        }
    }

    public void refreshSkillList(IFormView view, IDataModel model, String searchStr) {
        model.deleteEntryData(SKILLLISTENTITY);
        List skillQueryList = HomeSkillHelper.getSkillList();
        if (skillQueryList.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(skillQueryList.size());
        String webUrl = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
        Boolean maintenanceprei = this.checkPermission("4+QC257A9W0S");
        for (DynamicObject dynamicObject : skillQueryList) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put(MAINTENANCEBTNPREMI, maintenanceprei != false ? "1" : "0");
            map.put(SKILLIMG, webUrl + dynamicObject.getString("skillicon"));
            map.put(SKILLID, dynamicObject.getLong("id"));
            map.put(SKILLNAME, dynamicObject.getString("name"));
            map.put(SKILLDESC, dynamicObject.getString("description"));
            map.put("gpttaskid", dynamicObject.getString("gpttaskid"));
            map.put("formmetaid", dynamicObject.getString("formmetaid"));
            map.put("interactionmode", dynamicObject.getString("interactionmode"));
            map.put("configformmetaid", dynamicObject.getString("configformmetaid"));
            list.add(map);
        }
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        abstractModel.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(SKILLIMG, new Object[0]);
        tvs.addField(SKILLID, new Object[0]);
        tvs.addField(SKILLNAME, new Object[0]);
        tvs.addField(SKILLDESC, new Object[0]);
        tvs.addField(MAINTENANCEBTNPREMI, new Object[0]);
        tvs.addField("gpttaskid", new Object[0]);
        tvs.addField("formmetaid", new Object[0]);
        tvs.addField("interactionmode", new Object[0]);
        tvs.addField("configformmetaid", new Object[0]);
        for (Map map : list) {
            tvs.addRow(new Object[]{map.get(SKILLIMG), map.get(SKILLID), map.get(SKILLNAME), map.get(SKILLDESC), map.get(MAINTENANCEBTNPREMI), map.get("gpttaskid"), map.get("formmetaid"), map.get("interactionmode"), map.get("configformmetaid")});
        }
        abstractModel.batchCreateNewEntryRow(SKILLLISTENTITY, tvs);
        abstractModel.endInit();
        view.updateView(SKILLLISTENTITY);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String key = ((Control)cellClickEvent.getSource()).getKey();
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String key = ((Control)evt.getSource()).getKey();
    }

    private void openSideBar(long taskId, String desc) {
        IFormView mainView = this.getView().getMainView();
        IFormView view = mainView == null ? this.getView() : mainView;
        String rootPageId = view.getPageId();
        String assistant = desc;
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"selectProcessInSideBar", (Object[])new Object[]{taskId, rootPageId, assistant});
    }

    private void openPage(DynamicObject skillDetail) {
        String formmetanum = skillDetail.getString("formmetaid.number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formmetanum);
        String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"HomeSkillPlugin_0", (String)RESOURCE, (Object[])new Object[0]);
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)mainEntityType.getAppId(), (String)formmetanum, (String)PermissionItemEnum.QUERY.getId());
        log.info(String.format("appid\uff1a%s , formmetaid: %s, \u6743\u9650\uff1a", mainEntityType.getAppId(), formmetanum, hasPermission));
        if (!hasPermission) {
            String finalMsg = String.format(msg, HomeSkillHelper.getMetaName((String)formmetanum));
            this.getView().showErrorNotification(finalMsg);
            return;
        }
        ListShowParameter showListParameter = new ListShowParameter();
        showListParameter.setFormId("bos_list");
        showListParameter.setBillFormId(formmetanum);
        showListParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showListParameter);
    }

    private Boolean checkPermission(String permistr) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"fgptas").getId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)FGPTAS_GPTAPPHOME, (String)permistr);
    }
}

