/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.datatable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetadataDao;
import kd.fi.fgptas.business.datatable.fieldcfg.TextAreaFieldCfg;
import kd.fi.fgptas.business.datatable.fieldcfg.TextFieldCfg;
import kd.fi.fgptas.common.datatable.field.AbstractFieldPropService;
import kd.fi.fgptas.common.datatable.field.FieldPropServiceFactory;

public class DatatableDefineFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String KEY_ENTRY = "entryentity";
    private static final String KEY_FIXEDVALUE = "fixedvalue";
    private static final String KEY_FIELDPROPERTY = "fieldproperty";
    private static final String KEY_DATASOURCE = "datasource";
    private static final String KEY_RETRIEVALPLUGIN = "retrievalplugin";
    private static final String FIXEDVALUE_PROP_CHOOSE = "FixedvaluePropChoose";
    private static final String OP_DELETE = "delete";
    private static final String OP_ENTRYDELETE = "deleteentry";
    private static final String HAS_BIZ_DATA_KEY = "hasBizData";
    private static final String FIRST_DEL_FIELD = "firstDelField";
    private static final String CACHEKEY_SUBENTRY = "cacheremovesubentry";
    private final Pattern numberPattern = Pattern.compile("^[a-zA-Z0-9_]*$");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_FIELDPROPERTY);
        textEdit.addButtonClickListener((ClickListener)this);
        TextEdit fixedvalueTextEdit = (TextEdit)this.getView().getControl(KEY_FIXEDVALUE);
        fixedvalueTextEdit.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (KEY_FIELDPROPERTY.equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject rowData = this.getModel().getEntryRowEntity(KEY_ENTRY, index);
            String fieldType = rowData.getString("fieldtype");
            AbstractFieldPropService service = FieldPropServiceFactory.getService((String)fieldType);
            if (service != null) {
                service.showFieldPropChooseView(this.getView(), this.getModel(), this.getPluginName());
            }
        } else if (KEY_FIXEDVALUE.equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fgptas_fixedvalue_dialog");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), FIXEDVALUE_PROP_CHOOSE);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCustomParam("fieldValue", this.getView().getModel().getValue(KEY_FIXEDVALUE));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object retData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)retData)) {
            return;
        }
        int curIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        if (FIXEDVALUE_PROP_CHOOSE.equals(actionId)) {
            this.getModel().setValue(KEY_FIXEDVALUE, retData, curIndex);
        } else {
            AbstractFieldPropService service = FieldPropServiceFactory.getServiceByCBKey((String)e.getActionId());
            if (service != null && retData != null) {
                this.getModel().setValue(KEY_FIELDPROPERTY, (Object)service.getFieldProperty(retData), curIndex);
                this.getModel().setValue("fieldpropertyjson_tag", (Object)service.getFieldPropertyJSON(retData), curIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        if ("number".equals(propName)) {
            model.setValue("number", (Object)this.amendNumber((String)propValue));
        } else if ("fieldnumber".equals(propName)) {
            model.setValue("fieldnumber", (Object)this.amendNumber((String)propValue), rowIndex, parentRowIndex);
            String fieldNumber = (String)model.getValue("fieldnumber", rowIndex, parentRowIndex);
            if (fieldNumber.length() > 25) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,25]\u3002", (String)"DatatableDefineFormPlugin_6", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                model.setValue("fieldnumber", (Object)"", rowIndex, parentRowIndex);
                return;
            }
            if (!this.numberPattern.matcher(fieldNumber).matches()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u4ee5\u53ca\u4e0b\u5212\u7ebf\u7ec4\u6210", (String)"DatatableDefineFormPlugin_11", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                model.setValue("fieldnumber", (Object)"", rowIndex, parentRowIndex);
                return;
            }
            boolean repeat = this.checkModelAllNumberRepeat();
            if (repeat) {
                model.setValue("fieldnumber", (Object)"", rowIndex, parentRowIndex);
                return;
            }
        } else if ("fieldtype".equals(propName)) {
            String fieldtype;
            model.setValue("fieldpropertyjson_tag", (Object)"", rowIndex, parentRowIndex);
            model.setValue(KEY_FIELDPROPERTY, (Object)"", rowIndex, parentRowIndex);
            if (oldValue != null && "Currency".equals(oldValue.toString())) {
                String fieldNumber = (String)model.getValue("fieldnumber", rowIndex, parentRowIndex);
                this.currencyChangeNumber(null, fieldNumber);
            }
            if ((fieldtype = String.valueOf(propValue)).startsWith("Text")) {
                TextFieldCfg textFieldCfg = fieldtype.equals("Text") ? new TextFieldCfg() : new TextAreaFieldCfg();
                model.setValue("fieldpropertyjson_tag", (Object)JSON.toJSONString((Object)textFieldCfg), rowIndex, parentRowIndex);
                model.setValue(KEY_FIELDPROPERTY, (Object)String.format(ResManager.loadKDString((String)"\u957f\u5ea6:%s", (String)"DatatableDefineFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), textFieldCfg.getMaxLength()), rowIndex, parentRowIndex);
            }
        } else if (KEY_FIELDPROPERTY.equals(propName)) {
            if (propValue == null || propValue.toString().isEmpty()) {
                model.setValue("fieldpropertyjson_tag", (Object)"", rowIndex, parentRowIndex);
            }
        } else if (KEY_DATASOURCE.equals(propName)) {
            String datasource = (String)this.getModel().getValue(KEY_DATASOURCE);
            TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_RETRIEVALPLUGIN);
            textEdit.setMustInput("1".equals(datasource));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel entryOperate = this.getModel();
        this.getModel().createNewEntryRow(KEY_ENTRY);
        this.getModel().setValue("fieldnumber", (Object)"org");
        this.getModel().setValue("fieldname", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"DatatableDefineFormPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("fielddesc", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"DatatableDefineFormPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("fieldtype", (Object)"Org");
        this.getModel().setValue("ispreset", (Object)Boolean.TRUE);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (OP_ENTRYDELETE.equalsIgnoreCase(key)) {
            int selectRow = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            boolean isPreset = (Boolean)this.getModel().getValue("ispreset", selectRow);
            String isCheckMeta = (String)this.getModel().getValue("fcheckmeta", selectRow);
            if (isPreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5b57\u6bb5\u4e0d\u80fd\u5220\u9664", (String)"DatatableDefineFormPlugin_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("1".equals(isCheckMeta)) {
                String number = (String)this.getModel().getValue("number");
                if (this.hasBizData(number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u88ab\u5220\u9664", (String)"DatatableDefineFormPlugin_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("fcheckmeta", (Object)"2", selectRow);
            }
        } else if ("save".equals(key)) {
            boolean isRepeat = this.checkNumberRepeat(args);
            if (isRepeat) {
                return;
            }
            boolean isDescFixedvalue = this.checkDescFixedvalue(args);
            if (isRepeat) {
                return;
            }
        }
    }

    private boolean checkDescFixedvalue(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY);
        ArrayList<String> fieldnames = new ArrayList<String>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            fieldnames.add(dynamicObject.getString("fieldname"));
            boolean fieldquery = dynamicObject.getBoolean("fieldquery");
            if (!fieldquery) continue;
            ILocaleString fielddesc = dynamicObject.getLocaleString("fielddesc");
            String fixedvalue = dynamicObject.getString(KEY_FIXEDVALUE);
            if (fielddesc != null && !StringUtils.isEmpty((CharSequence)fielddesc.getLocaleValue()) || !StringUtils.isEmpty((CharSequence)fixedvalue)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6761\u4ef6\u5b57\u6bb5\u7684\u5b57\u6bb5\u63cf\u8ff0\u6216\u56fa\u5b9a\u503c", (String)"DatatableDefineFormPlugin_9", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        List list = fieldnames.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        HashSet fieldnameSet = new HashSet(list);
        if (fieldnameSet.size() < list.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5b57\u6bb5\u540d\u79f0\u91cd\u590d", (String)"DatatableDefineFormPlugin_10", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
    }

    private String amendNumber(String original) {
        String isvPrefix;
        if (StringUtils.isEmpty((CharSequence)original)) {
            return "";
        }
        String result = original.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!result.startsWith(isvPrefix = DatatableDefineFormPlugin.getIsvPrefix())) {
            result = isvPrefix + result;
        }
        return result;
    }

    public static String getIsvPrefix() {
        String isvInfo = ISVService.getISVInfo().getId().toLowerCase();
        return isvInfo + "_";
    }

    private boolean checkModelAllNumberRepeat() {
        boolean repeat;
        IDataModel model = this.getModel();
        DynamicObjectCollection entitys = model.getEntryEntity(KEY_ENTRY);
        List numberList = entitys.stream().map(dynamicObject -> dynamicObject.getString("fieldnumber")).filter(StringUtils::isNotBlank).map(String::toLowerCase).collect(Collectors.toList());
        HashSet numberSet = new HashSet(numberList);
        boolean bl = repeat = numberSet.size() < numberList.size();
        if (repeat) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DatatableDefineFormPlugin_5", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
        return repeat;
    }

    private void saveExistBizDataStatus() {
        String number = (String)this.getModel().getValue("number");
        boolean hasMetadata = MetadataDao.checkNumber((String)number);
        if (!hasMetadata) {
            this.getPageCache().put(HAS_BIZ_DATA_KEY, String.valueOf(Boolean.FALSE));
        }
        boolean hasBizData = this.hasBizData(number);
        this.getPageCache().put(HAS_BIZ_DATA_KEY, String.valueOf(hasBizData));
    }

    private boolean hasBizData(String number) {
        boolean hasBizData = false;
        DBRoute dbRoute = DBRoute.of((String)"fi");
        String algoKey = ((Object)((Object)this)).getClass() + ".existDatatableBizData";
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)String.format("select top 1 fid from t_%s", number));){
            if (!ds.isEmpty()) {
                hasBizData = true;
            }
        }
        return hasBizData;
    }

    private boolean checkNumberRepeat(BeforeDoOperationEventArgs args) {
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = bsp.getBillStatus();
        if (billStatus != BillOperationStatus.ADDNEW) {
            return false;
        }
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        if (number.length() > 23) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,23]\u3002", (String)"DatatableDefineFormPlugin_7", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        boolean numberRepeat = MetadataDao.checkNumber((String)number);
        String tableName = "t_" + number;
        boolean tableRepeat = DB.exitsTable((DBRoute)DBRoute.of((String)"fi"), (String)tableName);
        if (numberRepeat || tableRepeat) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u5bf9\u5e94\u8868\u540d\u91cd\u590d", (String)"DatatableDefineFormPlugin_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        boolean checkName = MetadataDao.checkName((String)name.getLocaleValue());
        if (checkName) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u914d\u7f6e\u540d\u79f0\u91cd\u590d", (String)"DatatableDefineFormPlugin_8", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean currencyChangeNumber(String newNum, String oldNum) {
        if (oldNum == null || oldNum.isEmpty()) {
            return false;
        }
        boolean needUpdateView = false;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityList = model.getEntryEntity(KEY_ENTRY);
        for (DynamicObject en : entryEntityList) {
            DynamicObjectCollection subEntryList = en.getDynamicObjectCollection(KEY_ENTRY);
            for (DynamicObject subEn : subEntryList) {
                String oldJson;
                JSONObject jsonObject;
                if (!"Amount".equals(subEn.getString("fieldtype")) || (jsonObject = JSONObject.parseObject((String)(oldJson = subEn.getString("fieldpropertyjson_tag")))) == null || !oldNum.equals(jsonObject.getString("currencyFieldId"))) continue;
                if (newNum == null || newNum.isEmpty()) {
                    this.getModel().beginInit();
                    subEn.set("fieldpropertyjson_tag", (Object)"");
                    subEn.set(KEY_FIELDPROPERTY, (Object)"");
                    this.getModel().endInit();
                    needUpdateView = true;
                    continue;
                }
                jsonObject.put("currencyFieldId", (Object)newNum);
                this.getModel().beginInit();
                subEn.set("fieldpropertyjson_tag", (Object)jsonObject.toJSONString());
                this.getModel().endInit();
            }
        }
        return needUpdateView;
    }

    public static boolean containsChineseChar(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        for (char c : input.toCharArray()) {
            if (!DatatableDefineFormPlugin.isChineseChar(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChineseChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

