/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.datatable;

import java.util.EventObject;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class FixedvaluePopFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        String fieldJson = (String)param.getCustomParam("fieldValue");
        if (StringUtils.isEmpty((String)fieldJson)) {
            return;
        }
        String[] strings = fieldJson.split(";");
        for (int i = 0; i < strings.length; ++i) {
            int rowIndex = i == 0 ? 0 : this.getModel().createNewEntryRow("entryentity");
            model.setValue("fixedvalue", (Object)strings[i], rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH);
        if (BTN_OK.equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        DynamicObjectCollection objectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(0);
        String fixedvalues = objectCollection.stream().map(d -> d.getString("fixedvalue")).filter(StringUtils::isNotEmpty).collect(Collectors.joining(";"));
        this.getView().returnDataToParent((Object)fixedvalues);
        this.getView().close();
    }

    private boolean checkFieldProperties() {
        boolean bError = false;
        int maxLength = this.getModel().getDataEntity().getInt("maxLength");
        if (maxLength < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u957f\u5ea6\u201d\u4e0d\u5728\u8303\u56f4\u5185[1~2000]\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FixedvaluePopFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            bError = true;
        }
        return bError;
    }
}

