/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fgptas.business.audit.AuditProgressTaskV2;
import kd.fi.fgptas.business.audit.BaiduOcrResultStatus;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.helper.AuditConfigSearcher;
import kd.fi.fgptas.business.audit.helper.BillAuditHelper;
import kd.fi.fgptas.common.utils.FgptasLicenseUtil;
import kd.fi.fgptas.common.utils.PrivacyUtil;
import kd.fi.fgptas.formplugin.fileanalysis.AttachmentNoAuditPlugin;
import kd.fi.fgptas.formplugin.fileanalysis.state.FormFactory;
import org.apache.commons.lang3.math.NumberUtils;

public class AttachmentAuditPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(AttachmentAuditPlugin.class);
    private static final String RESOURCE = "fi-fgptas-formplugin";
    private static final String KEY_ATTACHMENT_ANALYSIS = "attachment_custom_ctrl";
    private static final String FLEX_ATTACHMENT = "flex_attachment";
    private static final String KEY_OCR = "ocr";
    public static final String BTN_FILE_CHAT = "chat";
    public static final String BTN_SUMMARIZE = "resummarize";
    public static final String BTN_RETRY = "retryap";
    public static final String PARA_ENTITY_ID = "entityid";
    public static final String PARA_ENTITY_OBJECT = "entityobject";
    public static final String PARA_FORCED = "forced";
    private static final String CACHE_ANALYSIS_DATA = "analysis_data";
    private static final String CACHE_ENTITY_NUMBER = "entity_number";
    public static final String CACHE_BILL_AUDIT = "gpt.bill_audit";
    public static final String CACHE_GPT_BILL_ID = "gpt.billId";
    public static final String CACHE_GPT_ENTITY_NUMBER = "gpt.entityNumber";
    public static final String CACHE_GPT_USER_ID = "gpt.userId";
    public static final String CACHE_NEED_BILL_AUDIT = "gpt.needBillAudit";
    @Deprecated
    private static final String CLICK_LINK = "clickLink";
    private static final String TEXT_HTML_STYLE = "<div style='font-family: MicrosoftYaHei;font-size: 14px;color: #212121;letter-spacing: 0;line-height: 24px;font-weight: 400;'>%s</div>";
    private String entityNumber;
    private long entityId;
    private ProgressBar progressBar;
    private static final String CLOSEFSP = "closefsp";
    private static final String PRICACYtIPFSP = "pricacytipfsp";
    private static final String NOAUDITAGREEPRIVACY = "noauditagreeprivacy";

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean hasLicense = FgptasLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
        if (!hasLicense) {
            return;
        }
        FormShowParameter fsp = e.getFormShowParameter();
        this.entityNumber = (String)fsp.getCustomParam(PARA_ENTITY_OBJECT);
        this.entityId = NumberUtils.toLong((String)(fsp.getCustomParam(PARA_ENTITY_ID) + ""));
    }

    public void initialize() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.entityNumber = (String)fsp.getCustomParam(PARA_ENTITY_OBJECT);
        this.entityId = NumberUtils.toLong((String)(fsp.getCustomParam(PARA_ENTITY_ID) + ""));
        this.progressBar = (ProgressBar)this.getControl("progressbarap");
        this.progressBar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_FILE_CHAT, BTN_SUMMARIZE, BTN_RETRY});
    }

    public void afterBindData(EventObject e) {
        Boolean canNext = this.isAgreePrivacy();
        if (!canNext.booleanValue()) {
            return;
        }
        this.showAttachmentAuditFlex();
    }

    public void click(EventObject evt) {
        Boolean canNext = this.isAgreePrivacy();
        if (!canNext.booleanValue()) {
            return;
        }
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        String s = this.getPageCache().get(CACHE_BILL_AUDIT);
        long id = Long.parseLong(s);
        switch (key) {
            case "chat": {
                HashMap<String, String> cache = new HashMap<String, String>(3);
                cache.put(CACHE_GPT_BILL_ID, this.getView().getFormShowParameter().getCustomParam(PARA_ENTITY_ID) + "");
                cache.put(CACHE_GPT_ENTITY_NUMBER, this.getView().getFormShowParameter().getCustomParam(PARA_ENTITY_OBJECT) + "");
                cache.put(CACHE_GPT_USER_ID, RequestContext.get().getCurrUserId() + "");
                this.getPageCache().put(cache);
                this.getPageCache().saveChanges();
                this.openSideBar();
                break;
            }
            case "resummarize": {
                if (StringUtils.isBlank((CharSequence)s)) {
                    String tip = ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5355\u636e\u3002", (String)"AttachmentAuditPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
                    this.getView().showErrorNotification(tip);
                    return;
                }
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (String)"runtimestatus,ocr_status,output,output_tag,ocr_output,ocr_output_tag,ocr_error,riskentry", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                if (FGPTASAuditStatus.SUCCESS.getKey().equals(dyo.getString("runtimestatus"))) {
                    log.info("billaudit_" + s + " set rag embedding processing");
                    dyo.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey());
                    dyo.set("output_tag", null);
                    dyo.set("output", null);
                }
                if (OcrStatus.SUCCESS.getKey().equals(dyo.getString("ocr_status"))) {
                    log.info("billaudit_" + s + " set ocr running");
                    dyo.set("ocr_status", (Object)OcrStatus.RUNNING.getKey());
                    dyo.set("ocr_output_tag", null);
                    dyo.set("ocr_output", null);
                    dyo.set("ocr_error", null);
                }
                dyo.getDynamicObjectCollection("riskentry").clear();
                SaveServiceHelper.update((DynamicObject)dyo);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("fgptas_no_audit_show");
                fsp.setCustomParam(PARA_ENTITY_ID, (Object)this.entityId);
                fsp.setCustomParam(PARA_ENTITY_OBJECT, (Object)this.entityNumber);
                fsp.setCustomParam(PARA_FORCED, (Object)"true");
                fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                this.getView().showForm(fsp);
                break;
            }
            case "retryap": {
                this.retry();
                break;
            }
        }
    }

    private void retry() {
        String auditId = this.getPageCache().get(CACHE_BILL_AUDIT);
        if (StringUtils.isBlank((CharSequence)auditId)) {
            String tip = ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5355\u636e\u3002", (String)"AttachmentAuditPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(tip);
            return;
        }
        long id = Long.parseLong(auditId);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (String)"runtimestatus,ocr_status,ocr_error,riskentry.riskstatus,riskentry.riskresponse_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        boolean ragRepair = FGPTASAuditStatus.isRepairable((FGPTASAuditStatus)FGPTASAuditStatus.keyOf((String)dyo.getString("runtimestatus")));
        boolean ocrRepair = OcrStatus.isRepairable((OcrStatus)OcrStatus.keyOf((String)dyo.getString("ocr_status")), (String)dyo.getString("ocr_error"));
        log.info(String.format("try to retry rag:%s, ocr:%s", dyo.getString("runtimestatus"), dyo.getString("ocr_status")));
        if (ragRepair) {
            dyo.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey());
        }
        if (ocrRepair) {
            dyo.set("ocr_status", (Object)OcrStatus.RUNNING.getKey());
        }
        DynamicObjectCollection riskEntry = dyo.getDynamicObjectCollection("riskentry");
        for (DynamicObject risk : riskEntry) {
            if (!"0".equals(risk.getString("riskstatus"))) continue;
            risk.set("riskstatus", null);
            risk.set("riskresponse_tag", null);
        }
        SaveServiceHelper.update((DynamicObject)dyo);
        this.afterBindData(new EventObject((Object)this));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSEFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("fgptas_no_audit_show");
                fsp.setCustomParam(PARA_ENTITY_ID, (Object)this.entityId);
                fsp.setCustomParam(PARA_ENTITY_OBJECT, (Object)this.entityNumber);
                fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NOAUDITAGREEPRIVACY));
                this.getView().showForm(fsp);
                return;
            }
            this.getView().invokeOperation("refresh");
        } else if (PRICACYtIPFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("fgptas_no_audit_show");
                fsp.setCustomParam(PARA_ENTITY_ID, (Object)this.entityId);
                fsp.setCustomParam(PARA_ENTITY_OBJECT, (Object)this.entityNumber);
                fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NOAUDITAGREEPRIVACY));
                this.getView().showForm(fsp);
            } else {
                this.openDialog("gai_privacy_agreement", "userAgreement", CLOSEFSP);
            }
        } else if (NOAUDITAGREEPRIVACY.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.getView().invokeOperation("refresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAttachmentAuditFlex() {
        long entityId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(PARA_ENTITY_ID) + "");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(PARA_ENTITY_OBJECT);
        DynamicObject obj = BillAuditHelper.findBillAudit((String)entityNumber, (Object)entityId);
        try {
            String target = FormFactory.getTarget(obj);
            if ("fgptas_no_audit_show".equals(target)) {
                this.showErrForm();
            } else if (obj != null) {
                this.getPageCache().put(CACHE_BILL_AUDIT, obj.getLong("id") + "");
                this.commitParentCache(obj);
                FGPTASAuditStatus ragStatus = FGPTASAuditStatus.keyOf((String)obj.getString("runtimestatus"));
                OcrStatus ocrStatus = OcrStatus.keyOf((String)obj.getString("ocr_status"));
                boolean riskLoading = BillAuditHelper.enableRisk((DynamicObject)obj) && BillAuditHelper.riskStatus((DynamicObject)obj) == null;
                this.cacheAnalysisData(obj);
                this.setAttachData(obj, ocrStatus);
                this.showFlexAtt(obj, ragStatus);
                this.showFlexErr(obj, ragStatus, ocrStatus);
                this.showFlexLoading(ragStatus, ocrStatus, riskLoading);
                this.showFlexTool(obj, ragStatus, ocrStatus);
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            this.getView().close();
        }
        finally {
            if (obj == null) {
                this.showErrForm();
            }
        }
    }

    private void setAttachData(DynamicObject obj, OcrStatus ocrStatus) {
        Map<String, Object> riskMap = this.showFlexRisk(obj);
        Map<String, Object> attMap = this.showFlexOcr(obj, ocrStatus);
        HashMap<String, Object> value = new HashMap<String, Object>(3);
        value.put("riskWarningList", Collections.emptyList());
        value.put("attachs", Collections.emptyList());
        value.put(KEY_OCR, "");
        value.putAll(riskMap);
        value.putAll(attMap);
        if (((List)value.get("riskWarningList")).isEmpty() && ((List)value.get("attachs")).isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_ocr"});
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("methodName", "setAttachData");
        data.put("value", value);
        CustomControl control = (CustomControl)this.getControl(KEY_OCR);
        control.setData(Collections.singletonList(data));
    }

    private Map<String, Object> showFlexRisk(DynamicObject obj) {
        DynamicObjectCollection riskEntry = obj.getDynamicObjectCollection("riskentry");
        HashMap<String, Object> riskFlex = new HashMap<String, Object>(1);
        if (riskEntry == null || riskEntry.isEmpty()) {
            return riskFlex;
        }
        ArrayList risks = new ArrayList(riskEntry.size());
        for (DynamicObject riskItem : riskEntry) {
            HashMap<String, String> bean = new HashMap<String, String>(3);
            risks.add(bean);
            bean.put("name", riskItem.getString("item_name"));
            bean.put("detail", "");
            bean.put("pass", "processing");
            String success = riskItem.getString("riskstatus");
            String riskResponseTag = riskItem.getString("riskresponse_tag");
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)success) || !StringUtils.isNotBlank((CharSequence)riskResponseTag)) continue;
            try {
                JSONObject rsp = JSONObject.parseObject((String)riskResponseTag);
                bean.put("detail", rsp.getString("result"));
                bean.put("pass", (rsp.getBooleanValue("pass") + "").toLowerCase());
            }
            catch (Exception e) {
                log.error((Throwable)e);
                riskItem.set("riskstatus", (Object)"0");
                SaveServiceHelper.update((DynamicObject)obj);
                bean.put("detail", ResManager.loadKDString((String)"\u9644\u4ef6\u5206\u6790\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"AttachmentNoAuditPlugin_13", (String)RESOURCE, (Object[])new Object[0]));
                bean.put("pass", "false");
            }
        }
        Function<String, Boolean> isFalse = "false"::equalsIgnoreCase;
        risks.sort((c1, c2) -> {
            String p1 = (String)c1.get("pass");
            String p2 = (String)c2.get("pass");
            if (((Boolean)isFalse.apply(p1)).booleanValue() && !((Boolean)isFalse.apply(p2)).booleanValue()) {
                return -1;
            }
            if (!((Boolean)isFalse.apply(p1)).booleanValue() && ((Boolean)isFalse.apply(p2)).booleanValue()) {
                return 1;
            }
            return 0;
        });
        riskFlex.put("riskWarningList", risks);
        return riskFlex;
    }

    private Map<String, Object> showFlexOcr(DynamicObject obj, OcrStatus ocrStatus) {
        String flexOcr = "flex_ocr";
        String ocr = obj.getString("ocr_output_tag");
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        if (ocrStatus == OcrStatus.SUCCESS && StringUtils.isNotBlank((CharSequence)ocr)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{flexOcr});
            DynamicObjectCollection attach = obj.getDynamicObjectCollection("ocrentry");
            ArrayList collect = new ArrayList(1);
            String kd_cs_ticket = kd.bos.session.SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
            for (DynamicObject img : attach) {
                HashMap<String, String> bean = new HashMap<String, String>(3);
                bean.put("attpk", img.getString("attpk"));
                String attachUrl = img.getString("attachurl");
                attachUrl = attachUrl.contains("?") ? attachUrl + "&kd_cs_ticket=" + kd_cs_ticket : attachUrl + "?kd_cs_ticket=" + kd_cs_ticket;
                bean.put("attachurl", attachUrl);
                bean.put("attachname", img.getString("attachname"));
                collect.add(bean);
            }
            value.put("attachs", collect);
            value.put(KEY_OCR, ocr);
        }
        return value;
    }

    private void showFlexAtt(DynamicObject obj, FGPTASAuditStatus ragStatus) {
        String summary = obj.getString("output_tag");
        boolean showRagResult = ragStatus == FGPTASAuditStatus.SUCCESS && StringUtils.isNotBlank((CharSequence)summary);
        this.getView().setVisible(Boolean.valueOf(showRagResult), new String[]{FLEX_ATTACHMENT});
        if (showRagResult) {
            summary = this.renderText(summary);
            CustomControl control = (CustomControl)this.getView().getControl(KEY_ATTACHMENT_ANALYSIS);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("methodName", "setData");
            map.put("value", String.format(TEXT_HTML_STYLE, summary));
            control.setData(map);
        }
    }

    private void showFlexErr(DynamicObject obj, FGPTASAuditStatus ragStatus, OcrStatus ocrStatus) {
        String flexErr = "flex_error";
        boolean repairable = FGPTASAuditStatus.isRepairable((FGPTASAuditStatus)ragStatus) || OcrStatus.isRepairable((OcrStatus)ocrStatus, (String)obj.getString("ocr_error")) || BillAuditHelper.enableRisk((DynamicObject)obj) && BillAuditHelper.riskStatus((DynamicObject)obj) != null && BillAuditHelper.riskStatus((DynamicObject)obj) == false;
        String partialRec = this.getPartialRec(obj, ocrStatus);
        boolean partial = !repairable && StringUtils.isNotBlank((CharSequence)partialRec);
        this.getView().setVisible(Boolean.valueOf(repairable || partial), new String[]{"flex_error"});
        this.getView().setVisible(Boolean.valueOf(repairable), new String[]{BTN_RETRY});
        Label errMsg = (Label)this.getControl("err_msg");
        if (repairable) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(this.getFailAtt(obj, ragStatus, ocrStatus)));
            errMsg.addTips(tips);
            String text = ResManager.loadKDString((String)"\u90e8\u5206\u9644\u4ef6\u5206\u6790\u51fa\u9519\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5\u3002", (String)"AttachmentNoAuditPlugin_10", (String)RESOURCE, (Object[])new Object[0]);
            errMsg.setText(text);
        } else if (partial) {
            errMsg.setText(partialRec);
        }
    }

    private String getPartialRec(DynamicObject obj, OcrStatus ocrStatus) {
        if (ocrStatus != OcrStatus.SUCCESS) {
            return null;
        }
        DynamicObjectCollection ocrEntry = obj.getDynamicObjectCollection("ocrentry");
        StringBuilder sb = new StringBuilder();
        List objects = ocrEntry.stream().filter(o -> o.getInt("unknowncount") > 0).collect(Collectors.toList());
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject o2 = (DynamicObject)objects.get(i);
            String msg = i == size - 1 ? String.format(ResManager.loadKDString((String)"\u9644\u4ef6%1$s\u7684%2$s\u5f20\u7968\u636e\u672a\u80fd\u6210\u529f\u8bc6\u522b\uff0c\u8bf7\u4eba\u5de5\u6838\u5bf9\u3002", (String)"AttachmentNoAuditPlugin_9", (String)RESOURCE, (Object[])new Object[0]), o2.getString("attachname"), o2.getInt("unknowncount")) : String.format(ResManager.loadKDString((String)"\u9644\u4ef6%1$s\u7684%2$s\u5f20\u7968\u636e\u672a\u80fd\u6210\u529f\u8bc6\u522b\uff0c\u8bf7\u4eba\u5de5\u6838\u5bf9\uff1b", (String)"AttachmentNoAuditPlugin_8", (String)RESOURCE, (Object[])new Object[0]), o2.getString("attachname"), o2.getInt("unknowncount"));
            sb.append(msg);
        }
        return sb.toString();
    }

    private String getFailAtt(DynamicObject obj, FGPTASAuditStatus ragStatus, OcrStatus ocrStatus) {
        boolean error = FGPTASAuditStatus.isError((FGPTASAuditStatus)ragStatus);
        StringJoiner sb = new StringJoiner("\n");
        if (error) {
            try {
                Object[] params;
                Map result;
                DynamicObject repo = obj.getDynamicObject("gairepo");
                if (repo != null && Boolean.parseBoolean((result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"queryRepoFilesInfo", (Object[])(params = new Object[]{repo.getPkValue()}))).get("status") + "")) {
                    List data = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(result.get("data")), List.class);
                    String files = data.stream().map(d -> ((Map)d).get("fileName") + "").collect(Collectors.joining("\n"));
                    sb.add(files);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        String files = obj.getDynamicObjectCollection("ocrentry").stream().filter(o -> BaiduOcrResultStatus.RETRY_OCR.contains(o.getString("status"))).map(o -> o.getString("attachname")).collect(Collectors.joining("\n"));
        sb.add(files);
        return sb.toString();
    }

    private void showFlexLoading(FGPTASAuditStatus ragStatus, OcrStatus ocrStatus, boolean riskLoading) {
        String flexLoading = "flex_loading";
        boolean running = FGPTASAuditStatus.isRunning((FGPTASAuditStatus)ragStatus) || ocrStatus == OcrStatus.RUNNING;
        this.getView().setVisible(Boolean.valueOf(running || riskLoading), new String[]{"flex_loading"});
        if (running || riskLoading) {
            ((Image)this.getControl("imageap")).setUrl("/kingdee/fi/images/pc/fgptas/small_loading.gif");
            IPageCache pageCache = this.getPageCache();
            pageCache.put("CACHE_SOURCE_PAGE", "fgptas_audit_show");
            pageCache.put("CACHE_TRACE_ID", RequestContext.get().getTraceId());
            pageCache.saveChanges();
            AuditProgressTaskV2 task = new AuditProgressTaskV2(this.getView().getPageCache().getPageId(), Long.valueOf(this.entityId), this.entityNumber);
            AttachmentNoAuditPlugin.THREAD_POOL.execute((Runnable)task);
            this.progressBar.setPercent(0);
            this.progressBar.start();
        }
    }

    private void showFlexTool(DynamicObject obj, FGPTASAuditStatus ragStatus, OcrStatus ocrStatus) {
        String flexTool = "flex_tool";
        if (FGPTASAuditStatus.isRunning((FGPTASAuditStatus)ragStatus) || ocrStatus == OcrStatus.RUNNING) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_tool"});
        } else if (ragStatus == FGPTASAuditStatus.SUCCESS || ocrStatus == OcrStatus.SUCCESS) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_tool", BTN_FILE_CHAT});
            this.getView().setVisible(Boolean.valueOf(FGPTASAuditStatus.isFinished((FGPTASAuditStatus)ragStatus) && OcrStatus.isFinished((OcrStatus)ocrStatus, (String)obj.getString("ocr_error"))), new String[]{BTN_SUMMARIZE});
        }
    }

    private void commitParentCache(DynamicObject dynamicObject) {
        IPageCache pageCache;
        String parentPage = this.getView().getFormShowParameter().getParentPageId();
        SessionManager current = SessionManager.getCurrent();
        if (current.existView(parentPage) && StringUtils.equals((CharSequence)"true", (CharSequence)(pageCache = current.getPageCache(parentPage)).get(CACHE_NEED_BILL_AUDIT))) {
            pageCache.put(CACHE_BILL_AUDIT, dynamicObject.getLong("id") + "");
            pageCache.saveChanges();
        }
    }

    private void showErrForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fgptas_no_audit_show");
        fsp.setCustomParam(PARA_ENTITY_ID, (Object)this.entityId);
        fsp.setCustomParam(PARA_ENTITY_OBJECT, (Object)this.entityNumber);
        fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm(fsp);
    }

    private String renderText(String outputTag) {
        return outputTag.replace("\n", "</br>");
    }

    private void openSideBar() {
        IFormView mainView = this.getView().getMainView();
        IFormView view = mainView == null ? this.getView() : mainView;
        String rootPageId = view.getPageId();
        String assistant = Optional.ofNullable(this.getView().getPageCache().get(CACHE_ANALYSIS_DATA)).orElse("");
        assistant = assistant.replaceAll("\\${3,4}", "");
        assistant = assistant.replaceAll("attachmentid[:\uff1a]?[\\d]+", "");
        DynamicObject config = null;
        try {
            long billID = NumberUtils.toLong((String)this.getPageCache().get(CACHE_GPT_BILL_ID), (long)0L);
            String entityNumber = this.getPageCache().get(CACHE_GPT_ENTITY_NUMBER);
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)billID, (String)entityNumber);
            AuditConfigSearcher searcher = new AuditConfigSearcher();
            config = searcher.search(dataEntity);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        long process = 0L;
        if (config != null && (process = config.getLong("process.id")) != 0L) {
            try {
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"selectProcessInSideBar", (Object[])new Object[]{process, rootPageId, assistant});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification("Gai sidebar is not ready");
            }
        } else {
            String tip = ResManager.loadKDString((String)"\u5ba1\u6838\u8981\u7d20\u914d\u7f6e\u672a\u521d\u59cb\u5316\u6216\u672a\u8bbe\u7f6eGPT\u4efb\u52a1:", (String)"AttachmentAuditPlugin_1", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showTipNotification(tip + process);
        }
    }

    private Boolean isAgreePrivacy() {
        Map agreePrivacy = PrivacyUtil.isAgreePrivacy();
        if (((Boolean)agreePrivacy.get("error")).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42GPT\u5f00\u53d1\u5e73\u53f0\u534f\u8bae\u51fa\u9519", (String)"PrivacyTipPlugin_2", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return false;
        }
        if (((Boolean)agreePrivacy.get("isAdmin")).booleanValue() && !((Boolean)agreePrivacy.get("adminAgree")).booleanValue()) {
            this.openDialog("gai_privacy_agreement", "tenantAgreement", CLOSEFSP);
            return false;
        }
        if (((Boolean)agreePrivacy.get("adminAgree")).booleanValue() && !((Boolean)agreePrivacy.get("userAgree")).booleanValue()) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("fgptas_no_audit_show");
            fsp.setCustomParam(PARA_ENTITY_ID, (Object)this.entityId);
            fsp.setCustomParam(PARA_ENTITY_OBJECT, (Object)this.entityNumber);
            fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(fsp);
            return false;
        }
        return true;
    }

    public void openDialog(String dialogType, String agreeType, String actionId) {
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(dialogType);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)agreeType);
        fsp.setCustomParam("htmlTip", (Object)ResManager.loadKDString((String)"\u60a8\u5c1a\u672a\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\uff0c\u5efa\u8bae\u60a8\u901a\u8fc7\u9690\u79c1\u653f\u7b56\u8be6\u60c5\u8fdb\u884c\u7b7e\u7f72\uff0c\u4ee5\u5b8c\u6574\u4f53\u9a8cGPT\u8d22\u52a1\u52a9\u624b\u529f\u80fd\u3002", (String)"PrivacyTipPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    private void cacheAnalysisData(DynamicObject obj) {
        String ocr = obj.getString("ocr_output_tag");
        ocr = StringUtils.isBlank((CharSequence)ocr) ? "" : ocr + "\r\n\r\n";
        String summary = obj.getString("output_tag");
        summary = StringUtils.isBlank((CharSequence)summary) ? "" : summary;
        this.getPageCache().put(CACHE_ANALYSIS_DATA, ocr + summary);
    }

    public void onProgress(ProgressEvent evt) {
        IPageCache pageCache = this.getView().getPageCache();
        String taskRunning = pageCache.get("task_running");
        boolean running = StringUtils.equals((CharSequence)taskRunning, (CharSequence)"true");
        if (taskRunning == null) {
            return;
        }
        if (!running) {
            this.progressBar.stop();
            pageCache.remove("task_running");
            this.afterBindData(new EventObject((Object)this));
        }
    }
}

