/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fgptas.business.audit.AuditConfig;
import kd.fi.fgptas.business.audit.AuditProgressTaskV2;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.helper.AuditConfigSearcher;
import kd.fi.fgptas.common.utils.PrivacyUtil;
import kd.fi.fgptas.formplugin.fileanalysis.AttachmentAuditPlugin;

public class AttachmentNoAuditPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHE_LAST_RETRY_KEY = "CACHE_LAST_RETRY_KEY";
    private static final Log log = LogFactory.getLog(AttachmentAuditPlugin.class);
    private Long entityId;
    private String entityObject;
    private ProgressBar progressBar;
    private Image image;
    private Label msg;
    private static final String RESOURCE = "fi-fgptas-formplugin";
    public static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"GPT_AUDIT_PROCESS", (int)(Runtime.getRuntime().availableProcessors() * 2));
    private static final String AP_IMAGE = "imageap";
    private static final String IMAGE_PROCESSING = "/kingdee/fi/images/pc/fgptas/large_loading.gif";
    private static final String IMAGE_NO_ATTACH = "/images/pc/emotion/cwy_wfj.png";
    private static final String IMAGE_ERROR = "/kingdee/fi/images/pc/fgptas/cwy_dataerror.png";
    private static final String AP_MSG = "msgap";
    private static final String AP_PROGRESS_BAR = "progressbarap";
    private static final String AP_PROGRESS_BAR_TEXT = "progressbartextap";
    private static final String AP_RETRY = "retryap";
    private static final String AP_NO_ATTACHMENT = "noattachmentap";
    private static final String AP_PRIVACY_BTN = "privacybtn";
    private static final String CACHE_PROGRESS = "progress";
    private static final String STATUS_FORCE = "status_force";
    public static final String CUSTOM_ERROR_MSG = "tip";
    private static final String CLOSEFSP = "closefsp";
    private static final String PRICACYtIPFSP = "pricacytipfsp";

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object entityId = customParams.get("entityid");
        Object entityObject = customParams.get("entityobject");
        if (entityObject == null || entityId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5ba1\u6838\u53c2\u6570\u7f3a\u5931\u3002", (String)"AttachmentNoAuditPlugin_3", (String)RESOURCE, (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.entityId = Long.parseLong(entityId + "");
        this.entityObject = (String)entityObject;
        this.addClickListeners(new String[]{AP_RETRY, AP_PRIVACY_BTN});
        this.progressBar = (ProgressBar)this.getView().getControl(AP_PROGRESS_BAR);
        this.progressBar.addProgressListener((ProgresssListener)this);
        this.image = (Image)this.getView().getControl(AP_IMAGE);
        this.msg = (Label)this.getView().getControl(AP_MSG);
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String forceStatus = (String)customParams.get(STATUS_FORCE);
        FGPTASAuditStatus status = null;
        if (StringUtils.isNotBlank((CharSequence)forceStatus)) {
            status = FGPTASAuditStatus.keyOf((String)forceStatus);
            this.getView().getFormShowParameter().getCustomParams().remove(STATUS_FORCE);
        } else {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityobject");
            QFilter[] qFilters = new QFilter[]{new QFilter("entityobject", "=", (Object)entityNumber)};
            DynamicObjectCollection enables = QueryServiceHelper.query((String)"fgptas_auditconfig", (String)"enable", (QFilter[])qFilters);
            if (enables == null || enables.isEmpty() || enables.stream().anyMatch(dyo -> "1".equals(dyo.getString("enable")))) {
                status = this.decorateStatus();
            } else {
                log.info(String.format("no config[%s] is enable.", entityNumber));
                this.showDisable();
                return;
            }
        }
        if (status == null) {
            this.showRetry(null);
            return;
        }
        switch (status) {
            case SUCCESS: {
                this.showSuccess();
                break;
            }
            case EMBEDDING_PROCESSING: 
            case GPT_AUDIT_PROCESSING: {
                this.showProcess();
                break;
            }
            case NO_ATTACHMENT: {
                this.showNoAttachment();
                break;
            }
            case GPT_ERROR: 
            case NEW: 
            case EMBEDDING_ERROR: 
            case FGPTAS_CONFIG_ERROR: {
                this.showRetry(status);
                break;
            }
            case PRICACY_ERROR: {
                this.showUserPrivacy(status);
                break;
            }
            case CURR_PRICACY_ERROR: {
                this.showUserPrivacy(status);
            }
        }
    }

    private FGPTASAuditStatus decorateStatus() {
        long entityId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("entityid") + "");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityobject");
        AuditConfigSearcher searcher = new AuditConfigSearcher();
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)entityNumber);
        DynamicObject auditConfig = searcher.search(dataEntity);
        if (auditConfig == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("entityid", "=", (Object)entityId), new QFilter("configid", "=", auditConfig.getPkValue())};
        DynamicObject auditOne = QueryServiceHelper.queryOne((String)"fgptas_billaudit", (String)"runtimestatus,ocr_status,ocr_error", (QFilter[])qFilters);
        if (auditOne == null) {
            return FGPTASAuditStatus.FGPTAS_CONFIG_ERROR;
        }
        FGPTASAuditStatus ragStatus = FGPTASAuditStatus.keyOf((String)auditOne.getString("runtimestatus"));
        OcrStatus ocrStatus = OcrStatus.keyOf((String)auditOne.getString("ocr_status"));
        if (ragStatus == FGPTASAuditStatus.NO_ATTACHMENT && ocrStatus == OcrStatus.FAIL) {
            try {
                String code = ((Map)SerializationUtils.fromJsonString((String)auditOne.getString("ocr_error"), LinkedHashMap.class)).entrySet().stream().filter(e -> "error".equals(e.getKey())).map(r -> ((LinkedHashMap)r.getValue()).get("code") + "").findAny().orElse("");
                if (code.contains(AuditErrorCode.NO_ATTACHMENT.getCode())) {
                    return FGPTASAuditStatus.NO_ATTACHMENT;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ragStatus == FGPTASAuditStatus.SUCCESS || ocrStatus == OcrStatus.SUCCESS) {
            return FGPTASAuditStatus.SUCCESS;
        }
        if (FGPTASAuditStatus.isRunning((FGPTASAuditStatus)ragStatus) || ocrStatus == OcrStatus.RUNNING) {
            return FGPTASAuditStatus.GPT_AUDIT_PROCESSING;
        }
        if (FGPTASAuditStatus.isError((FGPTASAuditStatus)ragStatus)) {
            return ragStatus;
        }
        if (ocrStatus == OcrStatus.FAIL) {
            return FGPTASAuditStatus.GPT_ERROR;
        }
        return ragStatus;
    }

    public void click(EventObject evt) {
        Control ap = (Control)evt.getSource();
        String id = ap.getKey();
        if (AP_RETRY.equals(id)) {
            if (this.isAgreePrivacy().booleanValue()) {
                this.doRetry();
            }
        } else if (AP_PRIVACY_BTN.equals(id)) {
            this.openDialog("gai_privacy_agreement", "userAgreement", CLOSEFSP);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSEFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String statusKey = (String)customParams.get("statusKey");
            FGPTASAuditStatus status = FGPTASAuditStatus.keyOf((String)statusKey);
            if (FGPTASAuditStatus.PRICACY_ERROR.getKey().equals(status.getKey())) {
                this.doRetry();
                return;
            }
            this.showSuccess();
        } else if (PRICACYtIPFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.openDialog("gai_privacy_agreement", "userAgreement", CLOSEFSP);
        }
    }

    private void doRetry() {
        String statusString = FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        fsp.setCustomParam(STATUS_FORCE, (Object)statusString);
        this.getView().updateView();
    }

    private void showRetry(FGPTASAuditStatus status) {
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_RETRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_NO_ATTACHMENT, AP_PROGRESS_BAR_TEXT, AP_PRIVACY_BTN});
        this.image.setUrl(IMAGE_ERROR);
        this.setRetryTip(status);
        this.progressBar.stop();
    }

    private void setRetryTip(FGPTASAuditStatus status) {
        String tip = ResManager.loadKDString((String)"\u9644\u4ef6\u5206\u6790\u51fa\u9519\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5", (String)"AttachmentNoAuditPlugin_0", (String)RESOURCE, (Object[])new Object[0]);
        String lastKey = this.getPageCache().get(CACHE_LAST_RETRY_KEY);
        if (status == null || status == FGPTASAuditStatus.FGPTAS_CONFIG_ERROR) {
            tip = ResManager.loadKDString((String)"\u672a\u914d\u5230\u76f8\u5339\u914d\u7684\u5ba1\u6838\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AttachmentNoAuditPlugin_12", (String)RESOURCE, (Object[])new Object[0]);
            if (status == FGPTASAuditStatus.keyOf((String)lastKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u5355\u636e\u7c7b\u578b\u548c\u89c4\u5219\uff0c\u627e\u4e0d\u5230\u6709\u6548\u7684\u9644\u4ef6\u5ba1\u6838\u8981\u7d20\u3002", (String)"AttachmentNoAuditPlugin_5", (String)RESOURCE, (Object[])new Object[0]));
            }
        }
        if (status == null) {
            this.getPageCache().remove(CACHE_LAST_RETRY_KEY);
        } else {
            this.getPageCache().put(CACHE_LAST_RETRY_KEY, status.getKey());
        }
        this.msg.setText(tip);
    }

    private void showUserPrivacy(FGPTASAuditStatus status) {
        if (FGPTASAuditStatus.PRICACY_ERROR.getKey().equals(status.getKey())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{AP_RETRY});
            this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_NO_ATTACHMENT, AP_PROGRESS_BAR_TEXT, AP_PRIVACY_BTN});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{AP_RETRY, AP_PRIVACY_BTN});
            this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_NO_ATTACHMENT, AP_PROGRESS_BAR_TEXT});
        }
        this.image.setUrl(IMAGE_ERROR);
        this.setPrivacyTip(status);
        this.progressBar.stop();
    }

    private void setPrivacyTip(FGPTASAuditStatus status) {
        DynamicObject config = new AuditConfig(this.entityObject).getConfigDyo();
        String tip = ResManager.loadKDString((String)"\u540e\u53f0\u603b\u7ed3\u5ba1\u6838\u8981\u7d20\u65f6\u7531\u4e8eA\u672a\u7b7e\u8ba2\u9690\u79c1\u534f\u8bae\u5bfc\u81f4\u63d0\u524d\u603b\u7ed3\u5ba1\u6838\u8981\u7d20\u5931\u8d25\uff0c\n\u60a8\u53ef\u4ee5\u70b9\u51fb\u91cd\u8bd5\u6309\u94ae\uff0c\u91cd\u65b0\u603b\u7ed3", (String)"AttachmentNoAuditPlugin_6", (String)RESOURCE, (Object[])new Object[0]);
        if (FGPTASAuditStatus.PRICACY_ERROR.getKey().equals(status.getKey())) {
            long fgptasUser = config.getDynamicObject("fgptasuser").getLong("id");
            DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"bos_user", (QFilter[])new QFilter("id", "=", (Object)fgptasUser).toArray());
            String trueName = user.getString("name");
            tip = tip.replaceAll("A", trueName);
        } else {
            tip = ResManager.loadKDString((String)"\u60a8\u5c1a\u672a\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\uff0c\u5efa\u8bae\u60a8\u901a\u8fc7\u9690\u79c1\u653f\u7b56\u8be6\u60c5\u8fdb\u884c\u7b7e\u7f72\uff0c\u4ee5\u5b8c\u6574\u4f53\u9a8cGPT\u8d22\u52a1\u52a9\u624b\u529f\u80fd\u3002", (String)"PrivacyTipPlugin_1", (String)RESOURCE, (Object[])new Object[0]);
        }
        String lastKey = this.getPageCache().get(CACHE_LAST_RETRY_KEY);
        if (status == null) {
            this.getPageCache().remove(CACHE_LAST_RETRY_KEY);
        } else {
            this.getPageCache().put(CACHE_LAST_RETRY_KEY, status.getKey());
        }
        this.msg.setText(tip);
    }

    private void showNoAttachment() {
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_NO_ATTACHMENT, AP_RETRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_PRIVACY_BTN});
        this.image.setUrl(IMAGE_NO_ATTACH);
        this.msg.setText(ResManager.loadKDString((String)"\u65e0\u53ef\u5206\u6790\u9644\u4ef6", (String)"AttachmentNoAuditPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
        ((Label)this.getControl(AP_NO_ATTACHMENT)).setText(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u5355\u4e2a\u6587\u6863100M\u4ee5\u5185\u7684\u6587\u4ef6\uff0c\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f\uff1apdf\u3001txt\u3001json\u3001jpg\u3001jpeg\u3001png\u3001bmp\u3001OFD", (String)"AttachmentNoAuditPlugin_7", (String)RESOURCE, (Object[])new Object[0]));
        this.progressBar.stop();
    }

    private void showProcess() {
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_PROGRESS_BAR_TEXT});
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_RETRY, AP_NO_ATTACHMENT, AP_PRIVACY_BTN});
        this.image.setUrl(IMAGE_PROCESSING);
        this.msg.setText(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u9644\u4ef6\u5206\u6790", (String)"AttachmentNoAuditPlugin_2", (String)RESOURCE, (Object[])new Object[0]));
        IPageCache pageCache = this.getPageCache();
        pageCache.put("CACHE_SOURCE_PAGE", "fgptas_no_audit_show");
        pageCache.put("CACHE_TRACE_ID", RequestContext.get().getTraceId());
        pageCache.put("CACHE_FORCED", (String)this.getView().getFormShowParameter().getCustomParam("forced"));
        pageCache.saveChanges();
        AuditProgressTaskV2 task = new AuditProgressTaskV2(pageCache.getPageId(), this.entityId, this.entityObject);
        THREAD_POOL.execute((Runnable)task);
        this.progressBar.setPercent(0);
        this.progressBar.start();
    }

    private void showSuccess() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fgptas_audit_show");
        fsp.setCustomParam("entityid", (Object)this.entityId);
        fsp.setCustomParam("entityobject", (Object)this.entityObject);
        fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm(fsp);
    }

    public void onProgress(ProgressEvent evt) {
        IPageCache pageCache = this.getView().getPageCache();
        String taskRunning = pageCache.get("task_running");
        boolean running = StringUtils.equals((CharSequence)taskRunning, (CharSequence)"true");
        if (taskRunning == null) {
            return;
        }
        if (!running) {
            this.progressBar.stop();
            pageCache.batchRemove(Collections.singletonList("task_running"));
            this.afterBindData(new EventObject((Object)this));
        }
    }

    private void showDisable() {
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_RETRY});
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_PROGRESS_BAR, AP_PRIVACY_BTN, AP_NO_ATTACHMENT});
        this.image.setUrl(IMAGE_ERROR);
        this.msg.setText(ResManager.loadKDString((String)"\u5ba1\u6838\u65b9\u6848\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u5e76\u542f\u7528\u3002", (String)"AttachmentNoAuditPlugin_11", (String)RESOURCE, (Object[])new Object[0]));
        this.progressBar.stop();
    }

    private Boolean isAgreePrivacy() {
        Map agreePrivacy = PrivacyUtil.isAgreePrivacy();
        if (((Boolean)agreePrivacy.get("error")).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42GPT\u5f00\u53d1\u5e73\u53f0\u534f\u8bae\u51fa\u9519", (String)"PrivacyTipPlugin_2", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return false;
        }
        if (((Boolean)agreePrivacy.get("isAdmin")).booleanValue() && !((Boolean)agreePrivacy.get("adminAgree")).booleanValue()) {
            this.openDialog("gai_privacy_agreement", "tenantAgreement", CLOSEFSP);
            return false;
        }
        if (((Boolean)agreePrivacy.get("adminAgree")).booleanValue() && !((Boolean)agreePrivacy.get("userAgree")).booleanValue()) {
            this.getView().updateView();
            return false;
        }
        return true;
    }

    public void openDialog(String dialogType, String agreeType, String actionId) {
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(dialogType);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)agreeType);
        fsp.setCustomParam("htmlTip", (Object)ResManager.loadKDString((String)"\u60a8\u5c1a\u672a\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\uff0c\u5efa\u8bae\u60a8\u901a\u8fc7\u9690\u79c1\u653f\u7b56\u8be6\u60c5\u8fdb\u884c\u7b7e\u7f72\uff0c\u4ee5\u5b8c\u6574\u4f53\u9a8cGPT\u8d22\u52a1\u52a9\u624b\u529f\u80fd\u3002", (String)"PrivacyTipPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }
}

