/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fgptas.business.accesslog.GPTSkillAccesslogHelper;
import kd.fi.fgptas.business.audit.strategy.OcrBillAudit;
import kd.fi.fgptas.common.enums.SkillTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class AuditChatAction
implements IGPTAction {
    private static final String BILL_AUDIT_CHAT = "BILL_AUDIT_CHAT";
    private static final Log log = LogFactory.getLog(AuditChatAction.class);

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        log.info(String.format("action:%s, params:%s", action, SerializationUtils.toJsonString(params)));
        GPTSkillAccesslogHelper.accesslog((String)SkillTypeEnum.ATTACHMENT_REVIEW.getCode());
        Map<String, String> nextRequest = new HashMap<String, String>(2);
        switch (action) {
            case "BILL_AUDIT_CHAT": {
                try {
                    nextRequest = this.doChat(params);
                    break;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    nextRequest.put("status", "error");
                    nextRequest.put("msg", String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff1a%s", (String)"AuditChatAction_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
        return nextRequest;
    }

    private Map<String, String> doChat(Map<String, String> params) {
        IPageCache pageCache;
        String pageId = params.get("PAGE_ID");
        HashMap<String, String> nextRequest = new HashMap<String, String>(2);
        nextRequest.put("status", "error");
        nextRequest.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u4f1a\u8bdd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u3002", (String)"AuditChatAction_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        boolean existView = SessionManager.getCurrent().existView(pageId);
        if (!existView || (pageCache = SessionManager.getCurrent().getViewNoPlugin(pageId).getPageCache()) == null) {
            log.warn(String.format("\u9875\u9762%s\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8bdd\u6216\u8005\u56de\u5230\u53d1\u8d77\u8be2\u95ee\u7684\u9875\u9762\u3002", pageId));
            String error = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8bdd\u6216\u8005\u56de\u5230\u53d1\u8d77\u8be2\u95ee\u7684\u9875\u9762\u3002", (String)"AuditChatAction_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
            nextRequest.put("msg", error);
            return nextRequest;
        }
        String billId = pageCache.get("gpt.billId");
        String billAuditId = pageCache.get("gpt.bill_audit");
        String entityNumber = pageCache.get("gpt.entityNumber");
        String userIdCache = pageCache.get("gpt.userId");
        log.info(String.format("doChat: billId-%s, entityNumber-%s, userId-%s, billAuditId-%s", billId, entityNumber, userIdCache, billAuditId));
        boolean anyBlank = StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{billId, entityNumber, userIdCache});
        if (anyBlank) {
            return nextRequest;
        }
        DynamicObject billAudit = BusinessDataServiceHelper.loadSingle((String)"fgptas_billaudit", (String)"gairepo.id,ocrentry.attachname,ocrentry.status,ocrentry.ocrresponse_tag", (QFilter[])new QFilter("id", "=", (Object)billAuditId).toArray());
        HashMap<String, String> p = new HashMap<String, String>(4);
        if (billAudit == null) {
            return p;
        }
        long repoId = billAudit.getLong("gairepo.id");
        log.info(String.format("queryOne: gairepo.id-%s", repoId));
        p.put("repoIds", repoId == 0L ? null : repoId + "");
        p.put("v1", OcrBillAudit.joinOcrResponse((DynamicObject)billAudit));
        return p;
    }
}

