/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.fgptas.common.utils.PrivacyUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class AuditConfigPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String RESOURCE = "fi-fgptas-formplugin";
    @Deprecated
    private static final String RULE = "rule";
    @Deprecated
    private static final String RULE_BE = "rule_be";
    private static final String ROW = "row";
    private static final String CLOSEFSP = "closefsp";
    private static final String PRICACYtIPFSP = "pricacytipfsp";
    private static final String AUDIT_CONFIG_CACHE = "audit_config_bind";
    private static final String SAVE_PRIVACY = "save_privacy";
    private static final Log log = LogFactory.getLog(AuditConfigPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{RULE, "index_method", "userkeyfield", "fgptasuser"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        Control control = this.getControl("process");
        ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        try {
            String s = this.getPageCache().get(AUDIT_CONFIG_CACHE);
            if (StringUtils.isBlank((CharSequence)s) || "true".equals(s)) {
                this.getPageCache().put(AUDIT_CONFIG_CACHE, "false");
                Boolean canNext = this.isAgreePrivacy();
                if (!canNext.booleanValue()) {
                    return;
                }
            }
            ComboEdit indexMethod = (ComboEdit)this.getView().getControl("index_method");
            indexMethod.setComboItems(this.selectIndex());
        }
        catch (Exception ex) {
            String error = ResManager.loadKDString((String)"\u83b7\u53d6GPT\u5f00\u53d1\u5e73\u53f0\u7d22\u5f15\u65b9\u5f0f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5GPT\u5f00\u53d1\u5e73\u53f0\u8bbe\u7f6e\u3002", (String)"AuditConfigPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(error);
        }
    }

    private Boolean isAgreePrivacy() {
        Map agreePrivacy = PrivacyUtil.isAgreePrivacy();
        if (((Boolean)agreePrivacy.get("error")).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42GPT\u5f00\u53d1\u5e73\u53f0\u534f\u8bae\u51fa\u9519", (String)"PrivacyTipPlugin_2", (String)RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return Boolean.FALSE;
        }
        if (((Boolean)agreePrivacy.get("isAdmin")).booleanValue() && !((Boolean)agreePrivacy.get("adminAgree")).booleanValue()) {
            this.openDialog("gai_privacy_agreement", "tenantAgreement", CLOSEFSP);
            return Boolean.FALSE;
        }
        if (((Boolean)agreePrivacy.get("adminAgree")).booleanValue() && !((Boolean)agreePrivacy.get("userAgree")).booleanValue()) {
            this.openDialog("fgptas_privacy_tip", "", PRICACYtIPFSP);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void openDialog(String dialogType, String agreeType, String actionId) {
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(dialogType);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)agreeType);
        fsp.setCustomParam("htmlTip", (Object)ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u7531\u4e8e\u672a\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\uff0c\u3010\u7d22\u5f15\u65b9\u5f0f\u83b7\u53d6\u3011\u51fa\u9519\u4e86\uff0c \u8bf7\u7b7e\u7f72GPT\u9690\u79c1\u653f\u7b56\u540e\u91cd\u65b0\u83b7\u53d6\u3002", (String)"PrivacyTipPlugin_0", (String)RESOURCE, (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put(ROW, row + "");
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (RULE.equals(key)) {
            this.openRuleSelector();
        } else if ("userkeyfield".equals(key)) {
            this.openOrgSelector();
        }
    }

    private void openOrgSelector() {
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entityobject");
        if (entity == null) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("entityKey", (Object)entity.getString("number"));
        fsp.setCustomParam("entityName", (Object)entity.getString("name"));
        fsp.setFormId("fgptas_proptree");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "userkeyfield"));
        this.getView().showForm(fsp);
    }

    private List<ComboItem> selectIndex() {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"queryIndexMethod", (Object[])new Object[0]);
        log.info(result.toString());
        Object d = result.get("data");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (d != null) {
            List data = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(d), List.class);
            for (Map datum : data) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(datum.get("name") + ""));
                comboItem.setValue(datum.get("number") + "");
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    private void openRuleSelector() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fgptas_element_rule");
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobject");
        if (entityObject == null) {
            return;
        }
        String entityNumber = entityObject.getString("number");
        fsp.setCustomParam("entityNumber", (Object)entityNumber);
        String row = this.getPageCache().get(ROW);
        if (StringUtils.isNotBlank((CharSequence)row)) {
            int r = Integer.parseInt(row);
            fsp.setCustomParam(RULE_BE, this.getModel().getValue(RULE_BE, r));
        }
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RULE));
        this.getView().showForm(fsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        if (RULE.equals(key)) {
            model.setValue(RULE_BE, null, rowIndex);
        } else if ("userkeyfield".equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((Object)newValue)) {
                model.setValue("userkey", null);
            }
        } else if ("fgptasuser".equals(key)) {
            LicenseCheckResult licenseCheckResult;
            long newValue;
            DynamicObject newUser = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newUser != null && (newValue = NumberUtils.toLong((String)(newUser.getPkValue() + ""), (long)0L)) != 0L && !(licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)newValue, (Long)618L)).getHasLicense().booleanValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5efa\u8bae\u91cd\u65b0\u9009\u62e9GPT\u8d22\u52a1\u52a9\u624b\u4eba\u5458\uff1a%s", (String)"AuditConfigPlugin_2", (String)RESOURCE, (Object[])new Object[0]), licenseCheckResult.getMsg()));
            }
        } else if ("entityobject".equals(key)) {
            model.beginInit();
            DynamicObject current = model.getDataEntity();
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_auditconfig");
            DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof IFieldHandle)) continue;
                ((IFieldHandle)property).applyDefaultValue(model, object, 0);
            }
            object.set("entityobject", e.getChangeSet()[0].getNewValue());
            object.set("index_method", current.get("index_method"));
            object.set("prompt", current.get("prompt"));
            object.set("process", current.get("process"));
            object.set("fgptasuser", current.get("fgptasuser"));
            object.set("name", current.get("name"));
            model.createNewData((Object)object);
            model.createNewEntryRow("entryentity");
            model.endInit();
            this.getView().updateView();
            this.getPageCache().put(AUDIT_CONFIG_CACHE, "false");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (RULE.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!(returnData instanceof Map)) {
                return;
            }
            Map data = (Map)returnData;
            String row = this.getPageCache().get(ROW);
            if (StringUtils.isNotBlank((CharSequence)row)) {
                int r = Integer.parseInt(row);
                String rule = (String)data.get(RULE);
                String ruleBE = (String)data.get(RULE_BE);
                this.getModel().setValue(RULE, (Object)rule, r);
                this.getModel().setValue(RULE_BE, (Object)ruleBE, r);
            }
        } else if ("userkeyfield".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!(returnData instanceof Map)) {
                return;
            }
            Map data = (Map)returnData;
            this.getModel().setValue("userkeyfield", data.get("alias"));
            this.getModel().setValue("userkey", data.get("key"));
        } else if (CLOSEFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                this.getView().close();
            } else {
                try {
                    ComboEdit indexMethod = (ComboEdit)this.getView().getControl("index_method");
                    indexMethod.setComboItems(this.selectIndex());
                }
                catch (Exception ex) {
                    String error = ResManager.loadKDString((String)"\u83b7\u53d6GPT\u5f00\u53d1\u5e73\u53f0\u7d22\u5f15\u65b9\u5f0f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5GPT\u5f00\u53d1\u5e73\u53f0\u8bbe\u7f6e\u3002", (String)"AuditConfigPlugin_3", (String)RESOURCE, (Object[])new Object[0]);
                    this.getView().showErrorNotification(error);
                }
            }
        } else if (PRICACYtIPFSP.equals(actionId)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                this.getView().close();
            } else {
                this.openDialog("gai_privacy_agreement", "userAgreement", CLOSEFSP);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("process".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setShowApproved(false);
            formShowParameter.setCaption(ResManager.loadKDString((String)"GPT\u4efb\u52a1\u5217\u8868", (String)"AuditConfigPlugin_0", (String)RESOURCE, (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            int size = 0;
            for (DynamicObject entry : collection) {
                size += entry.getString("element").length();
            }
            if (size >= 1000) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5ba1\u6838\u8981\u7d20\u603b\u5b57\u7b26\u6570\u4e0d\u5f97\u591a\u4e8e1000\u5b57\u7b26\u3002", (String)"AuditConfigPlugin_1", (String)RESOURCE, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty property = dataEntity.getDynamicObjectType().getProperty("userkey");
        dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("name", null);
        model.setValue("entityobject", null);
        model.setValue("userkeyfield", null);
        model.setValue("userkey", null);
        model.deleteEntryData("entryentity");
        model.createNewEntryRow("entryentity");
        model.endInit();
    }
}

