/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fgptas.business.audit.pojo.ConditionEditModel;

public class AuditConfigStartRulePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(AuditConfigStartRulePlugin.class);
    private static final String START_RULE = "start_rule";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{START_RULE});
    }

    public void afterBindData(EventObject e) {
        this.loadStartRule();
    }

    private void loadStartRule() {
        String json = this.getModel().getValue("start_rule_be_tag") + "";
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                ConditionEditModel condition = (ConditionEditModel)SerializationUtils.fromJsonString((String)json, ConditionEditModel.class);
                this.getModel().setValue(START_RULE, (Object)condition.getDesc());
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicProperty property = dataEntity.getDynamicObjectType().getProperty(START_RULE);
                dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u542f\u52a8\u6761\u4ef6\u5931\u8d25:" + json, (Throwable)e);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (START_RULE.equals(key)) {
            this.openStartRuleGridFilter();
        }
    }

    private void openStartRuleGridFilter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject entity = dataEntity.getDynamicObject("entityobject");
        if (entity == null) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("param_entity", (Object)entity.getString("number"));
        fsp.setCustomParam("condition_json", (Object)dataEntity.getString("start_rule_be_tag"));
        fsp.setFormId("fgptas_condition_edit");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, START_RULE));
        this.getView().showForm(fsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (START_RULE.equals(key) && StringUtils.isBlank((CharSequence)((newValue = e.getChangeSet()[0].getNewValue()) + ""))) {
            model.setValue("start_rule_be_tag", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty property = dataEntity.getDynamicObjectType().getProperty("start_rule_be");
        dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
        property = dataEntity.getDynamicObjectType().getProperty("start_rule_be_tag");
        dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (START_RULE.equals(actionId)) {
            this.setStartRuleFromCloseCallBack(closedCallBackEvent);
        }
    }

    private void setStartRuleFromCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map data = (Map)returnData;
        try {
            String json = (String)data.get("condition");
            ConditionEditModel condition = (ConditionEditModel)SerializationUtils.fromJsonString((String)json, ConditionEditModel.class);
            IDataModel model = this.getModel();
            if (!StringUtils.equals((CharSequence)json, (CharSequence)(model.getValue("start_rule_be_tag") + ""))) {
                model.setValue(START_RULE, (Object)condition.getDesc());
                model.setValue("start_rule_be_tag", (Object)json);
            }
        }
        catch (Exception e) {
            log.error("get condition error", (Throwable)e);
        }
    }
}

