/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fgptas.business.audit.pojo.ConditionEditModel;
import org.apache.commons.lang3.StringUtils;

public class ConditionEditFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_FILTER_AP = "filtergridap";
    private static final String KEY_BTN_OK = "btnok";
    static final String PARAM_ENTITY = "param_entity";
    static final String PARAM_CONDITION_JSON = "condition_json";
    static final String RETURN_CONDITION = "condition";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void beforeBindData(EventObject e) {
        this.initFilterAp();
    }

    public void afterBindData(EventObject e) {
        this.initFilterApValue();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_OK.equals(key)) {
            MainEntityType entityType = this.getEntityType();
            FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
            FilterCondition currentCondition = filterGrid.getFilterGridState().getFilterCondition();
            FilterBuilder currentFilterBuilder = new FilterBuilder(entityType, currentCondition, false);
            currentFilterBuilder.buildFilter(false);
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            ConditionEditModel conditionEditModel = new ConditionEditModel();
            conditionEditModel.setDesc(currentFilterBuilder.getFilterObject().getFilter());
            conditionEditModel.setCondition(SerializationUtils.toJsonString((Object)currentCondition));
            returnData.put(RETURN_CONDITION, SerializationUtils.toJsonString((Object)conditionEditModel));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void initFilterAp() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
        MainEntityType entityType = this.getEntityType();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(filterColumns);
    }

    private void initFilterApValue() {
        ConditionEditModel conditionEditModel;
        String condition;
        String conditionJson = this.getParam(PARAM_CONDITION_JSON);
        FilterCondition filterCondition = null;
        if (StringUtils.isNotEmpty((CharSequence)conditionJson) && StringUtils.isNotEmpty((CharSequence)(condition = (conditionEditModel = (ConditionEditModel)SerializationUtils.fromJsonString((String)conditionJson, ConditionEditModel.class)).getCondition()))) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_AP);
            filterGrid.SetValue(filterCondition);
        }
    }

    private MainEntityType getEntityType() {
        return EntityMetadataCache.getDataEntityType((String)this.getParam(PARAM_ENTITY));
    }

    private String getParam(String paramKey) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        return (String)fsp.getCustomParam(paramKey);
    }
}

