/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ElementRuleSelectorPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_FILTER = "filtergridap";
    private static final String BTN_OK = "btnok";
    public static final String PARA_ENTITY_NUMBER = "entityNumber";
    public static final String PARA_RULE = "rule";
    public static final String PARA_RULE_BE = "rule_be";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(PARA_ENTITY_NUMBER);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        FilterGrid rule = (FilterGrid)this.getControl(CONTROL_FILTER);
        rule.setEntityNumber(entityType.getName());
        rule.setFilterColumns(filterColumns);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String ruleBE = (String)fsp.getCustomParam(PARA_RULE_BE);
        if (StringUtils.isNotBlank((CharSequence)ruleBE)) {
            FilterGrid rule = (FilterGrid)this.getControl(CONTROL_FILTER);
            FilterCondition ruleCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleBE, FilterCondition.class);
            rule.SetValue(ruleCondition);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(PARA_ENTITY_NUMBER);
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
            filterBuilder.buildFilter(false);
            String billParamFilter = filterBuilder.getFilterObject().getFilter();
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            returnData.put(PARA_RULE, billParamFilter);
            returnData.put(PARA_RULE_BE, SerializationUtils.toJsonString((Object)filterCondition));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

