/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.fileanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class PropTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ClickListener {
    private Map<String, String> complexPropCache = null;
    private Map<String, String> treeNodeCache = null;
    private Map<String, Map<String, String>> propNameCache = null;
    private static final Log log = LogFactory.getLog(PropTreePlugin.class);
    private static final String USER_ONLY = "useronly";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("propTree");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"ok", "cancel"});
    }

    private void initPropTree(String entityKey, String entityName) {
        TreeView tree = (TreeView)this.getView().getControl("propTree");
        tree.deleteAllNodes();
        TreeNode root = this.createEntityPropertyTree(entityKey, entityName, null);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Map mapEntry = entityType.getAllEntities();
        for (Map.Entry entry : mapEntry.entrySet()) {
            TreeNode rootChild;
            List childrenNodeList;
            EntityType entityTypeEntry = (EntityType)entry.getValue();
            String key = (String)entry.getKey();
            if (key.equals(entityKey) || !CollectionUtils.isNotEmpty((Collection)(childrenNodeList = (rootChild = this.createEntityPropertyTree(key, entityTypeEntry.getDisplayName().toString(), entityTypeEntry)).getChildren()))) continue;
            root.addChild(rootChild);
        }
        root.setIsOpened(true);
        tree.addNode(root);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityKey = (String)showParameter.getCustomParam("entityKey");
        String entityName = (String)showParameter.getCustomParam("entityName");
        this.initPropTree(entityKey, entityName);
    }

    private TreeNode createEntityPropertyTree(String entityNumber, String entityName, EntityType entityTypeEntry) {
        TreeNode root = new TreeNode();
        try {
            DataEntityPropertyCollection proColl;
            if (entityTypeEntry == null) {
                root.setId("root");
                root.setText(entityName);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                proColl = entityType.getProperties();
            } else {
                IDataEntityType parent;
                if (entityTypeEntry instanceof SubEntryType && (parent = entityTypeEntry.getParent()) != null && parent.getParent() != null) {
                    entityNumber = parent.getName() + "." + entityNumber;
                }
                root.setId(entityNumber);
                root.setText(entityName);
                proColl = entityTypeEntry.getProperties();
            }
            List<TreeNode> children = this.generatePropChildren(root.getId(), proColl, true);
            root.setChildren(children);
        }
        catch (KDException e) {
            log.error("createEntityPropertyTree\u5f02\u5e38 ", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        return root;
    }

    private List<TreeNode> generatePropChildren(String parentID, DataEntityPropertyCollection proColl, boolean generateChildren) {
        String treeNodeCacheString = this.getPageCache().get("treeNodeCache");
        if (this.treeNodeCache == null) {
            this.treeNodeCache = treeNodeCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)treeNodeCacheString, Map.class) : new HashMap<String, String>();
        }
        String complexPropCacheString = this.getPageCache().get("complexPropCache");
        if (this.complexPropCache == null) {
            this.complexPropCache = complexPropCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)complexPropCacheString, Map.class) : new HashMap<String, String>();
        }
        String propNameCacheString = this.getPageCache().get("propNameCache");
        if (this.propNameCache == null) {
            this.propNameCache = propNameCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class) : new HashMap<String, Map<String, String>>();
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (IDataEntityProperty prop : proColl) {
            boolean allowShow;
            DynamicProperty dp;
            if (prop instanceof DynamicLocaleProperty || prop instanceof PKFieldProp || prop instanceof EntryProp) continue;
            TreeNode node = new TreeNode();
            node.setParentid(parentID);
            if ("root".equals(parentID)) {
                node.setId(prop.getName());
            } else {
                node.setId(parentID + "." + prop.getName());
            }
            node.setText(prop.getName());
            if (prop instanceof DynamicProperty && (dp = (DynamicProperty)prop).getDisplayName() != null) {
                node.setText(dp.getDisplayName().toString());
            }
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("type", prop.getPropertyType().getName());
            propMap.put("mark", node.getId());
            if (this.propNameCache.get(parentID) != null) {
                Map<String, String> propMapParent = this.propNameCache.get(parentID);
                propMap.put("name", propMapParent.get("name") + "." + node.getText());
            } else {
                propMap.put("name", node.getText());
            }
            this.propNameCache.put(node.getId(), propMap);
            if (prop instanceof DynamicComplexProperty) {
                DynamicComplexProperty dcp = (DynamicComplexProperty)prop;
                IDataEntityType det = dcp.getComplexType();
                if (det == null) continue;
                String entityTypeName = det.getName();
                this.treeNodeCache.put(node.getId(), entityTypeName);
                this.complexPropCache.put(node.getId(), SerializationUtils.toJsonString((Object)node));
                boolean isGenerate = this.validGenerateChildren(prop);
                if (generateChildren && isGenerate) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
                    DataEntityPropertyCollection proColl1 = entityType.getProperties();
                    List<TreeNode> children = this.generatePropChildren(node.getId(), proColl1, false);
                    node.setChildren(children);
                }
            }
            if (!(allowShow = this.validFieldConfiguration(prop))) continue;
            nodeList.add(node);
        }
        if (generateChildren) {
            this.getPageCache().put("complexPropCache", SerializationUtils.toJsonString(this.complexPropCache));
            this.getPageCache().put("treeNodeCache", SerializationUtils.toJsonString(this.treeNodeCache));
            this.getPageCache().put("propNameCache", SerializationUtils.toJsonString(this.propNameCache));
        }
        return nodeList;
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String propNameCacheString = this.getPageCache().get("propNameCache");
        if (propNameCacheString != null) {
            this.getPageCache().put("NodeID", (String)arg0.getNodeId());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        HashMap retMap = new HashMap();
        String key = ((Control)evt.getSource()).getKey();
        String nodeID = this.getPageCache().get("NodeID");
        if ("ok".equals(key)) {
            String propNameCacheString = this.getPageCache().get("propNameCache");
            if (propNameCacheString != null) {
                Map propNameCache = (Map)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class);
                Map propMap = (Map)propNameCache.get(nodeID);
                if (propMap == null) {
                    return;
                }
                FormShowParameter parameter = this.getView().getFormShowParameter();
                retMap.put("alias", propMap.get("name"));
                retMap.put("type", propMap.get("type"));
                retMap.put("mark", propMap.get("mark"));
            }
            retMap.put("key", nodeID);
            log.info("\u5173\u95ed\u5b9e\u4f53\u5c5e\u6027\u9009\u62e9\uff0c\u8fd4\u56de\uff1a" + ((Object)retMap).toString());
            this.getView().returnDataToParent(retMap);
            this.getView().close();
        } else if ("cancel".equals(key)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (USER_ONLY.equals(key)) {
            this.getView().updateView();
        }
    }

    private boolean validFieldConfiguration(IDataEntityProperty prop) {
        if (this.getModel().getDataEntity().getBoolean(USER_ONLY)) {
            return prop instanceof UserProp;
        }
        return true;
    }

    private boolean validGenerateChildren(IDataEntityProperty prop) {
        return !(prop instanceof UserProp);
    }
}

