/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.indexanalysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fgptas.business.accesslog.GPTSkillAccesslogHelper;
import kd.fi.fgptas.business.datatable.InvokePluginHelper;
import kd.fi.fgptas.business.indexanalysis.helper.GPTReturnHelper;
import kd.fi.fgptas.business.indexanalysis.redis.IndexAnalysisRedis;
import kd.fi.fgptas.common.enums.BooleanEnum;
import kd.fi.fgptas.common.enums.DatasourceEnum;
import kd.fi.fgptas.common.enums.IndexAnalysisStatusEnum;
import kd.fi.fgptas.common.enums.PermissionItemEnum;
import kd.fi.fgptas.common.enums.SkillTypeEnum;

public class IndexAnalysisAction
implements IGPTAction,
Serializable {
    private static final Log logger = LogFactory.getLog(IndexAnalysisAction.class);
    public static final String STATUS = "status";
    public static final String MSG = "msg";
    public static final String USER_INPUT = "userInput";
    public static final String REPORT_LIST = "reportList";
    public static final String MATCH_REPORT = "matchReport";
    public static final String REPORT_NUMBER = "reportNumber";
    public static final String ORG_LIST = "orgList";
    public static final String MATCH_ORG = "matchOrg";
    public static final String FIELD_LIST = "fieldList";
    public static final String MATCH_FIELD = "matchField";
    public static final String FIELD_VALUE_LIST = "fieldValueList";
    public static final String MATCH_FIELD_VALUE = "matchFieldValue";
    public static final String DATA = "data";
    public static final String CHART_URL = "chartUrl";
    public static final String CHART_DATA = "chartData";
    public static final String SHOW_TEXT = "showText";
    public static final String GPT_ANAL_TEXT = "gptAnalText";
    public static final String CUSTOM_ACTION_GET_REPORT_LIST = "getReportList";
    public static final String CUSTOM_ACTION_GET_ORG_LIST = "getOrgList";
    public static final String CUSTOM_ACTION_GET_FIELD_LIST = "getFieldList";
    public static final String CUSTOM_ACTION_GET_FIELD_VALUE = "getFieldValueList";
    public static final String CUSTOM_ACTION_GET_DATA = "getData";
    public static final String CUSTOM_ACTION_HANDLE_CHART_AND_TEXT = "handleChartAndText";

    public Map<String, String> invokeAction(String action, Map<String, String> inputParams) {
        logger.info("IndexAnalysisAction,invokeAction,input,action:{},params:{}", (Object)action, inputParams);
        Map<Object, Object> returnParams = new HashMap(16);
        switch (action) {
            case "getReportList": {
                GPTSkillAccesslogHelper.accesslog((String)SkillTypeEnum.INDEX_ANALYSIS.getCode());
                returnParams = this.getReportList();
                break;
            }
            case "getOrgList": {
                returnParams = this.getOrgList(inputParams);
                break;
            }
            case "getFieldList": {
                returnParams = this.getFieldList(inputParams);
                break;
            }
            case "getFieldValueList": {
                returnParams = this.getFieldValueList(inputParams);
                break;
            }
            case "getData": {
                returnParams = this.getData(inputParams);
                break;
            }
            case "handleChartAndText": {
                returnParams = this.handleChartAndText(inputParams);
                GPTSkillAccesslogHelper.updateAccessLog((String)SkillTypeEnum.INDEX_ANALYSIS.getCode(), (Boolean)Boolean.TRUE);
                break;
            }
        }
        logger.info("IndexAnalysisAction,invokeAction,return,action:{},params:{}", (Object)action, returnParams);
        return returnParams;
    }

    private Map<String, String> handleChartAndText(Map<String, String> inputParams) {
        String url;
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        StringBuilder stringBuilder = new StringBuilder();
        String domainUrl = System.getProperty("domain.contextUrl");
        String formId = "fgptas_chart_display";
        stringBuilder.append(domainUrl).append("?formId=").append(formId);
        String status = inputParams.get(STATUS);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)IndexAnalysisStatusEnum.SUCCESS.getValue())) {
            returnParams.put(STATUS, status);
            returnParams.put(SHOW_TEXT, inputParams.get(MSG));
            String url2 = stringBuilder.append("&gaiIframeSize={\"width\":0,\"height\":0}").toString();
            returnParams.put(CHART_URL, url2);
            return returnParams;
        }
        try {
            String chartData = inputParams.get(CHART_DATA);
            if (chartData.contains("option")) {
                chartData = GPTReturnHelper.removeChartJsExtraString((String)chartData);
                ScriptEngineManager engineManager = new ScriptEngineManager();
                ScriptEngine engine = engineManager.getEngineByExtension("js");
                SimpleScriptContext context = new SimpleScriptContext();
                engine.eval(chartData, (ScriptContext)context);
                chartData = String.valueOf(engine.eval("JSON.stringify(option)", (ScriptContext)context));
            }
            JSONObject jsonChartData = JSONObject.parseObject((String)chartData);
            IndexAnalysisRedis.setChartData((String)jsonChartData.toJSONString());
            url = stringBuilder.append("&gaiIframeSize={\"width\":1066,\"height\":380}").toString();
        }
        catch (Exception e) {
            logger.info("handleChartAndText,parseJsonError,Exception:{}", (Object)e);
            url = stringBuilder.append("&gaiIframeSize={\"width\":0,\"height\":0}").toString();
        }
        returnParams.put(CHART_URL, url);
        returnParams.put(SHOW_TEXT, inputParams.get(GPT_ANAL_TEXT));
        return returnParams;
    }

    private Map<String, String> getData(Map<String, String> inputParams) {
        JSONObject matchFilterFieldValue;
        Map<String, String> returnParams = new HashMap<String, String>(16);
        String status = inputParams.get(STATUS);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)IndexAnalysisStatusEnum.SUCCESS.getValue())) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, inputParams.get(MSG));
            return returnParams;
        }
        try {
            matchFilterFieldValue = JSONObject.parseObject((String)inputParams.get(MATCH_FIELD_VALUE)).getJSONObject(MATCH_FIELD_VALUE);
        }
        catch (Exception e) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7b5b\u9009\u6761\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        if (matchFilterFieldValue == null) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7b5b\u9009\u6761\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        String reportNumber = inputParams.get(REPORT_NUMBER);
        JSONArray matchOrg = JSONObject.parseObject((String)inputParams.get(MATCH_ORG)).getJSONArray(MATCH_ORG);
        String sql = this.buildSql(matchFilterFieldValue, matchOrg, reportNumber);
        logger.info("getData,buildSql:{}", (Object)sql);
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"number,retrievalplugin,datasource,fieldnumber,fieldname", (QFilter[])new QFilter("number", "=", (Object)reportNumber).toArray());
        String dataSource = dataTable.getString("datasource");
        if (StringUtils.equals((CharSequence)dataSource, (CharSequence)DatasourceEnum.INTERFACE.getValue())) {
            String className = dataTable.getString("retrievalplugin");
            String userInput = inputParams.get(USER_INPUT);
            returnParams = this.getDataByInterface(userInput, sql, className);
        } else {
            returnParams = this.getDataByTable(dataTable, sql);
        }
        return returnParams;
    }

    private Map<String, String> getFieldValueList(Map<String, String> inputParams) {
        JSONArray gptMatchField;
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        String status = inputParams.get(STATUS);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)IndexAnalysisStatusEnum.SUCCESS.getValue())) {
            returnParams.put(STATUS, status);
            returnParams.put(MSG, inputParams.get(MSG));
            return returnParams;
        }
        try {
            gptMatchField = JSONObject.parseObject((String)inputParams.get(MATCH_FIELD)).getJSONArray(MATCH_FIELD);
        }
        catch (Exception e) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u6761\u4ef6\u5b57\u6bb5\u6e05\u5355\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        if (gptMatchField == null) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u6761\u4ef6\u5b57\u6bb5\u6e05\u5355\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        String reportNumber = inputParams.get(REPORT_NUMBER);
        QFilter numberFilter = new QFilter("number", "=", (Object)reportNumber);
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"datasource,retrievalplugin", (QFilter[])numberFilter.toArray());
        String dataSource = dataTable.getString("datasource");
        JSONObject fieldValueJson = new JSONObject();
        MainEntityType reportMainEntityType = EntityMetadataCache.getDataEntityType((String)reportNumber);
        for (Object field : gptMatchField) {
            DynamicProperty dynamicProperty = reportMainEntityType.getProperty(field.toString());
            if (dynamicProperty == null) continue;
            if (dynamicProperty instanceof BasedataProp) {
                DynamicObject[] baseDataArr;
                DynamicProperty enableProperty;
                BasedataProp basedataProp = (BasedataProp)reportMainEntityType.getProperty(field.toString());
                String baseDataFormId = basedataProp.getBaseEntityId();
                MainEntityType baseDataMainEntityType = EntityMetadataCache.getDataEntityType((String)baseDataFormId);
                DynamicProperty nameProperty = baseDataMainEntityType.getProperty("name");
                if (nameProperty == null) continue;
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
                if (dynamicProperty instanceof AssistantProp) {
                    long asstTypeId = Long.parseLong(((AssistantProp)dynamicProperty).getAsstTypeId());
                    QFilter asstTypeFilter = new QFilter("group", "=", (Object)asstTypeId);
                    filterList.add(asstTypeFilter);
                }
                if ((enableProperty = baseDataMainEntityType.getProperty("enable")) != null) {
                    QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable.toString());
                    filterList.add(enableFilter);
                }
                if (StringUtils.equals((CharSequence)dataSource, (CharSequence)DatasourceEnum.TABLE.getValue())) {
                    baseDataArr = BusinessDataServiceHelper.load((String)baseDataFormId, (String)"name", (QFilter[])filterList.toArray(new QFilter[0]), null, (int)200);
                } else {
                    String className = dataTable.getString("retrievalplugin");
                    Object[] args = new Object[]{reportNumber, field.toString(), filterList.toArray(new QFilter[0]), null};
                    logger.info("getFieldValueList,getBaseDataId,request,className:{},args:{}", (Object)className, (Object)args);
                    List baseDataIdList = (List)InvokePluginHelper.invokePlugin((String)className, (String)"getBaseDataId", (Object[])args);
                    logger.info("getFieldValueList,getBaseDataId,response,className:{},args:{},baseDataIdList:{}", new Object[]{className, args, baseDataIdList});
                    if (baseDataIdList == null || baseDataIdList.isEmpty()) continue;
                    baseDataArr = BusinessDataServiceHelper.load((Object[])baseDataIdList.toArray(), (DynamicObjectType)baseDataMainEntityType);
                }
                Set fieldValue = Arrays.stream(baseDataArr).map(baseData -> baseData.getLocaleString("name").getLocaleValue()).collect(Collectors.toSet());
                fieldValueJson.put(field.toString(), fieldValue);
                continue;
            }
            if (!(dynamicProperty instanceof ComboProp)) continue;
            ComboProp comboProp = (ComboProp)reportMainEntityType.getProperty(field.toString());
            List fieldValue = comboProp.getComboItems().stream().filter(ValueMapItem::isItemVisible).map(item -> item.getName().getLocaleValue()).collect(Collectors.toList());
            fieldValueJson.put(field.toString(), fieldValue);
        }
        returnParams.put(STATUS, status);
        returnParams.put(MSG, "");
        returnParams.put(FIELD_VALUE_LIST, fieldValueJson.toJSONString());
        returnParams.put(MATCH_FIELD, gptMatchField.toJSONString());
        return returnParams;
    }

    private Map<String, String> getFieldList(Map<String, String> inputParams) {
        JSONArray gptMatchOrg;
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        String status = inputParams.get(STATUS);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)IndexAnalysisStatusEnum.SUCCESS.getValue())) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, inputParams.get(MSG));
            return returnParams;
        }
        try {
            gptMatchOrg = JSONObject.parseObject((String)inputParams.get(MATCH_ORG)).getJSONArray(MATCH_ORG);
        }
        catch (Exception e) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7ec4\u7ec7\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        if (gptMatchOrg == null) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7ec4\u7ec7\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        String reportNumber = inputParams.get(REPORT_NUMBER);
        QFilter numberFilter = new QFilter("number", "=", (Object)reportNumber);
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"name,fieldnumber,fieldname,fieldtype,fieldquery,fixedvalue,fielddesc,ispreset", (QFilter[])numberFilter.toArray());
        String reportName = dataTable.getLocaleString("name").getLocaleValue();
        if (gptMatchOrg.isEmpty()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, String.format(ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7ec4\u7ec7%1$s\u548c\u62a5\u8868[%2$s]\u4e0d\u5728\u60a8\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u548c\u62a5\u8868\u6e05\u5355\u4e2d\u3002", (String)"IndexAnalysisAction_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), gptMatchOrg.toJSONString(), reportName));
            return returnParams;
        }
        JSONArray orgList = JSONArray.parseArray((String)inputParams.get(ORG_LIST));
        for (Object org : gptMatchOrg) {
            if (orgList.contains(org)) continue;
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, String.format(ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u7ec4\u7ec7%1$s\u548c\u62a5\u8868[%2$s]\u4e0d\u5728\u60a8\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u548c\u62a5\u8868\u6e05\u5355\u4e2d\u3002", (String)"IndexAnalysisAction_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), gptMatchOrg.toJSONString(), reportName));
            return returnParams;
        }
        DynamicObjectCollection entryEntity = dataTable.getDynamicObjectCollection("entryentity");
        JSONObject filterFields = new JSONObject();
        for (DynamicObject entry : entryEntity) {
            String fieldNumber = entry.getString("fieldnumber");
            String fieldName = entry.getLocaleString("fieldname").getLocaleValue();
            String fieldDesc = entry.getLocaleString("fielddesc").getLocaleValue();
            String fieldType = entry.getString("fieldtype");
            boolean isPreset = entry.getBoolean("ispreset");
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"Org") && isPreset || !entry.getBoolean("fieldquery") || !StringUtils.isEmpty((CharSequence)entry.getString("fixedvalue"))) continue;
            String filedValue = String.join((CharSequence)"_", fieldName, fieldDesc);
            filterFields.put(fieldNumber, (Object)filedValue);
        }
        returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
        returnParams.put(MSG, "");
        returnParams.put(FIELD_LIST, filterFields.toJSONString());
        return returnParams;
    }

    private Map<String, String> getOrgList(Map<String, String> inputParams) {
        String gptMatchReport;
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        String status = inputParams.get(STATUS);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)IndexAnalysisStatusEnum.SUCCESS.getValue())) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, inputParams.get(MSG));
            return returnParams;
        }
        try {
            gptMatchReport = JSONObject.parseObject((String)inputParams.get(MATCH_REPORT)).getString(MATCH_REPORT);
        }
        catch (Exception e) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u62a5\u8868\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        if (gptMatchReport == null) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u62a5\u8868\u89e3\u6790\u5931\u8d25\uff0c\u5927\u6a21\u578b\u672a\u6309\u8981\u6c42\u7684\u7ed3\u6784\u8fd4\u56de\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u95ee\u8be2\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        if (StringUtils.isEmpty((CharSequence)gptMatchReport)) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u5c0f\u52a9\u624b\u5728\u60a8\u7684\u95ee\u9898\u4e2d\u672a\u80fd\u8bc6\u522b\u5230\u9700\u8981\u67e5\u8be2\u7684\u62a5\u8868\u3002\u8bf7\u6ce8\u610f\uff0c\u6307\u6807\u5206\u6790\u5c0f\u52a9\u624b\u4ec5\u80fd\u8fdb\u884c\u6570\u636e\u67e5\u8be2\u548c\u5206\u6790\uff0c\u8bf7\u60a8\u91cd\u65b0\u63d0\u95ee\u3002", (String)"IndexAnalysisAction_8", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        JSONArray reportList = JSONArray.parseArray((String)inputParams.get(REPORT_LIST));
        String reportName = gptMatchReport.split("_")[0];
        if (reportList.stream().noneMatch(report -> String.valueOf(report).contains(gptMatchReport))) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, String.format(ResManager.loadKDString((String)"GPT\u8bc6\u522b\u7684\u62a5\u8868[%s]\u4e0d\u5728\u60a8\u6709\u6743\u9650\u7684\u6570\u636e\u8868\u4e2d\u3002", (String)"IndexAnalysisAction_5", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), reportName));
            return returnParams;
        }
        QFilter nameFilter = new QFilter("name", "=", (Object)reportName);
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"number,fieldtype,ispreset,fieldproperty,fieldpropertyjson_tag", (QFilter[])nameFilter.toArray());
        Optional<DynamicObject> orgField = dataTable.getDynamicObjectCollection("entryentity").stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("fieldtype"), (CharSequence)"Org") && entry.getBoolean("isPreset")).findFirst();
        String orgViewType = OrgViewTypeEnum.IS_ORGUNIT.getViewType();
        String orgViewTypeName = OrgViewTypeEnum.IS_ORGUNIT.getName();
        if (orgField.isPresent() && StringUtils.isNotEmpty((CharSequence)orgField.get().getString("fieldpropertyjson_tag"))) {
            orgViewType = JSONObject.parseObject((String)orgField.get().getString("fieldpropertyjson_tag")).getString("orgFuncs");
            orgViewTypeName = orgField.get().getString("fieldproperty");
        }
        logger.info("getOrgList,orgViewType:{}", (Object)orgViewType);
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)"fgptas", (String)dataTable.getString("number"), (String)PermissionItemEnum.QUERY.getId());
        List<Object> orgIds = !permOrgResult.hasAllOrgPerm() ? new ArrayList(permOrgResult.getHasPermOrgs()) : OrgUnitServiceHelper.getAllOrgByViewNumber((String)orgViewType, (boolean)false);
        orgIds = orgIds.stream().limit(200L).collect(Collectors.toList());
        logger.info("getOrgList,filterOrgIds:{}", orgIds);
        if (orgIds.isEmpty()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
            returnParams.put(MSG, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u8868[%1$s]\u7684[%2$s]\u6743\u9650\uff0c\u65e0\u6cd5\u56de\u7b54\u60a8\u7684\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_6", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), reportName, orgViewTypeName));
            return returnParams;
        }
        QFilter orgIdFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] permOrgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{orgIdFilter});
        JSONArray orgs = new JSONArray();
        for (DynamicObject org : permOrgs) {
            orgs.add((Object)org.getLocaleString("name").getLocaleValue());
        }
        returnParams.put(REPORT_NUMBER, dataTable.getString("number"));
        returnParams.put(ORG_LIST, orgs.toJSONString());
        returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
        returnParams.put(MSG, "");
        return returnParams;
    }

    private Map<String, String> getReportList() {
        QFilter reportFilter = new QFilter(STATUS, "=", (Object)"C").and("enable", "=", (Object)"1");
        DynamicObject[] dataTableArray = BusinessDataServiceHelper.load((String)"fgptas_datatable", (String)"number,name,description", (QFilter[])reportFilter.toArray());
        ArrayList dataTables = new ArrayList(dataTableArray.length);
        Collections.addAll(dataTables, dataTableArray);
        Iterator it = dataTables.iterator();
        JSONArray report = new JSONArray();
        while (it.hasNext()) {
            DynamicObject dataTable = (DynamicObject)it.next();
            HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)"fgptas", (String)dataTable.getString("number"), (String)PermissionItemEnum.QUERY.getId());
            if (!permOrgResult.hasAllOrgPerm() && permOrgResult.getHasPermOrgs().isEmpty()) continue;
            report.add((Object)String.join((CharSequence)"_", dataTable.getLocaleString("name").getLocaleValue(), dataTable.getLocaleString("description").getLocaleValue()));
        }
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        if (report.isEmpty()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8868\u6743\u9650\uff0c\u65e0\u6cd5\u56de\u7b54\u60a8\u7684\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IndexAnalysisAction_7", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        } else {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
            returnParams.put(MSG, "");
            returnParams.put(REPORT_LIST, report.toJSONString());
        }
        return returnParams;
    }

    private Map<String, String> getDataByTable(DynamicObject dataTable, String sql) {
        DynamicObjectCollection entryEntity = dataTable.getDynamicObjectCollection("entryEntity");
        MainEntityType reportType = EntityMetadataCache.getDataEntityType((String)dataTable.getString("number"));
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        JSONArray dataArray = new JSONArray();
        DataSet dataSet = DB.queryDataSet((String)"gptFiIndexAnalysis", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        if (dataSet.isEmpty()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u6839\u636e\u60a8\u7684\u95ee\u9898\uff0cGPT\u52a9\u624b\u5df2\u6210\u529f\u8bc6\u522b\u7b5b\u9009\u6761\u4ef6\u5e76\u8fdb\u884c\u4e86\u67e5\u8be2\uff0c\u4f46\u672a\u80fd\u67e5\u8be2\u5230\u4efb\u4f55\u6570\u636e\u3002\u8bf7\u5c1d\u8bd5\u63d0\u51fa\u4e0d\u540c\u7684\u95ee\u9898\u6216\u68c0\u67e5\u6570\u636e\uff0c\u5982\u6709\u9700\u8981\u8bf7\u968f\u65f6\u91cd\u65b0\u63d0\u95ee\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u63d0\u4f9b\u6570\u636e\u67e5\u8be2\u548c\u5206\u6790\u670d\u52a1\u3002", (String)"IndexAnalysisAction_11", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return returnParams;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            JSONObject jsonObject = new JSONObject();
            for (int fieldIndex = 0; fieldIndex < row.size(); ++fieldIndex) {
                Date date;
                String fieldNumber = ((DynamicObject)entryEntity.get(fieldIndex)).getString("fieldnumber");
                String fieldName = ((DynamicObject)entryEntity.get(fieldIndex)).getString("fieldname");
                DynamicProperty dynamicProperty = reportType.getProperty(fieldNumber);
                if (dynamicProperty instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)dynamicProperty;
                    int finalFieldIndex = fieldIndex;
                    Optional<ValueMapItem> optional = comboProp.getComboItems().stream().filter(item -> StringUtils.equals((CharSequence)item.getValue(), (CharSequence)row.getString(finalFieldIndex))).findAny();
                    if (optional.isPresent()) {
                        jsonObject.put(fieldName, (Object)optional.get().getName().getLocaleValue());
                        continue;
                    }
                    jsonObject.put(fieldName, (Object)row.getString(finalFieldIndex));
                    continue;
                }
                if (dynamicProperty instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)dynamicProperty;
                    if (QueryServiceHelper.exists((String)basedataProp.getBaseEntityId(), (Object)row.getLong(fieldIndex))) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getLong(fieldIndex), (String)basedataProp.getBaseEntityId());
                        jsonObject.put(fieldName, (Object)dynamicObject.getLocaleString("name").getLocaleValue());
                        continue;
                    }
                    jsonObject.put(fieldName, (Object)"");
                    continue;
                }
                if (dynamicProperty instanceof DateProp) {
                    date = row.getDate(fieldIndex);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    jsonObject.put(fieldName, (Object)sdf.format(date));
                    continue;
                }
                if (dynamicProperty instanceof DateTimeProp) {
                    date = row.getDate(fieldIndex);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    jsonObject.put(fieldName, (Object)sdf.format(date));
                    continue;
                }
                if (dynamicProperty instanceof IntegerProp) {
                    jsonObject.put(fieldName, (Object)String.valueOf(row.getInteger(fieldIndex)));
                    continue;
                }
                if (dynamicProperty instanceof DecimalProp) {
                    jsonObject.put(fieldName, (Object)String.valueOf(row.getBigDecimal(fieldIndex).stripTrailingZeros()));
                    continue;
                }
                if (dynamicProperty instanceof BooleanProp) {
                    String booleanString = row.getBoolean(fieldIndex) != false ? ResManager.loadKDString((String)"\u662f", (String)"IndexAnalysisAction_9", (String)"fi-fgptas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"IndexAnalysisAction_10", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
                    jsonObject.put(fieldName, (Object)booleanString);
                    continue;
                }
                jsonObject.put(fieldName, row.get(fieldIndex));
            }
            dataArray.add((Object)jsonObject);
        }
        returnParams.put(DATA, JSONArray.toJSONString((Object)dataArray));
        returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
        returnParams.put(MSG, "");
        return returnParams;
    }

    private Map<String, String> getDataByInterface(String userInput, String sql, String className) {
        Object[] objectArray;
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        if (userInput != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = userInput;
        } else {
            objectArray = null;
        }
        Object[] cusParams = objectArray;
        Object[] args = new Object[]{sql, cusParams};
        logger.info("getData,request,className:{},args:{}", (Object)className, (Object)args);
        long beginGetDataTimeStamp = System.currentTimeMillis();
        logger.info("getData,request,className:{},args:{}", (Object)className, (Object)args);
        String dataJsonString = (String)InvokePluginHelper.invokePlugin((String)className, (String)CUSTOM_ACTION_GET_DATA, (Object[])args);
        long endGetDataTimeStamp = System.currentTimeMillis();
        logger.info("getData,cost:{}ms", (Object)(endGetDataTimeStamp - beginGetDataTimeStamp));
        logger.info("getData,response,data:{}", (Object)dataJsonString);
        String failMessage = ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u6839\u636e\u60a8\u7684\u95ee\u9898\uff0cGPT\u52a9\u624b\u5df2\u6210\u529f\u8bc6\u522b\u7b5b\u9009\u6761\u4ef6\u5e76\u8fdb\u884c\u4e86\u67e5\u8be2\uff0c\u4f46\u672a\u80fd\u67e5\u8be2\u5230\u4efb\u4f55\u6570\u636e\u3002\u8bf7\u5c1d\u8bd5\u63d0\u51fa\u4e0d\u540c\u7684\u95ee\u9898\u6216\u68c0\u67e5\u6570\u636e\uff0c\u5982\u6709\u9700\u8981\u8bf7\u968f\u65f6\u91cd\u65b0\u63d0\u95ee\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u63d0\u4f9b\u6570\u636e\u67e5\u8be2\u548c\u5206\u6790\u670d\u52a1\u3002", (String)"IndexAnalysisAction_11", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
        if (dataJsonString == null) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, failMessage);
            return returnParams;
        }
        JSONObject dataJson = JSONObject.parseObject((String)dataJsonString);
        Boolean success = dataJson.getBoolean("success");
        if (!success.booleanValue()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, dataJson.getString("message") == null ? failMessage : dataJson.getString("message"));
        } else if (dataJson.get((Object)DATA) == null || dataJson.getJSONArray(DATA).isEmpty()) {
            returnParams.put(STATUS, IndexAnalysisStatusEnum.FAIL.getValue());
            returnParams.put(MSG, dataJson.getString("message") == null ? failMessage : dataJson.getString("message"));
        } else {
            returnParams.put(DATA, dataJson.getJSONArray(DATA).toJSONString());
            returnParams.put(STATUS, IndexAnalysisStatusEnum.SUCCESS.getValue());
            returnParams.put(MSG, "");
        }
        return returnParams;
    }

    private String buildSql(JSONObject matchFieldValue, JSONArray matchOrg, String reportNumber) {
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"number,datasource,retrievalplugin,fieldnumber,fieldquery,fixedvalue,fieldtype,ispreset", (QFilter[])new QFilter("number", "=", (Object)reportNumber).toArray());
        StringBuilder sql = new StringBuilder();
        DynamicObjectCollection entryEntity = dataTable.getDynamicObjectCollection("entryentity");
        sql.append("select ");
        MainEntityType reportType = EntityMetadataCache.getDataEntityType((String)reportNumber);
        ArrayList<String> selectFieldList = new ArrayList<String>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            DynamicProperty fieldProperty = reportType.getProperty(entry.getString("fieldnumber"));
            if (fieldProperty == null) continue;
            selectFieldList.add(fieldProperty.getAlias());
        }
        sql.append(String.join((CharSequence)",", selectFieldList));
        sql.append(" from ").append(reportType.getAlias());
        ArrayList<String> fieldSqlList = new ArrayList<String>(10);
        for (DynamicObject entry : entryEntity) {
            String fieldNumber;
            String fieldSql = null;
            if (StringUtils.equals((CharSequence)entry.getString("fieldtype"), (CharSequence)"Org") && entry.getBoolean("ispreset")) {
                fieldNumber = entry.getString("fieldnumber");
                DynamicProperty dynamicProperty = reportType.getProperty(fieldNumber);
                fieldSql = this.buildOrgFieldSql(dynamicProperty, matchOrg);
            } else if (entry.getBoolean("fieldquery")) {
                fieldNumber = entry.getString("fieldnumber");
                String fixedValue = entry.getString("fixedValue");
                DynamicProperty dynamicProperty = reportType.getProperty(fieldNumber);
                logger.info("buildSql,dynamicProperty:{},fieldNumber:{},fixedValue:{},matchFieldValue:{}", new Object[]{dynamicProperty.getName(), fieldNumber, fixedValue, matchFieldValue});
                fieldSql = StringUtils.isEmpty((CharSequence)fixedValue) ? this.buildNoFixFieldSql(dynamicProperty, matchFieldValue.getJSONArray(fieldNumber), dataTable) : this.buildFixFieldSql(dynamicProperty, fixedValue, dataTable);
            }
            if (StringUtils.isEmpty(fieldSql)) continue;
            fieldSqlList.add(fieldSql);
        }
        if (!fieldSqlList.isEmpty()) {
            sql.append(" where ").append(String.join((CharSequence)" and ", fieldSqlList));
        }
        return sql.toString();
    }

    private String buildOrgFieldSql(DynamicProperty dynamicProperty, JSONArray matchOrg) {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"", (QFilter[])new QFilter("name", "in", (Object)matchOrg).toArray());
        if (orgs == null || orgs.length == 0) {
            return "";
        }
        StringBuilder fieldSql = new StringBuilder();
        List orgIds = Arrays.stream(orgs).map(org -> org.getPkValue().toString()).collect(Collectors.toList());
        fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", orgIds), "(", ")"));
        return fieldSql.toString();
    }

    private String buildNoFixFieldSql(DynamicProperty dynamicProperty, JSONArray gptFieldValues, DynamicObject dataTable) {
        StringBuilder fieldSql = new StringBuilder();
        if (gptFieldValues != null && !gptFieldValues.isEmpty()) {
            if (dynamicProperty instanceof BooleanProp) {
                ArrayList<String> fieldValueList = new ArrayList<String>(10);
                for (Object fieldValue : gptFieldValues) {
                    if (fieldValue.equals(BooleanEnum.TRUE.getName())) {
                        fieldValueList.add(String.join((CharSequence)BooleanEnum.TRUE.getCode(), "'", "'"));
                        continue;
                    }
                    if (!fieldValue.equals(BooleanEnum.FALSE.getName())) continue;
                    fieldValueList.add(String.join((CharSequence)BooleanEnum.FALSE.getCode(), "'", "'"));
                }
                fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", fieldValueList), "(", ")"));
            } else if (dynamicProperty instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)dynamicProperty;
                ArrayList fieldValueList = new ArrayList(10);
                for (Object fieldValue : gptFieldValues) {
                    Optional<ValueMapItem> optionalValueMapItem = comboProp.getComboItems().stream().filter(item -> StringUtils.equals((CharSequence)item.getName().getLocaleValue(), (CharSequence)fieldValue.toString())).findAny();
                    optionalValueMapItem.ifPresent(valueMapItem -> fieldValueList.add(String.join((CharSequence)valueMapItem.getValue(), "'", "'")));
                }
                if (!fieldValueList.isEmpty()) {
                    fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", fieldValueList), "(", ")"));
                }
            } else if (dynamicProperty instanceof BasedataProp) {
                String baseDataFormId = ((BasedataProp)dynamicProperty).getBaseEntityId();
                String dataSource = dataTable.getString("datasource");
                String className = dataTable.getString("retrievalplugin");
                String reportNumber = dataTable.getString("number");
                String[] gptFieldArray = new String[gptFieldValues.size()];
                for (int index = 0; index < gptFieldValues.size(); ++index) {
                    gptFieldArray[index] = gptFieldValues.getString(index);
                }
                QFilter[] nameFilter = QFilter.ftlike((String[])gptFieldArray, (String[])new String[]{"name"}).toArray();
                List baseDataIds = null;
                if (StringUtils.equals((CharSequence)DatasourceEnum.INTERFACE.getValue(), (CharSequence)dataSource)) {
                    Object[] args = new Object[]{reportNumber, dynamicProperty.getName(), nameFilter, null};
                    logger.info("buildNoFixFieldSql,getBaseDataId,request,className:{},args:{}", (Object)className, (Object)args);
                    List baseDataIdList = (List)InvokePluginHelper.invokePlugin((String)className, (String)"getBaseDataId", (Object[])args);
                    logger.info("buildNoFixFieldSql,getBaseDataId,response,className:{},args:{},baseDataIdList:{}", new Object[]{className, args, baseDataIdList});
                    if (baseDataIdList != null && !baseDataIdList.isEmpty()) {
                        baseDataIds = baseDataIdList.stream().map(String::valueOf).collect(Collectors.toList());
                    }
                } else {
                    DynamicObject[] baseDatas = BusinessDataServiceHelper.load((String)baseDataFormId, (String)"", (QFilter[])nameFilter);
                    if (baseDatas.length > 0) {
                        baseDataIds = Arrays.stream(baseDatas).map(baseData -> baseData.getPkValue().toString()).collect(Collectors.toList());
                    }
                }
                if (baseDataIds != null && !baseDataIds.isEmpty()) {
                    fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", baseDataIds), "(", ")"));
                }
            } else {
                ArrayList<String> fieldValueList = new ArrayList<String>(10);
                for (Object fieldValue : gptFieldValues) {
                    fieldValueList.add(String.join((CharSequence)fieldValue.toString(), "'", "'"));
                }
                fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", fieldValueList), "(", ")"));
            }
        }
        return fieldSql.toString();
    }

    private String buildFixFieldSql(DynamicProperty dynamicProperty, String fixedValue, DynamicObject dataTable) {
        StringBuilder fieldSql = new StringBuilder();
        String[] fixes = fixedValue.split(";");
        if (dynamicProperty instanceof BasedataProp) {
            String baseDataFormId = ((BasedataProp)dynamicProperty).getBaseEntityId();
            String dataSource = dataTable.getString("datasource");
            List baseDataIds = null;
            if (StringUtils.equals((CharSequence)DatasourceEnum.INTERFACE.getValue(), (CharSequence)dataSource)) {
                String className = dataTable.getString("retrievalplugin");
                String reportNumber = dataTable.getString("number");
                QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", (Object)fixes)};
                Object[] args = new Object[]{reportNumber, dynamicProperty.getName(), qFilters, null};
                logger.info("buildFixFieldSql,getBaseDataId,request,className:{},args:{}", (Object)className, (Object)args);
                List baseDataIdList = (List)InvokePluginHelper.invokePlugin((String)className, (String)"getBaseDataId", (Object[])args);
                logger.info("buildFixFieldSql,getBaseDataId,response,className:{},args:{},baseDataIdList:{}", new Object[]{className, args, baseDataIdList});
                if (baseDataIdList != null && !baseDataIdList.isEmpty()) {
                    baseDataIds = baseDataIdList.stream().map(String::valueOf).collect(Collectors.toList());
                }
            } else {
                DynamicObject[] baseDatas = BusinessDataServiceHelper.load((String)baseDataFormId, (String)"", (QFilter[])new QFilter("number", "in", (Object)fixes).toArray());
                if (baseDatas.length > 0) {
                    baseDataIds = Arrays.stream(baseDatas).map(baseData -> baseData.getPkValue().toString()).collect(Collectors.toList());
                }
            }
            if (baseDataIds != null && !baseDataIds.isEmpty()) {
                fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", baseDataIds), "(", ")"));
            }
        } else {
            ArrayList<String> sqlFixValue = new ArrayList<String>(fixes.length);
            for (String fix : fixes) {
                sqlFixValue.add(String.join((CharSequence)fix, "'", "'"));
            }
            fieldSql.append(dynamicProperty.getAlias()).append(" in ").append(String.join((CharSequence)String.join((CharSequence)",", sqlFixValue), "(", ")"));
        }
        return fieldSql.toString();
    }
}

