/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.indexanalysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fgptas.business.indexanalysis.redis.IndexAnalysisRedis;
import kd.fi.fgptas.common.spread.SpreadContainer;
import kd.fi.fgptas.common.spread.SpreadDataModelImpl;
import kd.fi.fgptas.common.spread.command.AreasStyle;
import kd.fi.fgptas.common.spread.command.CellArea;
import kd.fi.fgptas.common.spread.command.CellStyleInfo;
import kd.fi.fgptas.common.spread.command.HorizontalAlignEnum;
import kd.fi.fgptas.common.spread.command.VerticalAlignEnum;
import kd.fi.fgptas.common.spread.command.Workbook;
import kd.fi.fgptas.common.spread.command.Worksheet;
import kd.fi.fgptas.common.spread.command.WorksheetOptions;

public class TableDisplayPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TableDisplayPlugin.class);

    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)this.getSpreadDataModelService());
    }

    private ISpreadAction getSpreadDataModelService() {
        return new SpreadDataModelImpl((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String chartData = IndexAnalysisRedis.getChartData();
        logger.info("afterBindData,chartData:{}", (Object)chartData);
        if (chartData != null) {
            JSONObject charData = JSONObject.parseObject((String)chartData);
            String reportNumber = charData.getString("reportNumber");
            DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"entryentity.fieldname", (QFilter[])new QFilter("number", "=", (Object)reportNumber).toArray());
            DynamicObjectCollection entryEntity = dataTable.getDynamicObjectCollection("entryentity");
            JSONArray dataArray = charData.getJSONArray("data");
            SpreadContainer spreadContainer = new SpreadContainer(this.getView(), "spreadap");
            int totalRow = dataArray.size() + 1;
            int totalCol = dataArray.getJSONObject(0).size();
            spreadContainer.addSheets(0, "", totalRow, totalCol);
            ArrayList parameters = new ArrayList();
            for (int arrayIndex = 0; arrayIndex < dataArray.size() + 1; ++arrayIndex) {
                for (int entryIndex = 0; entryIndex < entryEntity.size(); ++entryIndex) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    map.put("r", arrayIndex);
                    map.put("c", entryIndex);
                    if (arrayIndex == 0) {
                        map.put("v", ((DynamicObject)entryEntity.get(entryIndex)).getString("fieldname"));
                    } else {
                        JSONObject data = dataArray.getJSONObject(arrayIndex - 1);
                        map.put("v", data.get((Object)((DynamicObject)entryEntity.get(entryIndex)).getString("fieldname")));
                    }
                    parameters.add(map);
                }
            }
            spreadContainer.upDataValue(parameters);
            Workbook workbook = new Workbook();
            workbook.setShowHorizontalScrollbar(Boolean.valueOf(false));
            workbook.setShowVerticalScrollbar(Boolean.valueOf(false));
            spreadContainer.setWorkbookOptions(workbook);
            ArrayList<Worksheet> worksheetOptionsList = new ArrayList<Worksheet>(1);
            Worksheet worksheet = new Worksheet();
            worksheet.setSi(Integer.valueOf(0));
            WorksheetOptions worksheetOptions = new WorksheetOptions();
            worksheetOptions.setColHeaderVisible(Boolean.valueOf(false));
            worksheetOptions.setRowHeaderVisible(Boolean.valueOf(false));
            worksheet.setOptions(worksheetOptions);
            worksheetOptionsList.add(worksheet);
            spreadContainer.setWorksheetOptions(worksheetOptionsList);
            spreadContainer.setToolbarExpandBtnVisible(Boolean.valueOf(false));
            ArrayList<Integer> lockSheetIndexes = new ArrayList<Integer>(1);
            lockSheetIndexes.add(0);
            spreadContainer.lockSheets(lockSheetIndexes);
            spreadContainer.setColumnsWidth(IntStream.range(0, totalCol).boxed().collect(Collectors.toList()), 1060 / totalCol);
            spreadContainer.setRowsHeight(IntStream.range(0, totalRow).boxed().collect(Collectors.toList()), 30);
            ArrayList<CellArea> dataAreas = new ArrayList<CellArea>();
            CellArea dataArea = new CellArea(0, 0, totalRow, totalCol);
            dataAreas.add(dataArea);
            ArrayList<AreasStyle> areasStyles = new ArrayList<AreasStyle>();
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange(dataAreas);
            CellStyleInfo cellStyleInfo = new CellStyleInfo();
            cellStyleInfo.setVa(VerticalAlignEnum.Center);
            cellStyleInfo.setHa(HorizontalAlignEnum.Center);
            ArrayList<String> bls = new ArrayList<String>(1);
            bls.add("thin");
            cellStyleInfo.setBls(bls);
            ArrayList blc = new ArrayList(1);
            bls.add("black");
            cellStyleInfo.setBlc(blc);
            areasStyle.setStyle(cellStyleInfo);
            areasStyles.add(areasStyle);
            spreadContainer.setCellStyle(areasStyles);
        }
    }
}

