/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class HBPeriodInputFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(HBPeriodInputFormPlugin.class);
    private static final String KEY_ENTRY = "entryentity";
    private static final String BTN_NEW = "newentry";
    private static final String BTN_DEL = "deleteentry";
    private static final String DATATABLE = "hb_datatable";
    private static final String SCENARIO = "hb_scenario";
    private static final String YEAR = "hb_year";
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String PERIOD = "hb_period";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit hbDatatableF7 = (BasedataEdit)this.getControl(DATATABLE);
        hbDatatableF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hbPeriodF7 = (BasedataEdit)this.getControl(PERIOD);
        hbPeriodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hbScenarioF7 = (BasedataEdit)this.getControl(SCENARIO);
        hbScenarioF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        hbScenarioF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit hbYearF7 = (BasedataEdit)this.getControl(YEAR);
        hbYearF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{CTL_TOOLBAR_AP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        JSONArray tableArray = (JSONArray)param.getCustomParam("hb_table_array");
        String modelNum = (String)param.getCustomParam("modelNum");
        Object[] hbTableFielter = ((JSONArray)param.getCustomParam("hb_table_fielter")).stream().toArray();
        if (null != tableArray && tableArray.size() > 0) {
            this.getModel().deleteEntryRow(KEY_ENTRY, 0);
            for (Object obj : tableArray) {
                int newEntryRow = this.getModel().createNewEntryRow(KEY_ENTRY);
                JSONObject entity = (JSONObject)obj;
                this.getModel().setValue(DATATABLE, (Object)entity.getJSONArray(DATATABLE).stream().toArray(), newEntryRow);
                this.getModel().setValue(SCENARIO, entity.get((Object)SCENARIO), newEntryRow);
                this.getModel().setValue("modelNum", (Object)modelNum, newEntryRow);
                this.getModel().setValue(YEAR, entity.get((Object)YEAR), newEntryRow);
                this.getModel().setValue(PERIOD, null == entity.get((Object)PERIOD) ? null : entity.getJSONArray(PERIOD).stream().toArray(), newEntryRow);
                this.getModel().setValue("hb_table_fielter", (Object)hbTableFielter, newEntryRow);
            }
        } else {
            this.getModel().deleteEntryRow(KEY_ENTRY, 0);
            int newEntryRow = this.getModel().createNewEntryRow(KEY_ENTRY);
            this.getModel().setValue(DATATABLE, (Object)hbTableFielter, newEntryRow);
            this.getModel().setValue("modelNum", (Object)modelNum, newEntryRow);
            this.getModel().setValue("hb_table_fielter", (Object)hbTableFielter, newEntryRow);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "newentry": {
                int newEntryRow = this.getModel().createNewEntryRow(KEY_ENTRY);
                FormShowParameter param = this.getView().getFormShowParameter();
                this.getModel().setValue("hb_table_fielter", (Object)((JSONArray)param.getCustomParam("hb_table_fielter")).stream().toArray(), newEntryRow);
                this.getModel().setValue("modelNum", param.getCustomParam("modelNum"), newEntryRow);
                break;
            }
            case "deleteentry": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                this.getModel().deleteEntryRows(KEY_ENTRY, selectRows);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParam.getListFilterParameter().getQFilters();
        String modelnum = (String)this.getModel().getValue("modelnum");
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id", (QFilter[])new QFilter("number", "=", (Object)modelnum).toArray());
        switch (key) {
            case "hb_datatable": {
                if (null != model) {
                    qFilters.add(new QFilter("entryentity.fieldnumber", "match", (Object)"model"));
                    qFilters.add(new QFilter("entryentity.fixedvalue", "match", (Object)modelnum));
                }
                qFilters.add(new QFilter("datatype", "=", (Object)"1"));
                List list = ((DynamicObjectCollection)this.getModel().getValue("hb_table_fielter")).stream().map(id -> id.getDynamicObject(1).getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("id", "in", list));
                break;
            }
            case "hb_period": {
                DynamicObject scenario;
                if (null != model) {
                    qFilters.add(new QFilter("model", "=", (Object)model.getLong("id")));
                }
                if (null == (scenario = (DynamicObject)this.getModel().getValue(SCENARIO))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u5b57\u6bb5\u3002", (String)"HBPeriodInputFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                }
                List<Object> periods = new ArrayList();
                if (null != scenario.getDynamicObjectCollection("sceneperiod")) {
                    periods = scenario.getDynamicObjectCollection("sceneperiod").stream().filter(entity -> StringUtils.isNotEmpty((String)entity.getDynamicObject(1).getString("number"))).map(entity -> entity.getDynamicObject(1).getLong("id")).collect(Collectors.toList());
                }
                qFilters.add(new QFilter("id", "in", periods));
                break;
            }
            case "hb_year": {
                if (null == model) break;
                qFilters.add(new QFilter("model", "=", (Object)model.getLong("id")));
                break;
            }
            case "hb_scenario": {
                if (null == model) break;
                qFilters.add(new QFilter("model", "=", (Object)model.getLong("id")));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        if (SCENARIO.equals(key) && !this.getModel().getDataEntity().containsProperty(SCENARIO)) {
            this.getModel().setValue(PERIOD, null);
        }
    }
}

