/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.common.report.field.AbstractReportPeriodFieldService;
import kd.fi.fgptas.common.report.field.ReportPeriodFieldServiceFactory;

public class PeriodInputFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_ENTRY = "entryentity";
    private static final String DATATABLE = "datatable";
    private static final String PERIOD = "period";
    private static final String PERIOD_VALUE = "period_value";
    private static final String BTN_NEW = "newentry";
    private static final String BTN_DEL = "deleteentry";
    private static final String CTL_TOOLBAR_AP = "toolbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit datatableF7 = (BasedataEdit)this.getControl(DATATABLE);
        datatableF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{PERIOD});
        this.addItemClickListeners(new String[]{CTL_TOOLBAR_AP});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "period": {
                AbstractReportPeriodFieldService service;
                int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
                DynamicObject rowData = this.getModel().getEntryRowEntity(KEY_ENTRY, index);
                String fieldType = rowData.getString("period_type");
                Object[] selectIds = null;
                if ("Assistant".equals(fieldType) || "Basedata".equals(fieldType)) {
                    Object[] objectArray = selectIds = StringUtils.isEmpty((String)rowData.getString(PERIOD_VALUE)) ? null : Arrays.stream(rowData.getString(PERIOD_VALUE).split(",")).map(id -> Long.valueOf(id)).toArray();
                }
                if ((service = ReportPeriodFieldServiceFactory.getService((String)fieldType)) == null) break;
                String billFormId = this.getBillFormId(rowData, fieldType);
                service.showFieldPropChooseView(this.getView(), this.getModel(), this.getPluginName(), billFormId, selectIds);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newentry": {
                int newEntryRow = this.getModel().createNewEntryRow(KEY_ENTRY);
                FormShowParameter param = this.getView().getFormShowParameter();
                String period_property = (String)param.getCustomParam("period_property");
                String period_type = (String)param.getCustomParam("period_type");
                this.getModel().setValue("table_fielter", (Object)((JSONArray)param.getCustomParam("table_fielter")).stream().toArray(), newEntryRow);
                this.getModel().setValue("period_type", (Object)period_type, newEntryRow);
                this.getModel().setValue("period_property", (Object)period_property, newEntryRow);
                break;
            }
            case "deleteentry": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                this.getModel().deleteEntryRows(KEY_ENTRY, selectRows);
                break;
            }
        }
    }

    private String getBillFormId(DynamicObject rowData, String fieldType) {
        boolean suitable;
        String billFormId = "";
        JSONObject jsonObject = new JSONObject();
        String periodProperty = rowData.getString("period_property");
        boolean isJson = "Assistant".equals(fieldType) || "Basedata".equals(fieldType);
        boolean bl = suitable = isJson || "Combo".equals(fieldType) || "Date".equals(fieldType);
        if (StringUtils.isNotEmpty((String)periodProperty) && isJson) {
            jsonObject = JSONObject.parseObject((String)periodProperty);
        } else if (!suitable) {
            String name = rowData.getDynamicObjectCollection(DATATABLE).stream().map(e -> e.getDynamicObject(1).getString("name")).collect(Collectors.joining(","));
            this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a\u671f\u95f4\u5b57\u6bb5\u7c7b\u578b\u6682\u4e0d\u652f\u6301", (String)"PeriodInputFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), name));
        }
        switch (fieldType) {
            case "Basedata": {
                billFormId = MetadataDao.getEntityNumberById((String)jsonObject.getString("baseEntityId"));
                break;
            }
            case "Assistant": {
                billFormId = jsonObject.getString("asstTypeId");
                break;
            }
            case "Combo": {
                billFormId = periodProperty;
                break;
            }
        }
        return billFormId;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object retData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)retData)) {
            return;
        }
        int curIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        AbstractReportPeriodFieldService service = ReportPeriodFieldServiceFactory.getServiceByCBKey((String)e.getActionId());
        if (service != null && retData != null) {
            Map map = service.getFieldProperty(retData);
            this.getModel().setValue(PERIOD, map.get("name"), curIndex);
            this.getModel().setValue(PERIOD_VALUE, map.get("value"), curIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String period_property = (String)param.getCustomParam("period_property");
        String period_type = (String)param.getCustomParam("period_type");
        JSONArray tableArray = (JSONArray)param.getCustomParam("table_array");
        Object[] tableFielter = ((JSONArray)param.getCustomParam("table_fielter")).stream().toArray();
        if (null != tableArray && tableArray.size() > 0) {
            this.getModel().deleteEntryRow(KEY_ENTRY, 0);
            for (Object obj : tableArray) {
                int newEntryRow = this.getModel().createNewEntryRow(KEY_ENTRY);
                JSONObject entity = (JSONObject)obj;
                this.getModel().setValue(DATATABLE, (Object)entity.getJSONArray(DATATABLE).stream().toArray(), newEntryRow);
                this.getModel().setValue(PERIOD, (Object)entity.getString(PERIOD), newEntryRow);
                this.getModel().setValue(PERIOD_VALUE, entity.get((Object)PERIOD_VALUE), newEntryRow);
                this.getModel().setValue("table_fielter", (Object)tableFielter, newEntryRow);
                this.getModel().setValue("period_type", (Object)period_type, newEntryRow);
                this.getModel().setValue("period_property", (Object)period_property, newEntryRow);
            }
        } else {
            this.getModel().setValue(DATATABLE, (Object)tableFielter);
            this.getModel().setValue("table_fielter", (Object)tableFielter);
            this.getModel().setValue("period_type", (Object)period_type);
            this.getModel().setValue("period_property", (Object)period_property);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParam.getListFilterParameter().getQFilters();
        if (DATATABLE.equals(key)) {
            List list = ((DynamicObjectCollection)this.getModel().getValue("table_fielter")).stream().map(id -> id.getDynamicObject(1).getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", list));
        }
    }
}

