/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;

public class PropTreeFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String CACHE_KEY_TREE_NODE = "treeNode";
    private static final String BUTTON_KEY_OK = "btnok";
    private static final String CONTROL_KEY_TREE = "proptree";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_KEY_OK});
        TreeView tree = (TreeView)this.getView().getControl(CONTROL_KEY_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        boolean isMulti;
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_TREE);
        FormShowParameter param = this.getView().getFormShowParameter();
        boolean bl = isMulti = param.getCustomParam("isMulti") != null ? (Boolean)param.getCustomParam("isMulti") : false;
        if (!isMulti) {
            Map focusNode = tree.getTreeState().getFocusNode();
            boolean enableOp = focusNode != null && (Boolean)focusNode.get("isParent") == false;
            this.getView().setEnable(Boolean.valueOf(enableOp), new String[]{BUTTON_KEY_OK});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_KEY_OK.equals(key)) {
            TreeView tree = (TreeView)this.getControl(CONTROL_KEY_TREE);
            List selectedNodes = tree.getTreeState().getSelectedNodes();
            List selectedLeafNode = selectedNodes.stream().filter(m -> (Boolean)m.get("isParent") == false).collect(Collectors.toList());
            if (selectedLeafNode.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5c5e\u6027\u3002", (String)"PropTreeFormPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_TREE_NODE), TreeNode.class);
            HashMap<String, String> returnData = new HashMap<String, String>();
            HashSet<String> numbers = new HashSet<String>((int)((float)selectedLeafNode.size() / 0.75f) + 1);
            ArrayList<String> names = new ArrayList<String>(selectedLeafNode.size());
            for (Map node : selectedLeafNode) {
                String nodeId = (String)node.get("id");
                numbers.add(nodeId);
                TreeNode treeNode = root.getTreeNode(nodeId, 16);
                names.add(treeNode.getLongText());
            }
            returnData.put("number", String.join((CharSequence)",", numbers));
            returnData.put("name", String.join((CharSequence)"\uff1b", names));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void initTree() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityNumber = (String)param.getCustomParam("entityNumber");
        String fieldNumber = (String)param.getCustomParam("fieldNumber");
        boolean isMulti = param.getCustomParam("isMulti") != null ? (Boolean)param.getCustomParam("isMulti") : false;
        DynamicObject entityMetaData = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"datatype,entryentity,fieldnumber,fieldtype", (QFilter[])new QFilter("number", "=", (Object)entityNumber).toArray());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeBDRefProp(false);
        option.setOutTextWithKey(false);
        option.setOnlyBillHead(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        this.handleTreeNode(treeNode);
        if ("1".equals(entityMetaData.getString("datatype")) && "report_period".equals(fieldNumber)) {
            TreeNode reportPeriodNode = new TreeNode();
            reportPeriodNode.setId("scenario_year_period");
            reportPeriodNode.setText(ResManager.loadKDString((String)"\u60c5\u666f_\u8d22\u5e74_\u671f\u95f4", (String)"PropTreeFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            treeNode.getChildren().add(reportPeriodNode);
        } else if ("report_period".equals(fieldNumber)) {
            List enableFields = entityMetaData.getDynamicObjectCollection("entryentity").stream().filter(v -> "Basedata".equals(v.getString("fieldtype")) || "Combo".equals(v.getString("fieldtype")) || "Assistant".equals(v.getString("fieldtype"))).map(v -> v.getString("fieldnumber")).collect(Collectors.toList());
            Iterator iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                TreeNode node = (TreeNode)iterator.next();
                if (enableFields.contains(node.getId())) continue;
                iterator.remove();
            }
        }
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_TREE);
        tree.addNode(treeNode);
        if (isMulti) {
            tree.setMulti(true);
            String selectedProps = (String)param.getCustomParam("selectedProps");
            if (StringUtils.isNotEmpty((String)selectedProps)) {
                String[] selected = selectedProps.split(",");
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(selected.length);
                for (String sel : selected) {
                    treeNodes.add(treeNode.getTreeNode(sel));
                }
                tree.checkNodes(treeNodes);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BUTTON_KEY_OK});
        }
        this.getPageCache().put(CACHE_KEY_TREE_NODE, SerializationUtils.toJsonString((Object)treeNode));
    }

    private void handleTreeNode(TreeNode treeNode) {
        TreeNode billHead = treeNode.getTreeNode("billhead");
        treeNode.deleteChildNode("billhead");
        List children = billHead.getChildren();
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityNumber = (String)param.getCustomParam("entityNumber");
        String elements = (String)param.getCustomParam("elements");
        Set fields = "dataTableFields".equals(elements) ? ReportTemDataHelper.getDataTableFields((String)entityNumber) : ReportTemDataHelper.getConditionFields((String)entityNumber);
        if (fields != null && fields.size() > 0) {
            children.removeIf(t -> !fields.contains(t.getId()));
            treeNode.addChildren(children);
        }
    }
}

