/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fgptas.business.datatable.InvokePluginHelper;
import kd.fi.fgptas.business.report.helper.ReportGPTActionDataHelper;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;

public class ReportConditionFormPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ReportConditionFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        String conditionJson = (String)parameter.getCustomParam("conditionJson");
        FilterGrid fg = this.buildFilterAp(entityNumber);
        if (StringUtils.isNotEmpty((CharSequence)conditionJson)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            fg.SetValue(fc);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
            filterBuilder.buildFilter(false);
            String filterDes = filterBuilder.getFilterObject().getFilter();
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            returnData.put("desc", filterDes);
            returnData.put("conditionJson", SerializationUtils.toJsonString((Object)filterCondition));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private FilterGrid buildFilterAp(String entityNumber) {
        Set conditionFields;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String excludeColumns = (String)parameter.getCustomParam("excludeColumns");
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"number,entryentity,fieldnumber,fieldtype", (QFilter[])new QFilter("number", "=", (Object)entityNumber).toArray());
        Map<String, String> fieldMap = dataTable.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(e -> e.getString("fieldnumber"), e -> e.getString("fieldtype")));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil etu = new EntityTypeUtil();
        List filterColumns = etu.getFilterColumns((IDataEntityType)entityType);
        if (excludeColumns != null) {
            excludeColumns = excludeColumns.replace("scenario_year_period", "scenario,year,period");
            String[] excludeColArr = excludeColumns.split(",");
            HashSet excludeColSet = new HashSet(excludeColArr.length);
            Collections.addAll(excludeColSet, excludeColArr);
            Iterator iterator = filterColumns.iterator();
            while (iterator.hasNext()) {
                boolean workable;
                String fieldKey = ((Map)iterator.next()).get("fieldName").toString().split("\\.")[0];
                String fieldType = fieldMap.get(fieldKey);
                boolean bl = workable = "Basedata".equals(fieldType) || "Assistant".equals(fieldType) || "Combo".equals(fieldType) || "Date".equals(fieldType);
                if (!excludeColSet.contains(fieldKey) && workable) continue;
                iterator.remove();
            }
        }
        if ((conditionFields = ReportTemDataHelper.getConditionFields((String)entityNumber)) != null && conditionFields.size() > 0) {
            filterColumns.removeIf(f -> !conditionFields.contains(f.get("fieldName").toString().split("\\.")[0]));
        } else {
            filterColumns = null;
        }
        if (filterColumns != null && !filterColumns.isEmpty()) {
            List filterCompareTypes = (List)((Map)filterColumns.get(0)).get("compareTypes");
            List needCompareTypes = filterCompareTypes.stream().filter(f -> "17".equals(f.getId()) || "67".equals(f.getId())).collect(Collectors.toList());
            for (Map fl : filterColumns) {
                fl.put("compareTypes", needCompareTypes);
            }
        }
        FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
        fg.setEntityNumber(entityNumber);
        fg.setFilterColumns(filterColumns);
        this.getView().updateView("filtergridap");
        return fg;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String pluginPath;
        String fieldName = evt.getFieldName().split("\\.")[0];
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        QFilter[] entityQF = new QFilter[]{new QFilter("entryentity.fieldnumber", "=", (Object)fieldName), new QFilter("number", "=", (Object)entityNumber)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fgptas_datatable", (String)"fieldtype,entryentity,entryentity.fieldnumber,entryentity.fieldpropertyjson_tag", (QFilter[])entityQF);
        QFilter qFilter = null;
        DynamicObject fieldEntity = dynamicObject.getDynamicObjectCollection("entryentity").stream().filter(e -> fieldName.equals(e.getString("fieldnumber"))).findFirst().get();
        if (null != fieldEntity && StringUtils.isNotEmpty((CharSequence)fieldEntity.getString("fieldpropertyjson_tag")) && "Assistant".equals(fieldEntity.getString("fieldtype"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)fieldEntity.getString("fieldpropertyjson_tag"));
            Long asstTypeId = jsonObject.getLong("asstTypeId");
            qFilter = new QFilter("group", "=", (Object)asstTypeId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pluginPath = this.getDataQueryPlugin()))) {
            Object[] args = new Object[]{entityNumber, fieldName, qFilter, null};
            try {
                List baseDataIdList = (List)InvokePluginHelper.invokePlugin((String)pluginPath, (String)"getBaseDataId", (Object[])args);
                LOGGER.info(String.format("call data table plugin method{getBaseDataId} results is:%s", baseDataIdList));
                QFilter filter = new QFilter("id", "in", (Object)baseDataIdList);
                evt.addCustomQFilter(filter);
            }
            catch (Exception ex) {
                evt.setCancel(true);
                LOGGER.error("call data table plugin method{getBaseDataId} error.", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
            }
        } else {
            evt.addCustomQFilter(qFilter);
        }
    }

    private String getDataQueryPlugin() {
        String pluginPath;
        DynamicObject config;
        IPageCache pageCache = this.getPageCache();
        String dataQueryPlugin = pageCache.get("dataQueryPlugin");
        if (StringUtils.isNotEmpty((CharSequence)dataQueryPlugin)) {
            return dataQueryPlugin;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        Map dataTableConfig = ReportGPTActionDataHelper.getDataTableConfig(Collections.singleton(entityNumber));
        if (dataTableConfig != null && (config = (DynamicObject)dataTableConfig.get(entityNumber)) != null && StringUtils.isNotEmpty((CharSequence)(pluginPath = config.getString("retrievalplugin")))) {
            pageCache.put("dataQueryPlugin", pluginPath);
            return pluginPath;
        }
        return dataQueryPlugin;
    }
}

