/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportGptHelper;
import kd.fi.fgptas.business.report.helper.ReportHelper;
import kd.fi.fgptas.business.report.helper.ReportMutexHelper;
import kd.fi.fgptas.business.report.helper.process.ReportChartHelper;
import kd.fi.fgptas.business.report.helper.process.ReportGenerateProcess;
import kd.fi.fgptas.business.report.helper.process.ReportProcessRedis;
import kd.fi.fgptas.common.constant.ReportConstants;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportDesignPlugin
extends AbstractFormPlugin {
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    protected static final String CTL_TOOLBARAP = "toolbarap";
    protected static final String BTN_SAVE = "btn_save";
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String BTN_EXIT = "btn_exit";
    protected static final String BTN_REPORTSHOW = "btn_reportshow";
    private static final String PARAM_WORD_ID = "pkId";
    protected static final String KEY_OPERATION = "KEY_OPERATION";
    protected static final String KEY_DOCID = "KEY_DOCID";
    protected static final String KEY_STOP = "KEY_STOP";
    protected static final String KEY_WORDMODE = "KEY_WORDMODE";
    protected static final String CALLBACKID_WORD_REFRESH = "callbackid_word_refresh";
    protected static final String CALLBACKID_WORD_CLOSE = "callbackid_word_close";
    private static final Log logger = LogFactory.getLog(ReportDesignPlugin.class);
    protected static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ReportDesignPool", (int)Runtime.getRuntime().availableProcessors(), (int)(Runtime.getRuntime().availableProcessors() * 4), (String)"fgptas");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CTL_TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dataInit();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!e.isCancel()) {
            ReportMutexHelper.viewRelease((String)this.getWordId().toString(), (String)"fgptas_report_design");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "callbackid_word_refresh": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.dataInit();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"ReportDesignPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "callbackid_word_close": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                ReportProcessRedis.setStatus((String)this.getDocId(), (int)1);
                this.getView().close();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.saveOper();
                break;
            }
            case "btn_refresh": {
                this.refreshOper();
                break;
            }
            case "btn_exit": {
                this.existOper();
                break;
            }
            case "btn_reportshow": {
                this.reportShowOper();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("download".equals(e.getOperateKey())) {
            this.downloadOper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProgress(String newDocId, String oldDocId) {
        if (StringUtils.isEmpty((String)newDocId)) {
            return;
        }
        boolean isExcute = true;
        DynamicObject word = ReportHelper.getWord((Long)this.getWordId());
        if (!StringUtils.isEmpty((String)word.getString("url"))) {
            ReportProcessRedis.setStatus((String)newDocId, (int)-1);
            ReportProcessRedis.setErrorMsg((String)newDocId, (String)ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u6587\u6863\u4e0d\u80fd\u8fdb\u884c\u5206\u6790\u64cd\u4f5c\u3002", (String)"ReportDesignPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            isExcute = false;
        }
        try {
            String wordMode = ReportGptHelper.getWordMode((Long)this.getWordId());
            this.getPageCache().put(KEY_WORDMODE, wordMode);
            logger.info("aiword StartProgress wordMode=" + wordMode + ", docId=" + newDocId);
            if (isExcute && "GPT-IGPTAction".equals(wordMode)) {
                ReportGenerateProcess execute = new ReportGenerateProcess(this.getWordId(), newDocId);
                threadPool.execute((Runnable)execute);
            }
        }
        catch (Exception ex) {
            logger.error("aiword startProgress fail", (Throwable)ex);
        }
        finally {
            if (StringUtils.isNotEmpty((String)oldDocId)) {
                ReportProcessRedis.setStatus((String)oldDocId, (int)1);
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            ReportConstants.CallBackType callBackType = ReportConstants.CallBackType.valueOf((String)eventName);
            this.putCallBackType(callBackType, eventArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (eventName.equals(ReportConstants.CallBackType.EVENT_SAVE.toString())) {
            this.evSave(eventArgs);
        } else if (eventName.equals(ReportConstants.CallBackType.EVENT_DOCUMENT_CHANGED.toString())) {
            this.evDocumentChanged(eventArgs);
        } else if (eventName.equals(ReportConstants.CallBackType.EVENT_CONTENT.toString())) {
            this.evContent(eventArgs);
        } else if (eventName.equals(ReportConstants.CallBackType.EVENT_TABLE2CHART.toString())) {
            this.evTable2chart(eventArgs);
        }
    }

    protected void putCallBackType(ReportConstants.CallBackType callBackType, String value) {
        this.getPageCache().put("KEY_" + callBackType, value);
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    protected void evSave(String eventArgs) {
        if (ReportHelper.save((Long)this.getWordId(), (String)eventArgs)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportDesignPlugin_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    protected void evDocumentChanged(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        boolean isChanged = jsonObject.getBoolean("data");
        this.isDocChangedResult(isChanged);
    }

    protected void evContent(String eventArgs) {
        String docId;
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String primaryKey = "";
        if (jsonObject != null) {
            primaryKey = jsonObject.getString("primaryKey");
        }
        if (StringUtils.isEmpty((String)(docId = this.getDocId()))) {
            return;
        }
        int status = 0;
        String errorMsg = ReportProcessRedis.getErrorMsg((String)docId);
        JSONArray array = new JSONArray();
        String stop = this.getPageCache().get(KEY_STOP);
        int progressType = 0;
        if ("1".equals(stop)) {
            status = 1;
        } else {
            String wordMode;
            int processStatus = ReportProcessRedis.getStatus((String)docId);
            if (processStatus == -1) {
                String tips = ResManager.loadKDString((String)"\u6267\u884cGPT\u5206\u6790\u8fc7\u7a0b\u4e2d\u65ad:", (String)"ReportDesignPlugin_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tips + errorMsg);
                this.getPageCache().put(KEY_STOP, "1");
            } else if (processStatus == 1) {
                wordMode = this.getPageCache().get(KEY_WORDMODE);
                if ("GPT-IGPTAction".equals(wordMode)) {
                    array = ReportGenerateProcess.getData((String)this.getDocId());
                }
                this.getPageCache().put(KEY_STOP, "1");
            } else {
                wordMode = this.getPageCache().get(KEY_WORDMODE);
                if ("GPT-IGPTAction".equals(wordMode)) {
                    array = ReportGenerateProcess.getData((String)this.getDocId());
                }
                this.getPageCache().put(KEY_STOP, "0");
            }
            status = 0;
        }
        String wordMode = this.getPageCache().get(KEY_WORDMODE);
        if ("GPT-IGPTAction".equals(wordMode)) {
            progressType = 1;
        }
        JSONObject progress = new JSONObject();
        progress.put("percent", (Object)ReportProcessRedis.getProgress((String)docId));
        progress.put("type", (Object)progressType);
        progress.put("msg", (Object)ReportProcessRedis.getProgressMsg((String)docId));
        JSONObject data = new JSONObject();
        data.put("status", (Object)status);
        data.put("progress", (Object)progress);
        data.put("errorMsg", (Object)errorMsg);
        data.put("items", (Object)array);
        JSONObject result = ReportHelper.getPropsDataResult((Object)ReportConstants.PropsDataType.DATA_CONTENT_RESULT, (Object)data, (String)primaryKey);
        this.SendToVue(result);
    }

    protected void evTable2chart(String eventArgs) {
        JSONObject result = ReportChartHelper.table2chart((String)this.getDocId(), (String)eventArgs);
        if (result != null) {
            this.SendToVue(result);
        }
    }

    protected void isDocChanged(String operation) {
        this.getPageCache().put(KEY_OPERATION, operation);
        JSONObject data = new JSONObject(2);
        data.fluentPut("id", (Object)this.getWordId().toString());
        JSONObject result = ReportHelper.getPropsDataResult((Object)ReportConstants.PropsDataType.DATA_DOCUMENT_CHANGED, (Object)data, (String)"");
        this.SendToVue(result);
    }

    protected void isDocChangedResult(boolean isChanged) {
        String opertion = this.getPageCache().get(KEY_OPERATION);
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u672c\u64cd\u4f5c\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"ReportDesignPlugin_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
        if (BTN_REFRESH.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_WORD_REFRESH, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_WORD_REFRESH, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        } else if (BTN_EXIT.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_WORD_CLOSE, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_WORD_CLOSE, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        }
    }

    protected void dataInit() {
        JSONObject result = new JSONObject();
        String oldId = this.getDocId();
        try {
            result = ReportHelper.dataInit((Long)this.getWordId());
            this.SendToVue(result);
        }
        catch (Exception ex) {
            this.SendToVue(ReportHelper.dataError((Throwable)ex));
            logger.error(ex.getMessage());
        }
        this.setDocId(result);
        this.startProgress(this.getDocId(), oldId);
    }

    private void setDocId(JSONObject result) {
        try {
            String docId = result.getJSONObject("pageConfig").getString("docId");
            this.getPageCache().put(KEY_DOCID, docId);
        }
        catch (Exception ex) {
            logger.error("reportDesignPlugin setDocId fail", (Throwable)ex);
        }
    }

    private String getDocId() {
        return this.getPageCache().get(KEY_DOCID);
    }

    private void saveOper() {
        DynamicObject word = ReportHelper.getWord((Long)this.getWordId());
        if (StringUtils.isEmpty((String)word.getString("name"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportDesignPlugin_5", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.SendToVue(ReportHelper.getPropsDataResult((Object)ReportConstants.PropsDataType.DATA_SAVE));
    }

    private void refreshOper() {
        this.isDocChanged(BTN_REFRESH);
    }

    protected void downloadOper() {
        DynamicObject word = ReportHelper.getWord((Long)this.getWordId());
        if (word != null && StringUtils.isNotEmpty((String)word.getString("url"))) {
            String docUrl = UrlService.getAttachmentFullUrl((String)word.getString("url"));
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)docUrl);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u6863\u4e3a\u7a7a\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"ReportDesignPlugin_6", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    private void reportShowOper() {
        Long wordId = this.getWordId();
        DynamicObject word = ReportHelper.getWord((Long)wordId);
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String formId = "fatvs_aiword_reportshow";
        String pageId = wordId + formId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            String tips = ResManager.loadKDString((String)"\u53ef\u89c6\u5316", (String)"ReportDesignPlugin_7", (String)"fi-fgptas-formplugin", (Object[])new Object[0]);
            HashMap<String, Long> customParams = new HashMap<String, Long>(8);
            customParams.put("wordId", wordId);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(word.getString("name") + "-" + tips);
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void existOper() {
        this.isDocChanged(BTN_EXIT);
    }

    protected Long getWordId() {
        Long wordId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(PARAM_WORD_ID));
        return wordId;
    }
}

