/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class ReportOutlineFormPlugin
extends AbstractFormPlugin {
    private static final String BUTTON_KEY_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboItems();
        this.intiData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_KEY_OK.equals(key)) {
            this.getView().returnDataToParent((Object)this.getReturnData());
            this.getView().close();
        }
    }

    private void setComboItems() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String comboItemsStr = (String)param.getCustomParam("comboItems");
        if (StringUtils.isEmpty((String)comboItemsStr)) {
            return;
        }
        Map comboMap = (Map)SerializationUtils.fromJsonString((String)comboItemsStr, Map.class);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboMap.size());
        for (Map.Entry item : comboMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString((String)item.getValue()));
            comboItem.setValue((String)item.getKey());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("parent");
        comboEdit.setComboItems(comboItems);
    }

    private void intiData() {
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        String actionId = param.getCloseCallBack().getActionId();
        if ("callback_add_outline".equals(actionId)) {
            String defaultParentId;
            model.setValue("isleaf", (Object)true);
            String comboItemsStr = (String)param.getCustomParam("comboItems");
            if (StringUtils.isEmpty((String)comboItemsStr)) {
                return;
            }
            Map comboMap = (Map)SerializationUtils.fromJsonString((String)comboItemsStr, Map.class);
            if (comboMap.containsKey(defaultParentId = (String)param.getCustomParam("defaultParentId"))) {
                model.setValue("parent", param.getCustomParam("defaultParentId"));
            }
        } else {
            String editDataJs = (String)param.getCustomParam("editData");
            if (editDataJs != null) {
                EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)"fgptas_fireport_template").getAllEntities().get("outlineentry");
                DynamicObject editData = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)editDataJs, (IDataEntityType)entityType);
                model.setValue("outlineno", (Object)editData.getString("outlinenumber"));
                model.setValue("outlinename", (Object)editData.getString("outlinename"));
                model.setValue("isleaf", (Object)editData.getBoolean("isleaf"));
                long pid = editData.getLong("pid");
                if (pid > 0L) {
                    model.setValue("parent", (Object)String.valueOf(pid));
                }
            }
        }
    }

    private DynamicObject getReturnData() {
        IDataModel model = this.getModel();
        EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)"fgptas_fireport_template").getAllEntities().get("outlineentry");
        DynamicObject newOutLine = new DynamicObject((DynamicObjectType)entityType);
        newOutLine.set("outlinenumber", model.getValue("outlineno"));
        newOutLine.set("outlinename", model.getValue("outlinename"));
        String parent = (String)model.getValue("parent");
        if (StringUtils.isNotEmpty((String)parent)) {
            newOutLine.set("pid", (Object)Long.valueOf(parent));
        }
        return newOutLine;
    }
}

