/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;
import kd.fi.fgptas.common.report.field.AbstractReportPeriodFieldService;
import kd.fi.fgptas.common.report.field.ReportPeriodFieldServiceFactory;

public class ReportPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
ClickListener {
    private static final Log log = LogFactory.getLog(ReportPlugin.class);
    private static final String CLOSE_CALLBACK_KEY = "ReportCloseCallBack";
    private static final String DATA_CLOSE_CALLBACK_KEY = "DateReportPeriodFieldPropChoose";
    private static final String CLOSE_REPORT_JOB_KEY = "ReportJobClose";
    private static final String PRICACYtIPFSP = "pricacytipfsp";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit desOfficeF7 = (BasedataEdit)this.getControl("model");
        desOfficeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        desOfficeF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit entityF7 = (BasedataEdit)this.getControl("entity");
        entityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"report_period"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put(PRICACYtIPFSP, "1");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            Long wordId = (Long)e.getOperationResult().getSuccessPkIds().get(0);
            this.generateReport(wordId);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "ReportCloseCallBack": {
                Map retData = (Map)e.getReturnData();
                if (ObjectUtils.isEmpty((Object)retData) || StringUtils.isEmpty((String)((String)retData.get("period_json")).replace("{", "").replace("}", ""))) {
                    return;
                }
                this.getView().getPageCache().put("period_json", (String)retData.get("period_json"));
                this.getModel().setValue("report_period", (Object)ResManager.loadKDString((String)"\u5df2\u9009\u62e9", (String)"ReportPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "DateReportPeriodFieldPropChoose": {
                String period;
                AbstractReportPeriodFieldService service = ReportPeriodFieldServiceFactory.getServiceByCBKey((String)e.getActionId());
                if (service == null || !StringUtils.isNotEmpty((String)(period = (String)e.getReturnData()))) break;
                this.getModel().setValue("report_period", (Object)period);
                break;
            }
        }
    }

    private void generateReport(Long wordId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName(ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u544a\u3002", (String)"ReportPlugin_5", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname("kd.fi.fgptas.business.report.task.ManualGenReportTask");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("wordId", wordId);
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName("kd.fi.fgptas.business.report.task.ManualGenReportTaskClick");
        jobFormInfo.setCloseCallBack(new CloseCallBack("kd.fi.fgptas.formplugin.report.ReportListPlugin", CLOSE_REPORT_JOB_KEY));
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView().getParentView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (!this.validateName()) {
                args.setCancel(true);
                return;
            }
            DynamicObject model = this.getModel().getDataEntity().getDynamicObject("model");
            this.getModel().setValue("type", (Object)model.getDynamicObject("reporttype"));
            String periodJson = this.getView().getPageCache().get("period_json");
            this.getModel().setValue("period_json_tag", (Object)periodJson);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (StringUtils.isNotEmpty((String)this.getModel().getValue("period_json_tag").toString())) {
            this.getView().getPageCache().put("period_json", this.getModel().getValue("period_json_tag").toString());
            this.getModel().setValue("report_period", (Object)ResManager.loadKDString((String)"\u5df2\u9009\u62e9", (String)"ReportPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "report_period": {
                if (null == this.getModel().getValue("model")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u544a\u6a21\u677f", (String)"ReportPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                }
                String modelName = ((DynamicObject)this.getModel().getValue("model")).getString("name");
                List periodRequire = new ArrayList();
                try {
                    periodRequire = ReportTemDataHelper.getReportRequire((long)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d%2$s", (String)"ReportPlugin_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), modelName, e.getMessage()));
                    return;
                }
                log.info("periodRequire:" + periodRequire);
                if (null == periodRequire) {
                    AbstractReportPeriodFieldService service = ReportPeriodFieldServiceFactory.getService((String)"Date");
                    service.showFieldPropChooseView(this.getView(), this.getModel(), this.getPluginName());
                    break;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fgptas_report_period");
                CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), CLOSE_CALLBACK_KEY);
                showParameter.setCustomParam("periodRequire", periodRequire);
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private boolean validateName() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (null == model) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportPlugin_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            return false;
        }
        OrmLocaleValue nameLocalValue = (OrmLocaleValue)this.getModel().getValue("name");
        String name = nameLocalValue.getLocaleValue();
        if (StringUtils.isNotEmpty((String)name)) {
            String showMsg = String.format(ResManager.loadKDString((String)"%s: \u201c\u540d\u79f0\u201d \u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ReportPlugin_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), name);
            if (name.contains("fi-fgptas-formplugin") || name.startsWith(".") || name.startsWith("-")) {
                this.getView().showTipNotification(showMsg);
                return false;
            }
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult reportItemViewPerm = PermissionServiceHelper.getAllPermOrgs((long)userId, null, (String)"fgptas", (String)"fgptas_report_list", (String)"47150e89000000ac");
        switch (key) {
            case "model": {
                ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
                List qFilters = showParam.getListFilterParameter().getQFilters();
                DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
                Long orgId = (Long)entity.get("id");
                List reportItemOrgIds = reportItemViewPerm.getHasPermOrgs();
                if (reportItemViewPerm.hasAllOrgPerm() || reportItemOrgIds.size() > 0 && reportItemOrgIds.contains(orgId)) {
                    DynamicObject[] dynamicObjects;
                    List<Object> types = new ArrayList();
                    PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    QFilter fatvs = permissionService.getDataRuleForBdProp(userId, "fgptas", "fgptas_report_list", "reporttype", orgIds);
                    if (null != fatvs && (dynamicObjects = BusinessDataServiceHelper.load((String)"fgptas_report_type", (String)"number", (QFilter[])fatvs.toArray())).length > 0) {
                        types = Arrays.stream(dynamicObjects).map(a -> Long.valueOf(a.get("id").toString())).collect(Collectors.toList());
                    }
                    qFilters.add(new QFilter("reporttype", "in", types));
                    IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
                    qFilters.add(baseDataService.getBaseDataFilter("fgptas_fireport_template", orgId));
                    break;
                }
                qFilters.add(new QFilter("reporttype", "=", null));
                break;
            }
            case "entity": {
                if (reportItemViewPerm.hasAllOrgPerm()) break;
                List qFilterList = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilterList.add(new QFilter("id", "in", (Object)reportItemViewPerm.getHasPermOrgs()));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        if ("model".equals(key)) {
            DynamicObject model = this.getModel().getDataEntity().getDynamicObject("model");
            if (null != model) {
                String reporttitle = model.getString("reporttitle");
                this.getModel().setValue("name", (Object)reporttitle);
            } else {
                this.getModel().setValue("name", null);
                this.getModel().setValue("report_period", (Object)"");
            }
        }
    }
}

