/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.enums.GlobalFieldEnum;
import kd.fi.fgptas.business.report.helper.ReportGPTActionDataHelper;
import kd.fi.fgptas.business.report.helper.ReportTemDataHelper;

public class ReportTemplateFormPlugin
extends AbstractFormPlugin
implements IBillPlugin,
TreeNodeClickListener,
TreeNodeDragListener,
BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final Log LOG = LogFactory.getLog(ReportTemplateFormPlugin.class);
    private static final String LOG_PREFIX = "--ReportTemplateFormPlugin--";
    private static final String C_KEY_TREE = "outlinetreeview";
    private static final String C_KEY_TAB = "tabap";
    private static final String C_KEY_TITLE_LABEL = "contenttitle";
    private static final String C_KEY_DATA_PROP = "dataprop";
    private static final String C_KEY_DATA_FILTER = "datafilter";
    private static final String ICON_ADD = "addicon";
    private static final String ICON_COPY = "copyicon";
    private static final String ICON_EDIT = "editicon";
    private static final String ICON_DELETE = "deleteicon";
    private static final String KEY_HELP_ICON = "vectorap";
    private static final String KEY_HELP_LABEL = "explainlap";
    private static final String FORM_VIEW_DETAIL = "fgptas_helpdetail";
    private static final String NODE_KEY_ROOT = "root_id";
    private static final String NODE_KEY_COVER = "cover_id";
    private static final String CALLBACK_KEY_ADD_OUTLINE = "callback_add_outline";
    private static final String CALLBACK_KEY_EDIT_OUTLINE = "callback_edit_outline";
    private static final String CALLBACK_KEY_PROP = "callback_edit_prop";
    private static final String CALLBACK_KEY_FILTER = "callback_edit_filter";
    private static final String CALL_BACK_DELETE = "callback_delete_confirm";
    private static final String CACHE_KEY_TREE_NODE = "treeNode";
    private static final String PRICACYtIPFSP = "pricacytipfsp";
    public static final Set<String> notEntityFields = new HashSet<String>(4);

    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getView().getControl(C_KEY_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeDragListener((TreeNodeDragListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ICON_ADD, ICON_COPY, ICON_EDIT, ICON_DELETE, C_KEY_DATA_PROP, C_KEY_DATA_FILTER, KEY_HELP_ICON, KEY_HELP_LABEL});
        BasedataEdit dataRe = (BasedataEdit)this.getControl("datarequire");
        dataRe.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("datatable");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reportType = (BasedataEdit)this.getControl("reporttype");
        reportType.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(true);
        this.getView().getPageCache().put(PRICACYtIPFSP, "1");
    }

    public void afterLoadData(EventObject e) {
        this.initData(false);
    }

    public void afterCopyData(EventObject e) {
        this.initData(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{ICON_COPY, ICON_EDIT, ICON_DELETE});
        this.initTree();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("outlineentry".equals(e.getEntryProp().getName())) {
            this.setShowPromptContent(e.getRowIndexs()[0] - 1);
            this.getView().updateView("contentprompt_eye");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Set entityNumbers;
        String name = evt.getProperty().getName();
        ListShowParameter f7Param = (ListShowParameter)evt.getFormShowParameter();
        if ("datarequire".equals(name)) {
            QFilter presetFilter = new QFilter("preset", "=", (Object)"1");
            f7Param.getListFilterParameter().getQFilters().add(presetFilter);
        } else if ("datatable".equals(name) && (entityNumbers = ReportGPTActionDataHelper.getAllDataTableEntity()).size() > 0) {
            QFilter numberFilter = new QFilter("number", "in", (Object)entityNumbers);
            f7Param.getListFilterParameter().getQFilters().add(numberFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        BasedataEdit baseData = (BasedataEdit)event.getSource();
        String key = baseData.getKey();
        FormShowParameter showParameter = event.getShowParameter();
        if ("reporttype".equals(key)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Tab tabAp = (Tab)view.getControl(C_KEY_TAB);
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        boolean enableOp = !NODE_KEY_ROOT.equals(nodeId) && !NODE_KEY_COVER.equals(nodeId);
        view.setEnable(Boolean.valueOf(enableOp), new String[]{ICON_COPY, ICON_EDIT, ICON_DELETE});
        if (!NODE_KEY_ROOT.equals(nodeId)) {
            TreeView tree = (TreeView)view.getControl(C_KEY_TREE);
            Map focusNode = tree.getTreeState().getFocusNode();
            ((Label)this.getControl(C_KEY_TITLE_LABEL)).setText((String)focusNode.get("text"));
            if (NODE_KEY_COVER.equals(nodeId)) {
                tabAp.activeTab("covertab");
                this.getView().setVisible(Boolean.FALSE, new String[]{"helppanel"});
            } else {
                tabAp.activeTab("contenttab");
                int curEntryIndex = model.getEntryCurrentRowIndex("outlineentry");
                int clickNodeIndex = this.getIndexByPkValue(Long.parseLong(nodeId));
                if (curEntryIndex != clickNodeIndex) {
                    AbstractGrid grid = (AbstractGrid)view.getControl("outlineentry");
                    grid.selectRows(clickNodeIndex);
                    this.setShowPromptContent(clickNodeIndex);
                    this.getView().updateView("contentprompt_eye");
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"helppanel"});
            }
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String fromParentId = (String)evt.getFromParentId();
        String toParentId = (String)evt.getToParentId();
        this.moveEntryRowAndTreeNode(fromParentId, nodeId, toParentId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int parentRowIndex = changeData.getParentRowIndex();
        int rowIndex = changeData.getRowIndex();
        if ("backgprompt_eye".equals(propName) || "contentprompt_eye".equals(propName) || "contentprompt_eye_tag".equals(propName)) {
            int curEntryIndex = model.getEntryCurrentRowIndex("outlineentry");
            if (curEntryIndex < 0) {
                return;
            }
            if ("backgprompt_eye".equals(propName)) {
                Object oldEntryValue = model.getValue("backgroundprompt", curEntryIndex);
                if (!oldEntryValue.equals(newValue)) {
                    model.setValue("backgroundprompt", newValue, curEntryIndex);
                }
            } else if ("contentprompt_eye".equals(propName)) {
                Object oldEntryValue = model.getValue("contentprompt", curEntryIndex);
                if (!oldEntryValue.equals(newValue)) {
                    model.setValue("contentprompt", newValue, curEntryIndex);
                }
            } else {
                Object oldEntryValue = model.getValue("contentprompt_tag", curEntryIndex);
                if (!oldEntryValue.equals(newValue)) {
                    model.setValue("contentprompt_tag", newValue, curEntryIndex);
                }
            }
        } else if (C_KEY_DATA_PROP.equals(propName)) {
            if (StringUtils.isEmpty((String)((String)newValue))) {
                model.setValue("datapropnumber", (Object)"", rowIndex, parentRowIndex);
            }
        } else if ("datarequire".equals(propName) || "reporttitle".equals(propName)) {
            this.setCoverContent();
        } else if ("datatable".equals(propName)) {
            model.setValue(C_KEY_DATA_PROP, (Object)"", rowIndex, parentRowIndex);
            model.setValue(C_KEY_DATA_FILTER, (Object)"", rowIndex, parentRowIndex);
        } else if (C_KEY_DATA_FILTER.equals(propName) && StringUtils.isEmpty((String)((String)newValue))) {
            model.setValue("datafiltervalue", (Object)"", rowIndex, parentRowIndex);
            model.setValue("datafiltervalue_tag", (Object)"", rowIndex, parentRowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (ICON_ADD.equals(key)) {
            this.openOutlineForm(true);
        } else if (ICON_EDIT.equals(key)) {
            this.openOutlineForm(false);
        } else if (ICON_COPY.equals(key)) {
            this.copyEntryRow();
        } else if (ICON_DELETE.equals(key)) {
            this.deleteEntryRow();
        } else if (C_KEY_DATA_PROP.equals(key)) {
            this.openPropTreeForm();
        } else if (C_KEY_DATA_FILTER.equals(key)) {
            this.openFilterForm();
        }
        if (KEY_HELP_ICON.equals(key) || KEY_HELP_LABEL.equals(key)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(FORM_VIEW_DETAIL);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (CALLBACK_KEY_ADD_OUTLINE.equals(actionId)) {
            DynamicObject newEntryData = (DynamicObject)returnData;
            long parentId = newEntryData.getLong("pid");
            if (parentId == 0L) {
                this.addTopEntryRow(newEntryData);
            } else {
                int parentIndex = this.getIndexByPkValue(parentId);
                if (parentIndex != -1) {
                    this.addChildEntryRow(parentIndex, newEntryData);
                } else {
                    LOG.info(LOG_PREFIX + String.format("the chosen parent outline not exist.chosen id:%s", parentId));
                }
            }
        } else if (CALLBACK_KEY_EDIT_OUTLINE.equals(actionId)) {
            DynamicObject newEntryData = (DynamicObject)returnData;
            this.updateEntryRow(newEntryData);
        } else if (CALLBACK_KEY_PROP.equals(actionId)) {
            Map map = (Map)returnData;
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            int parentIndex = model.getEntryCurrentRowIndex("outlineentry");
            int childIndex = model.getEntryCurrentRowIndex("datasourcesubentry");
            model.setValue(C_KEY_DATA_PROP, (Object)name, childIndex, parentIndex);
            model.setValue("datapropnumber", (Object)number, childIndex, parentIndex);
        } else if (CALLBACK_KEY_FILTER.equals(actionId)) {
            Map map = (Map)returnData;
            String conditionText = (String)map.get("desc");
            String conditionJson = (String)map.get("conditionJson");
            int parentIndex = model.getEntryCurrentRowIndex("outlineentry");
            int childIndex = model.getEntryCurrentRowIndex("datasourcesubentry");
            if (conditionText.length() > 255) {
                conditionText = conditionText.substring(0, 252) + "...";
            }
            model.setValue(C_KEY_DATA_FILTER, (Object)conditionText, childIndex, parentIndex);
            model.setValue("datafiltervalue_tag", (Object)conditionJson, childIndex, parentIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_DELETE.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            IFormView view = this.getView();
            TreeView tree = (TreeView)view.getControl(C_KEY_TREE);
            Map focusNode = tree.getTreeState().getFocusNode();
            if (focusNode == null) {
                return;
            }
            String nodeId = (String)focusNode.get("id");
            int index = this.getIndexByPkValue(Long.parseLong(nodeId));
            try {
                this.getModel().deleteEntryRow("outlineentry", index);
            }
            catch (Exception ex) {
                view.showTipNotification(ex.getMessage());
                return;
            }
            this.deleteTreeNode(nodeId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        if (dataChanged) {
            DynamicObject dataEntity = model.getDataEntity();
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            for (String field : notEntityFields) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
                Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), false));
            }
        }
    }

    private void initData(boolean isNew) {
        IDataModel model = this.getModel();
        if (isNew) {
            Object[] defIds = new Object[]{GlobalFieldEnum.ORG.getId(), GlobalFieldEnum.REPORT_PERIOD.getId()};
            model.setValue("datarequire", (Object)defIds);
            this.setCoverContent();
        } else {
            int outLineCount = model.getEntryRowCount("outlineentry");
            if (outLineCount > 0) {
                this.setShowPromptContent(0);
            }
        }
    }

    private void initTree() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        TreeNode root = new TreeNode("", NODE_KEY_ROOT, ResManager.loadKDString((String)"\u5927\u7eb2", (String)"ReportTemplateFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        TreeNode coverNode = new TreeNode(root.getId(), NODE_KEY_COVER, ResManager.loadKDString((String)"\u62a5\u544a\u5c01\u9762", (String)"ReportTemplateFormPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        root.addChild(coverNode);
        DynamicObjectCollection outLineEntry = model.getEntryEntity("outlineentry");
        List<TreeNode> dataNodes = this.buildOutlineTree(outLineEntry);
        root.addChildren(dataNodes);
        this.cacheRootTreeNode(root);
        TreeView tree = (TreeView)view.getControl(C_KEY_TREE);
        root.setIsOpened(true);
        tree.addNode(root);
        tree.focusNode(root.getTreeNode(NODE_KEY_COVER));
        this.getView().setVisible(Boolean.FALSE, new String[]{"helppanel"});
    }

    private List<TreeNode> buildOutlineTree(DynamicObjectCollection outLineEntry) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject ele : outLineEntry) {
            String nodeId = String.valueOf(ele.getPkValue());
            long pid = ele.getLong("pid");
            String parentNodeId = pid == 0L ? NODE_KEY_ROOT : String.valueOf(pid);
            String text = ele.getString("outlinenumber") + " " + ele.getString("outlinename");
            TreeNode node = new TreeNode(parentNodeId, nodeId, text);
            if (NODE_KEY_ROOT.equals(parentNodeId)) {
                nodeList.add(node);
                continue;
            }
            ((TreeNode)nodeList.get(nodeList.size() - 1)).getTreeNode(parentNodeId).addChild(node);
        }
        return nodeList;
    }

    private void openOutlineForm(boolean addNew) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        TreeView tree = (TreeView)view.getControl(C_KEY_TREE);
        String currentNodeId = tree.getTreeState().getFocusNodeId();
        DynamicObjectCollection outline = model.getEntryEntity("outlineentry");
        Map<Object, String> canAddChild = outline != null && outline.size() > 0 ? (addNew ? outline.stream().filter(o -> "1".equals(o.getString("outlinelevel"))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o.getString("outlinename"))) : outline.stream().filter(o -> "1".equals(o.getString("outlinelevel")) && !currentNodeId.equals(String.valueOf(o.getPkValue()))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o.getString("outlinename")))) : null;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fgptas_reporttemp_outline");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (canAddChild != null) {
            showParameter.setCustomParam("comboItems", (Object)SerializationUtils.toJsonString(canAddChild));
        }
        if (addNew) {
            if (StringUtils.isNotEmpty((String)currentNodeId) && !NODE_KEY_COVER.equals(currentNodeId) && !NODE_KEY_ROOT.equals(currentNodeId)) {
                showParameter.setCustomParam("defaultParentId", (Object)currentNodeId);
            }
        } else {
            int outlineCurIndex = model.getEntryCurrentRowIndex("outlineentry");
            DynamicObject curOutline = model.getEntryRowEntity("outlineentry", outlineCurIndex);
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(false);
            option.setIncludeCollectionProperty(false);
            String editData = DataEntitySerializer.serializerToString((Object)curOutline, (DataEntitySerializerOption)option);
            showParameter.setCustomParam("editData", (Object)editData);
        }
        if (addNew) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_ADD_OUTLINE));
        } else {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_EDIT_OUTLINE));
        }
        this.getView().showForm(showParameter);
    }

    private void openPropTreeForm() {
        int currentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = (DynamicObject)model.getValue("datatable", currentRowIndex = model.getEntryCurrentRowIndex("datasourcesubentry"));
        if (dataEntity == null) {
            return;
        }
        String entityNumber = dataEntity.getString("number");
        HashMap<Long, String> dataGlobalRequire = this.checkGlobalFieldMapping(entityNumber);
        if (dataGlobalRequire == null) {
            return;
        }
        String selectedProps = (String)model.getValue("datapropnumber", currentRowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fgptas_entityproptree");
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("isMulti", (Object)Boolean.TRUE);
        showParameter.setCustomParam("elements", (Object)"dataTableFields");
        showParameter.setCustomParam("selectedProps", (Object)selectedProps);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_PROP));
        this.getView().showForm(showParameter);
    }

    private void openFilterForm() {
        int currentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = (DynamicObject)model.getValue("datatable", currentRowIndex = model.getEntryCurrentRowIndex("datasourcesubentry"));
        if (dataEntity == null) {
            return;
        }
        String entityNumber = dataEntity.getString("number");
        HashMap<Long, String> dataGlobalRequire = this.checkGlobalFieldMapping(entityNumber);
        if (dataGlobalRequire == null) {
            return;
        }
        String conditionJson = (String)model.getValue("datafiltervalue_tag", currentRowIndex);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("fgptas_report_condition");
        formShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formShowParameter.setCustomParam("conditionJson", (Object)conditionJson);
        formShowParameter.setCustomParam("excludeColumns", (Object)String.join((CharSequence)",", dataGlobalRequire.values()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_FILTER);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void moveEntryRowAndTreeNode(String parentNodeId, String nodeId, String toNodeId) {
        IDataModel model = this.getModel();
        if (NODE_KEY_ROOT.equals(nodeId) || NODE_KEY_COVER.equals(nodeId)) {
            return;
        }
        if (NODE_KEY_ROOT.equals(toNodeId)) {
            return;
        }
        String toParentNodeId = this.getTreeNode(toNodeId).getParentid();
        if (parentNodeId.equals(toParentNodeId)) {
            int index = this.getIndexByPkValue(Long.parseLong(nodeId));
            DynamicObject row = model.getEntryRowEntity("outlineentry", index);
            int level = row.getInt("outlinelevel");
            boolean isLeaf = row.getBoolean("isleaf");
            int toIndex = NODE_KEY_COVER.equals(toNodeId) ? -1 : this.getIndexByPkValue(Long.parseLong(toNodeId));
            if (isLeaf) {
                this.moveEntryRow(index, toIndex);
            } else if (index > toIndex) {
                DynamicObject[] rows = model.getEntryEntity("outlineentry", toIndex + 1, index);
                long moveCount = Arrays.stream(rows).filter(r -> level == r.getInt("outlinelevel")).count();
                int i = 0;
                while ((long)i < moveCount) {
                    index -= model.moveEntryRowUp("outlineentry", index);
                    ++i;
                }
            } else if (index < toIndex) {
                DynamicObject[] rows = model.getEntryEntity("outlineentry", index, toIndex);
                long moveCount = Arrays.stream(rows).filter(r -> level == r.getInt("outlinelevel")).count();
                int i = 0;
                while ((long)i < moveCount) {
                    index += model.moveEntryRowDown("outlineentry", index);
                    ++i;
                }
            }
            this.moveTreeNode(parentNodeId, nodeId, toNodeId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u7ea7\u4e0a\u4e0b\u79fb\u52a8\uff0c\u8bf7\u901a\u8fc7\u7f16\u8f91\u201c\u7236\u7ea7\u5927\u7eb2\u201d\u7684\u65b9\u5f0f\u8fdb\u884c\u8de8\u7ea7\u64cd\u4f5c\u3002", (String)"ReportTemplateFormPlugin_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    private void addTopEntryRow(DynamicObject defaultData) {
        IDataModel model = this.getModel();
        String nodeText = defaultData.getString("outlinenumber") + " " + defaultData.getString("outlinename");
        int newEntryRow = model.createNewEntryRow("outlineentry", defaultData);
        model.setValue("outlinelevel", (Object)1, newEntryRow);
        model.setValue("isleaf", (Object)Boolean.TRUE, newEntryRow);
        model.setValue("isGroupNode", (Object)Boolean.FALSE, newEntryRow);
        Object pkValue = model.getEntryRowEntity("outlineentry", newEntryRow).getPkValue();
        this.addTreeNode(NODE_KEY_ROOT, String.valueOf(pkValue), nodeText);
    }

    private void addChildEntryRow(int parentIndex, DynamicObject defaultData) {
        IDataModel model = this.getModel();
        int insertEntryRow = model.insertEntryRow("outlineentry", parentIndex);
        DynamicObject parent = model.getEntryRowEntity("outlineentry", parentIndex);
        String outlineNo = defaultData.getString("outlinenumber");
        String outlineName = defaultData.getString("outlinename");
        model.setValue("outlinenumber", (Object)outlineNo, insertEntryRow);
        model.setValue("outlinename", (Object)outlineName, insertEntryRow);
        int parentLevel = parent.getInt("outlinelevel");
        model.setValue("outlinelevel", (Object)(parentLevel + 1), insertEntryRow);
        model.setValue("isleaf", (Object)Boolean.TRUE, insertEntryRow);
        boolean isLeaf = parent.getBoolean("isleaf");
        if (isLeaf) {
            model.setValue("isleaf", (Object)Boolean.FALSE, parentIndex);
        }
        Object pkValue = model.getEntryRowEntity("outlineentry", insertEntryRow).getPkValue();
        String nodeText = outlineNo + " " + outlineName;
        this.addTreeNode(defaultData.getString("pid"), String.valueOf(pkValue), nodeText);
    }

    private void updateEntryRow(DynamicObject updateRow) {
        IDataModel model = this.getModel();
        String newNumber = updateRow.getString("outlinenumber");
        String newName = updateRow.getString("outlinename");
        long parentId = updateRow.getLong("pid");
        int curIndex = model.getEntryCurrentRowIndex("outlineentry");
        long curId = (Long)model.getEntryRowEntity("outlineentry", curIndex).getPkValue();
        long curPid = model.getEntryRowEntity("outlineentry", curIndex).getLong("pid");
        model.setValue("outlinenumber", (Object)newNumber, curIndex);
        model.setValue("outlinename", (Object)newName, curIndex);
        if (parentId != curPid) {
            int oldParentIndex;
            int aimIndex;
            boolean needSetGroup = false;
            if (parentId == 0L) {
                aimIndex = model.getEntryRowCount("outlineentry") - 1;
                model.setValue("outlinelevel", (Object)1, curIndex);
            } else {
                int parentIndex = this.getIndexByPkValue(parentId);
                int parentLevel = model.getEntryRowEntity("outlineentry", parentIndex).getInt("outlinelevel");
                model.setValue("outlinelevel", (Object)(parentLevel + 1), curIndex);
                if (this.isParentRow(parentIndex)) {
                    aimIndex = this.getLastChildIndex(parentIndex);
                } else {
                    needSetGroup = true;
                    aimIndex = parentIndex;
                }
            }
            model.setValue("pid", (Object)parentId, curIndex);
            this.moveEntryRow(curIndex, aimIndex);
            if (needSetGroup) {
                int movedParentIndex = this.getIndexByPkValue(parentId);
                model.setValue("isGroupNode", (Object)Boolean.TRUE, movedParentIndex);
                model.setValue("isleaf", (Object)Boolean.FALSE, movedParentIndex);
            }
            if (curPid > 0L && !this.isParentRow(oldParentIndex = this.getIndexByPkValue(curPid))) {
                model.setValue("isGroupNode", (Object)Boolean.FALSE, oldParentIndex);
                model.setValue("isleaf", (Object)Boolean.TRUE, oldParentIndex);
            }
        }
        String parentNodeId = parentId == 0L ? NODE_KEY_ROOT : String.valueOf(parentId);
        String newText = newNumber + " " + newName;
        this.updateTreeNode(String.valueOf(curId), parentNodeId, newText);
    }

    private void copyEntryRow() {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex("outlineentry");
        if (curIndex < 0) {
            return;
        }
        DynamicObject beCopied = model.getEntryRowEntity("outlineentry", curIndex);
        long pid = beCopied.getLong("pid");
        if (pid == 0L) {
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject cloneBeCopied = (DynamicObject)cloneUtils.clone((IDataEntityBase)beCopied);
            this.addTopEntryRow(cloneBeCopied);
        } else {
            int parentIndex = this.getIndexByPkValue(pid);
            int insertEntryRow = model.insertEntryRow("outlineentry", parentIndex);
            String outlineNo = beCopied.getString("outlinenumber");
            String outlineName = beCopied.getString("outlinename");
            model.setValue("isleaf", (Object)Boolean.TRUE, insertEntryRow);
            model.setValue("outlinenumber", (Object)outlineNo, insertEntryRow);
            model.setValue("outlinename", (Object)outlineName, insertEntryRow);
            model.setValue("outlinelevel", (Object)beCopied.getString("outlinelevel"), insertEntryRow);
            model.setValue("backgroundprompt", (Object)beCopied.getString("backgroundprompt"), insertEntryRow);
            model.setValue("contentprompt", (Object)beCopied.getString("contentprompt"), insertEntryRow);
            model.setValue("contentprompt_tag", (Object)beCopied.getString("contentprompt_tag"), insertEntryRow);
            Object pkValue = model.getEntryRowEntity("outlineentry", insertEntryRow).getPkValue();
            String nodeText = outlineNo + " " + outlineName;
            this.addTreeNode(String.valueOf(pid), String.valueOf(pkValue), nodeText);
        }
    }

    private void deleteEntryRow() {
        IFormView view = this.getView();
        TreeView tree = (TreeView)view.getControl(C_KEY_TREE);
        Map focusNode = tree.getTreeState().getFocusNode();
        if (focusNode == null) {
            return;
        }
        String nodeId = (String)focusNode.get("id");
        if (!NODE_KEY_ROOT.equals(nodeId) && !NODE_KEY_COVER.equals(nodeId)) {
            if (((Boolean)focusNode.get("isParent")).booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u5b50\u884c\uff0c\u518d\u5220\u9664\u7236\u884c\u3002", (String)"ReportTemplateFormPlugin_6", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
            } else {
                view.showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\uff0c\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"ReportTemplateFormPlugin_5", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_DELETE));
            }
        }
    }

    private void moveEntryRow(int curIndex, int aimIndex) {
        block3: {
            block2: {
                if (curIndex <= aimIndex) break block2;
                for (int i = curIndex; i > aimIndex + 1; --i) {
                    this.swapEntryRow(i, i - 1);
                }
                break block3;
            }
            if (curIndex >= aimIndex) break block3;
            for (int i = curIndex; i < aimIndex; ++i) {
                this.swapEntryRow(i, i + 1);
            }
        }
    }

    private void swapEntryRow(int rowIndex1, int rowIndex2) {
        DynamicObjectCollection col = this.getModel().getEntryEntity("outlineentry");
        int start = col.getStartRowIndex();
        DynamicObject row1 = (DynamicObject)col.get(rowIndex1 - start);
        DynamicObject row2 = (DynamicObject)col.get(rowIndex2 - start);
        col.set(rowIndex1 - start, (Object)row2);
        col.set(rowIndex2 - start, (Object)row1);
        row1.set("seq", (Object)(rowIndex2 + 1));
        row2.set("seq", (Object)(rowIndex1 + 1));
        this.getModel().updateEntryCache(col);
    }

    private int getLastChildIndex(int index) {
        long curPid;
        IDataModel model = this.getModel();
        Long thisId = (Long)model.getEntryRowEntity("outlineentry", index).getPkValue();
        HashSet<Long> parents = new HashSet<Long>();
        parents.add(thisId);
        int point = index;
        DynamicObject pointData = model.getEntryRowEntity("outlineentry", point + 1);
        while (pointData != null && parents.contains(curPid = pointData.getLong("pid"))) {
            parents.add((Long)pointData.get("id"));
            pointData = model.getEntryRowEntity("outlineentry", ++point + 1);
        }
        return point;
    }

    private boolean isParentRow(int index) {
        IDataModel model = this.getModel();
        long curId = (Long)model.getEntryRowEntity("outlineentry", index).getPkValue();
        DynamicObject nextRow = model.getEntryRowEntity("outlineentry", index + 1);
        if (nextRow == null) {
            return false;
        }
        long nextPId = nextRow.getLong("pid");
        return curId == nextPId;
    }

    private int getIndexByPkValue(long pkValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("outlineentry");
        for (DynamicObject row : entryEntity) {
            long rowPkValue = (Long)row.getPkValue();
            if (rowPkValue != pkValue) continue;
            return row.getInt("seq") - 1;
        }
        return -1;
    }

    private void addTreeNode(String parentId, String nodeId, String text) {
        TreeNode rootNode = this.getRootTreeNodeByCache();
        TreeNode newNode = new TreeNode(parentId, nodeId, text);
        if (NODE_KEY_ROOT.equals(parentId)) {
            rootNode.addChild(newNode);
        } else {
            TreeNode parentNode = rootNode.getTreeNode(parentId, 16);
            parentNode.addChild(newNode);
        }
        this.cacheRootTreeNode(rootNode);
        TreeView tree = (TreeView)this.getView().getControl(C_KEY_TREE);
        tree.addNode(newNode);
        tree.focusNode(newNode);
        tree.treeNodeClick(parentId, nodeId);
    }

    private void updateTreeNode(String nodeId, String newParentId, String newText) {
        TreeNode rootNode = this.getRootTreeNodeByCache();
        TreeNode updateNode = rootNode.getTreeNode(nodeId, 16);
        updateNode.setText(newText);
        String oldParentId = updateNode.getParentid();
        TreeNode updateParentNode = null;
        if (!oldParentId.equals(newParentId)) {
            updateNode.setParentid(newParentId);
            TreeNode oldParentNode = rootNode.getTreeNode(oldParentId, 16);
            oldParentNode.deleteChildNode(nodeId);
            if (oldParentNode.getChildren().isEmpty()) {
                oldParentNode.setChildren(null);
                updateParentNode = oldParentNode;
            }
            TreeNode newParentNode = rootNode.getTreeNode(newParentId, 16);
            newParentNode.addChild(updateNode);
        }
        this.cacheRootTreeNode(rootNode);
        TreeView tree = (TreeView)this.getView().getControl(C_KEY_TREE);
        tree.deleteNode(nodeId);
        tree.addNode(updateNode);
        if (updateParentNode != null) {
            tree.updateNode(updateParentNode);
        }
        tree.focusNode(updateNode);
        tree.treeNodeClick(newParentId, nodeId);
    }

    private void deleteTreeNode(String nodeId) {
        String focusNodeId;
        TreeNode parentNode;
        IDataModel model = this.getModel();
        TreeNode rootNode = this.getRootTreeNodeByCache();
        String parentId = rootNode.getTreeNode(nodeId).getParentid();
        rootNode.deleteChildNode(nodeId);
        TreeNode updateParentNode = null;
        if (!NODE_KEY_ROOT.equals(parentId) && (parentNode = rootNode.getTreeNode(parentId)).getChildren().isEmpty()) {
            parentNode.setChildren(null);
            updateParentNode = parentNode;
        }
        this.cacheRootTreeNode(rootNode);
        int curIndex = model.getEntryCurrentRowIndex("outlineentry");
        if (curIndex >= 0) {
            DynamicObject curOutline = model.getEntryRowEntity("outlineentry", curIndex);
            focusNodeId = String.valueOf(curOutline.getPkValue());
        } else {
            focusNodeId = NODE_KEY_COVER;
        }
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId);
        TreeView tree = (TreeView)this.getView().getControl(C_KEY_TREE);
        tree.deleteNode(nodeId);
        if (updateParentNode != null) {
            tree.updateNode(updateParentNode);
        }
        tree.focusNode(focusNode);
        tree.treeNodeClick(focusNode.getParentid(), focusNodeId);
    }

    private void moveTreeNode(String parentNodeId, String nodeId, String toNodeId) {
        int i;
        int toIndex;
        TreeNode rootNode = this.getRootTreeNodeByCache();
        TreeNode pNode = rootNode.getTreeNode(parentNodeId);
        TreeNode node = rootNode.getTreeNode(nodeId);
        TreeNode toNode = rootNode.getTreeNode(toNodeId);
        List children = pNode.getChildren();
        int index = children.indexOf(node);
        if (index > (toIndex = children.indexOf(toNode))) {
            if (index == toIndex + 1) {
                return;
            }
            for (i = index; i > toIndex + 1; --i) {
                TreeNode temp = (TreeNode)children.get(i);
                children.set(i, children.get(i - 1));
                children.set(i - 1, temp);
            }
        } else if (index < toIndex) {
            for (i = index; i < toIndex; ++i) {
                TreeNode temp = (TreeNode)children.get(i);
                children.set(i, children.get(i + 1));
                children.set(i + 1, temp);
            }
        } else {
            return;
        }
        this.cacheRootTreeNode(rootNode);
        TreeView tree = (TreeView)this.getView().getControl(C_KEY_TREE);
        tree.updateNode(pNode);
        tree.focusNode(node);
        tree.treeNodeClick(parentNodeId, nodeId);
    }

    private void cacheRootTreeNode(TreeNode treeNode) {
        this.getPageCache().put(CACHE_KEY_TREE_NODE, SerializationUtils.toJsonString((Object)treeNode));
    }

    private TreeNode getRootTreeNodeByCache() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_TREE_NODE), TreeNode.class);
    }

    private TreeNode getTreeNode(String nodeId) {
        return this.getRootTreeNodeByCache().getTreeNode(nodeId);
    }

    private HashMap<Long, String> getGlobalFields() {
        DynamicObjectCollection requireData = (DynamicObjectCollection)this.getModel().getValue("datarequire");
        HashMap<Long, String> globalFieldKeys = new HashMap<Long, String>(8);
        for (DynamicObject dynObj : requireData) {
            DynamicObject baseData = dynObj.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            globalFieldKeys.put(baseData.getLong("id"), baseData.getString("name"));
        }
        return globalFieldKeys;
    }

    private void setCoverContent() {
        IDataModel model = this.getModel();
        DynamicObjectCollection goalDataCol = (DynamicObjectCollection)model.getValue("datarequire");
        OrmLocaleValue nameLocaleValue = (OrmLocaleValue)this.getModel().getValue("reporttitle");
        String reportTitle = nameLocaleValue == null ? "" : nameLocaleValue.getLocaleValue();
        StringBuilder coverContent = new StringBuilder(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\uff1a%s", (String)"ReportTemplateFormPlugin_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), reportTitle));
        for (DynamicObject gData : goalDataCol) {
            coverContent.append('\n');
            String name = gData.getDynamicObject("fbasedataid").getString("name");
            coverContent.append(String.format("%s\uff1a{%s}", name, name));
        }
        model.setValue("covercontent", (Object)coverContent.toString());
    }

    private void setShowPromptContent(int outLineIndex) {
        IDataModel model = this.getModel();
        if (outLineIndex < 0) {
            model.setValue("backgprompt_eye", (Object)"");
            model.setValue("contentprompt_eye", (Object)"");
            model.setValue("contentprompt_eye_tag", (Object)"");
        } else {
            model.setValue("backgprompt_eye", model.getValue("backgroundprompt", outLineIndex));
            model.setValue("contentprompt_eye", model.getValue("contentprompt", outLineIndex));
            model.setValue("contentprompt_eye_tag", model.getValue("contentprompt_tag", outLineIndex));
        }
    }

    private HashMap<Long, String> checkGlobalFieldMapping(String entityNumber) {
        HashMap<Long, String> globalFields = this.getGlobalFields();
        HashMap dataGlobalRequire = ReportTemDataHelper.getDataGlobalRequire(globalFields.keySet(), (String)entityNumber);
        HashSet<String> excludeFields = new HashSet<String>(8);
        for (Map.Entry<Long, String> field : globalFields.entrySet()) {
            if (dataGlobalRequire.get(field.getKey()) != null) continue;
            excludeFields.add(field.getValue());
        }
        if (excludeFields.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u8868\u672a\u914d\u7f6e\u6574\u4f53\u6570\u636e\u8981\u6c42\u5b57\u6bb5\u201c%s\u201d\u7684\u201c\u6570\u636e\u8868\u5b57\u6bb5\u6620\u5c04\u201d\u3002", (String)"ReportTemplateFormPlugin_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", excludeFields)));
            return null;
        }
        return dataGlobalRequire;
    }

    private void updateGlobalFieldFilterDes() {
        IDataModel model = this.getModel();
        DynamicObjectCollection dataSource = model.getEntryEntity("datasourcesubentry");
        if (dataSource == null) {
            return;
        }
        for (DynamicObject ele : dataSource) {
            DynamicObject dataTable = ele.getDynamicObject("datatable");
            String fieldsNUmber = ele.getString("datapropnumber");
            if (!StringUtils.isNotEmpty((String)fieldsNUmber) || ObjectUtils.isEmpty((Object)dataTable)) continue;
            String entityNumber = dataTable.getString("number");
            String filterJson = ele.getString("datafiltervalue_tag");
            String filterDes = this.buildGlobalFieldFilterDes(entityNumber, filterJson);
            ele.set(C_KEY_DATA_FILTER, (Object)filterDes);
        }
        this.getView().updateView("datasourcesubentry");
    }

    private String buildGlobalFieldFilterDes(String entityNumber, String filterJson) {
        IDataModel model = this.getModel();
        DynamicObjectCollection goalDataCol = (DynamicObjectCollection)model.getValue("datarequire");
        StringBuilder filterDes = new StringBuilder();
        for (DynamicObject field : goalDataCol) {
            String name = field.getDynamicObject("fbasedataid").getString("name");
            filterDes.append(String.format(ResManager.loadKDString((String)"\uff08%s \u7b49\u4e8e \u7528\u6237\u8f93\u5165\uff09 \u5e76\u4e14", (String)"ReportTemplateFormPlugin_7", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), name));
        }
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)filterJson)) {
            return filterDes.toString();
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, condition);
        filterBuilder.buildFilter(false);
        filterDes.append(filterBuilder.getFilterObject().getFilter());
        return filterDes.toString();
    }

    static {
        notEntityFields.add("backgprompt_eye");
        notEntityFields.add("contentprompt_eye");
        notEntityFields.add("contentprompt_eye_tag");
    }
}

