/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fgptas.business.report.helper.ReportMutexHelper;
import kd.fi.fgptas.common.utils.LongUtil;

public class ReportTextPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ReportTextPlugin.class);
    protected static final String CTL_TOOLBARAP = "toolbarap";
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String BTN_DOWNLOAD = "btn_download";
    private static final String PARAM_WORD_ID = "pkId";
    private static final String NEXT_PAGE = "<nextPage>";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CTL_TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dataInit();
    }

    protected void dataInit() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("word", "=", (Object)this.getWordId()));
        qFilters.add(new QFilter("gptnumber", "=", (Object)"GPT-RESULT"));
        DynamicObject log = QueryServiceHelper.queryOne((String)"fgptas_report_gptlog", (String)"id,reportlog_tag", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (log != null && StringUtils.isNotEmpty((String)log.getString("reportlog_tag"))) {
            String[] split;
            StringBuilder text = new StringBuilder();
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("richtexteditorap");
            for (String line : split = log.getString("reportlog_tag").split("\n")) {
                if (line.contains("\\n")) {
                    for (String content : line.split("\\\\n")) {
                        if (NEXT_PAGE.equals(content)) {
                            text.append("<p></p>");
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((String)content)) continue;
                        text.append("<p><span style=\"font-size: 18px;\">").append(content).append("</span></span></p>\n");
                    }
                    continue;
                }
                if (NEXT_PAGE.equals(line)) {
                    text.append("<p></p>");
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)line)) continue;
                text.append("<p><span style=\"font-size: 18px;\">").append(line).append("</span></span></p>\n");
            }
            edit.setText(text.toString());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u6863\u4e3a\u7a7a\u3002", (String)"ReportTextPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    protected Long getWordId() {
        Long wordId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(PARAM_WORD_ID));
        return wordId;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!e.isCancel()) {
            ReportMutexHelper.viewRelease((String)this.getWordId().toString(), (String)"fgptas_report_design");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.dataInit();
                break;
            }
            case "btn_download": {
                this.downloadOper();
            }
        }
    }

    protected void downloadOper() {
        DynamicObject word = BusinessDataServiceHelper.loadSingle((Object)this.getWordId(), (String)"fgptas_report");
        if (word != null && StringUtils.isNotEmpty((String)word.getString("url"))) {
            String docUrl = UrlService.getAttachmentFullUrl((String)word.getString("url"));
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)docUrl);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u6863\u4e3a\u7a7a\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"ReportTextPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
    }
}

