/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.skill;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SkillFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(SkillFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"optionclick", "skilliconclick"});
        ((AbstractGrid)this.getControl("fgptas_skillcard")).addRowClickListener((RowClickEventListener)this);
    }

    public void initialize() {
        BasedataEdit dataKnowledge = (BasedataEdit)this.getControl("gpttaskid");
        dataKnowledge.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            IDataModel model = this.getModel();
            String propName = e.getProperty().getName();
            if ("datatabletype".equals(propName)) {
                ChangeData[] valueSet = e.getChangeSet();
                Object propValue = valueSet[0].getNewValue();
                Object oldValue = valueSet[0].getOldValue();
                if (Objects.nonNull(oldValue) && StringUtils.isNotEmpty((String)oldValue.toString()) && !oldValue.equals(propValue)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362/\u6e05\u7a7a\u6570\u636e\u8868\u4f1a\u6e05\u7a7a\u9009\u9879\u7684\u8be6\u7ec6\u914d\u7f6e\uff0c\u662f\u5426\u786e\u5b9a\u5207\u6362/\u6e05\u7a7a\u6570\u636e\u8868\uff1f", (String)"SkillFormPlugin_0", (String)"fi-fgptas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("dataTableTypeConfirmCallBack", (IFormPlugin)this));
                }
            } else if (propName.equals("mcardname")) {
                int rowCount = model.getEntryRowCount("fgptas_skillcard");
                if (rowCount > 0) {
                    model.setValue("cardname", model.getValue("mcardname"));
                }
            } else if (propName.equals("mdatatabletype")) {
                int rowCount = model.getEntryRowCount("fgptas_skillcard");
                if (rowCount > 0) {
                    model.setValue("datatabletype", model.getValue("mdatatabletype"));
                }
            } else if (propName.equals("interactionmode")) {
                this.setControlVisible();
            }
        }
        catch (Exception ex) {
            log.error("propertyChanged error:", (Throwable)ex);
        }
    }

    public void afterBindData(EventObject e) {
        this.setControlVisible();
        Object enable = this.getModel().getValue("enable");
        this.getView().setEnable(Boolean.valueOf("1".equals(enable)), new String[]{"tabap"});
    }

    private void setControlVisible() {
        IDataModel model = this.getModel();
        String interactionmode = (String)model.getValue("interactionmode");
        boolean bSidebar = "SIDEBAR".equals(interactionmode);
        BasedataEdit gpttaskid = (BasedataEdit)this.getControl("gpttaskid");
        BasedataEdit formmetaid = (BasedataEdit)this.getControl("formmetaid");
        gpttaskid.setVisible(null, bSidebar);
        formmetaid.setVisible(null, !bSidebar);
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("fgptas_skillcard");
        if (rowCount > 0) {
            model.setValue("mcardname", model.getValue("cardname"));
            model.setValue("mdatatabletype", model.getValue("datatabletype"));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("optionclick".equals(key)) {
            String optionjson = (String)this.getModel().getValue("optionjson");
            String mdatatabletype = (String)this.getModel().getValue("mdatatabletype");
            if (StringUtils.isEmpty((String)mdatatabletype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8868", (String)"SkillFormPlugin_1", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fgptas_skilloptiondetail");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "skilloptiondetail");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCustomParam("optionjson", (Object)optionjson);
            showParameter.setCustomParam("mdatatabletype", (Object)mdatatabletype);
            this.getView().showForm(showParameter);
        } else if ("skilliconclick".equals(key)) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("ide_pictureselector");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "shortcutCallBack"));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("skilloptiondetail".equals(actionId)) {
            String returnData = (String)event.getReturnData();
            log.info("========returnData======{}", (Object)returnData);
            if (StringUtils.isEmpty((String)returnData)) {
                this.getView().close();
                return;
            }
            this.getModel().setValue("optionjson", (Object)returnData);
        } else if ("shortcutCallBack".equals(actionId)) {
            Map map = (Map)event.getReturnData();
            String value = Optional.ofNullable(map).map(m -> (String)m.get("value")).orElse(null);
            if (StringUtils.isNotEmpty((String)value)) {
                this.getModel().setValue("skillicon", (Object)value);
            }
        } else if ("moveentryup,moveentrydown,deleteentry".contains(actionId)) {
            this.getView().invokeOperation(actionId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("dataTableTypeConfirmCallBack".equals(key)) {
            this.getModel().deleteEntryData("fgptas_skillcardoption");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("save".equals(key)) {
            String skillicon = (String)this.getModel().getValue("skillicon");
            if (StringUtils.isEmpty((String)skillicon)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201cGPT\u6280\u80fd\u56fe\u6807\u201d\u3002", (String)"SkillFormPlugin_4", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            QFilter f1 = new QFilter("skilltype", "=", this.getModel().getValue("skilltype"));
            QFilter f2 = new QFilter("id", "!=", this.getModel().getValue("id"));
            QFilter f3 = new QFilter("enable", "=", (Object)"1");
            boolean exists = QueryServiceHelper.exists((String)"fgptas_skill", (QFilter[])new QFilter[]{f1, f2, f3});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054GPT\u6280\u80fd\u7c7b\u578b\u91cd\u590d\uff0c\u8bf7\u4fee\u6539GPT\u6280\u80fd\u7c7b\u578b\u540e\u518d\u4fdd\u5b58\u3002", (String)"SkillFormPlugin_3", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        formShowParameter.setShowApproved(false);
        formShowParameter.setCustomParam("authority", (Object)Boolean.FALSE);
    }

    public void tabSelected(TabSelectEvent evt) {
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        String currentTab = tabAp.getCurrentTab();
        if ("tabcard".equals(currentTab)) {
            CardEntry skillcard = (CardEntry)this.getControl("fgptas_skillcard");
            Optional.ofNullable(skillcard).ifPresent(s -> s.selectRows(0));
        }
    }

    private void billListShow(String billFormId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

