/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.skill;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class SkillListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"enable"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("enable".equals(key)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            List ids = selectedRows.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            HashSet<String> typeSet = new HashSet<String>(ids.size());
            for (Long id : ids) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fgptas_skill");
                String skilltype = dynamicObject.getString("skilltype");
                if (typeSet.contains(skilltype)) {
                    this.showRepeatTip(args);
                } else {
                    typeSet.add(skilltype);
                }
                QFilter f1 = new QFilter("skilltype", "=", (Object)skilltype);
                QFilter f2 = new QFilter("id", "!=", (Object)id);
                QFilter f3 = new QFilter("enable", "=", (Object)"1");
                boolean exists = QueryServiceHelper.exists((String)"fgptas_skill", (QFilter[])new QFilter[]{f1, f2, f3});
                if (!exists) continue;
                this.showRepeatTip(args);
                return;
            }
        }
    }

    private void showRepeatTip(BeforeDoOperationEventArgs args) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054GPT\u6280\u80fd\u7c7b\u578b\u91cd\u590d\uff0c\u8bf7\u4fee\u6539GPT\u6280\u80fd\u7c7b\u578b\u540e\u518d\u542f\u7528\u3002", (String)"SkillFormPlugin_2", (String)"fi-fgptas-formplugin", (Object[])new Object[0]));
        args.setCancel(true);
    }
}

