/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.formplugin.skill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SkillOptionFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SkillOptionFormPlugin.class);
    private static final String BTN_OK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit dataKnowledge = (BasedataEdit)this.getControl("data_knowledge");
        dataKnowledge.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String[] properties;
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        String optionjson = (String)param.getCustomParam("optionjson");
        String mdatatabletype = (String)param.getCustomParam("mdatatabletype");
        if (StringUtils.isEmpty((String)mdatatabletype)) {
            return;
        }
        HashMap<String, String> datatableTypeMap = new HashMap<String, String>(3);
        datatableTypeMap.put("data_knowledge", "KNOWLEDGE_BASE");
        datatableTypeMap.put("data_reporttpl", "REPORT_TEMPLATE");
        datatableTypeMap.put("data_gpttask", "GPT_TASK");
        String baseDataPropName = "data_knowledge";
        for (String property : properties = "data_knowledge,data_reporttpl,data_gpttask".split(",")) {
            boolean bSelect = mdatatabletype.equals(datatableTypeMap.get(property));
            ((BasedataEdit)this.getControl(property)).setVisible(null, bSelect);
            if (!bSelect) continue;
            baseDataPropName = property;
        }
        if (StringUtils.isEmpty((String)optionjson)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)optionjson);
        model.setValue(baseDataPropName, jsonObject.get((Object)baseDataPropName));
        model.setValue("clicksidebar", jsonObject.get((Object)"clicksidebar"));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH);
        if (BTN_OK.equals(key)) {
            String[] properties = "data_knowledge,data_reporttpl,data_gpttask,clicksidebar".split(",");
            JSONObject jsonObject = new JSONObject();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            for (String property : properties) {
                Object value = dataEntity.get(property);
                if (!Objects.nonNull(value)) continue;
                if (value instanceof DynamicObject) {
                    jsonObject.put(property, ((DynamicObject)value).get("id"));
                    continue;
                }
                jsonObject.put(property, value);
            }
            this.getView().returnDataToParent((Object)jsonObject.toJSONString());
        }
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("data_knowledge".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setShowApproved(false);
            formShowParameter.setCustomParam("authority", (Object)Boolean.FALSE);
        }
    }
}

