/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.accesslog;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fgptas.common.enums.GlobalStatusEnum;
import kd.fi.fgptas.common.enums.SkillAccessResultEnum;
import kd.fi.fgptas.common.enums.SkillTypeEnum;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class GPTSkillAccesslogHelper {
    private static final Log log = LogFactory.getLog(GPTSkillAccesslogHelper.class);
    private static final String GPTAS_SKILLACCESSLOG = "fgptas_skillaccesslog";
    private static final String SKILLACCESSLOG_CACHE_KEY = "FGPTAS_SKILLACCESSLOG_CACHE_KEY";
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static Long accesslog(String skillNumber) {
        try {
            SkillTypeEnum skillType = (SkillTypeEnum)EnumUtils.getEnum(SkillTypeEnum.class, (String)skillNumber);
            String skillName = Objects.nonNull(skillType) ? skillType.getName() : "";
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            log.info(" GPTSkillAccesslogHelper.accesslog skillNumber={}, skillName={}, currentUserId={}", new Object[]{skillNumber, skillName, currentUserId});
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)GPTAS_SKILLACCESSLOG);
            dynamicObject.set("userid", (Object)currentUserId);
            dynamicObject.set("skillnumber", (Object)skillNumber);
            dynamicObject.set("skillname", (Object)skillName);
            dynamicObject.set("result", (Object)Boolean.FALSE);
            dynamicObject.set("accesstime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            Long accessLogId = dynamicObject.getLong("id");
            CACHE.put("FGPTAS_SKILLACCESSLOG_CACHE_KEY:" + skillNumber + ":" + currentUserId, (Object)("" + accessLogId), 3600);
            return accessLogId;
        }
        catch (Exception e) {
            log.error(" accesslog error:", (Throwable)e);
            return null;
        }
    }

    public static void updateAccessLog(String skillNumber, Boolean result) {
        try {
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            String key = "FGPTAS_SKILLACCESSLOG_CACHE_KEY:" + skillNumber + ":" + currentUserId;
            String accessLogIdStr = (String)CACHE.get(key);
            log.info(" GPTSkillAccesslogHelper.updateAccessLog key={}, accessLogIdStr={}", (Object)key, (Object)accessLogIdStr);
            long accessLogId = NumberUtils.toLong((String)accessLogIdStr, (long)0L);
            if (accessLogId == 0L) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)accessLogId, (String)GPTAS_SKILLACCESSLOG);
            dynamicObject.set("result", (Object)result);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            CACHE.remove(key);
        }
        catch (Exception e) {
            log.error("updateAccessLog error:", (Throwable)e);
        }
    }

    public static List<Map<String, Object>> accessRanking() {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        DynamicObject[] skills = BusinessDataServiceHelper.load((String)"fgptas_skill", (String)"skilltype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        HashSet<String> set = new HashSet<String>(1);
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        for (DynamicObject skill : skills) {
            set.add("'" + skill.getString("skilltype") + "'");
            nameMap.put(skill.getString("skilltype"), skill.getString("name"));
        }
        String skillNames = StringUtils.join((Object[])set.toArray(), (String)",");
        if (StringUtils.isBlank((CharSequence)skillNames)) {
            return list;
        }
        String sql = "select fskillnumber, count(*) total from t_fgptas_skillaccesslog where fskillnumber in (" + skillNames + ") group by fskillnumber order by total desc";
        DataSet dataSet = DB.queryDataSet((String)"GPTSkillAccesslogHelper.accessRanking", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        AtomicInteger seq = new AtomicInteger(1);
        HashSet<String> accessSkillTypes = new HashSet<String>(1);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String skillNumber = row.getString("fskillnumber");
            String skillName = (String)nameMap.get(skillNumber);
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            int increment = seq.getAndIncrement();
            Integer total = row.getInteger("total");
            map.put("sortno", increment);
            map.put("fskillname", skillName);
            map.put("total", GPTSkillAccesslogHelper.fixNum(total));
            accessSkillTypes.add(skillNumber);
            list.add(map);
        }
        for (DynamicObject skill : skills) {
            if (accessSkillTypes.contains(skill.getString("skilltype"))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("sortno", list.size() + 1);
            map.put("fskillname", skill.getString("name"));
            map.put("total", 0);
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> dataStatistics(String skillnumber, Date startdate, Date enddate) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("skillcount", 0);
        map.put("total", 0);
        map.put("users", 0);
        map.put("successrate", "0%");
        if (Objects.isNull(startdate) || Objects.isNull(enddate)) {
            return map;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (StringUtils.isNotEmpty((CharSequence)skillnumber)) {
            filters.add(new QFilter("skillnumber", "=", (Object)skillnumber));
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd");
        Date date1 = startdate;
        Date date2 = enddate;
        try {
            SimpleDateFormat sd1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            String str1 = sd.format(startdate);
            DynamicObject[] str2 = sd.format(enddate);
            date1 = sd1.parse(str1 + " 00:00:00.000");
            date2 = sd1.parse((String)str2 + " 23:59:59.999");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        filters.add(new QFilter("accesstime", ">", (Object)date1));
        filters.add(new QFilter("accesstime", "<", (Object)date2));
        DynamicObject[] skills = BusinessDataServiceHelper.load((String)"fgptas_skill", (String)"skilltype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (skills.length == 0) {
            return map;
        }
        HashSet<String> set = new HashSet<String>(1);
        for (DynamicObject skill : skills) {
            set.add(skill.getString("skilltype"));
        }
        if (set.size() != 0) {
            filters.add(new QFilter("skillnumber", "in", (Object)set.toArray()));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GPTSkillAccesslogHelper.dataStatistics", (String)GPTAS_SKILLACCESSLOG, (String)"skillnumber", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        int skillcount = StringUtils.isNotEmpty((CharSequence)skillnumber) ? 1 : skills.length;
        dataSet = QueryServiceHelper.queryDataSet((String)"GPTSkillAccesslogHelper.dataStatistics", (String)GPTAS_SKILLACCESSLOG, (String)"userid", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        int total = dataSet.count("userid", false);
        dataSet = QueryServiceHelper.queryDataSet((String)"GPTSkillAccesslogHelper.dataStatistics", (String)GPTAS_SKILLACCESSLOG, (String)"userid", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        int users = dataSet.count("userid", true);
        filters.add(new QFilter("result", "=", (Object)SkillAccessResultEnum.Success.getResult()));
        dataSet = QueryServiceHelper.queryDataSet((String)"GPTSkillAccesslogHelper.dataStatistics", (String)GPTAS_SKILLACCESSLOG, (String)"result", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        int result = dataSet.count("result", false);
        double finalResult = total != 0 ? (double)result * 100.0 / (double)total : 0.0;
        String formattedResult = finalResult != Math.floor(finalResult) ? String.format("%.2f", finalResult) : String.format("%.0f", finalResult);
        map.put("skillcount", GPTSkillAccesslogHelper.fixNum(skillcount));
        map.put("total", GPTSkillAccesslogHelper.fixNum(total));
        map.put("users", GPTSkillAccesslogHelper.fixNum(users));
        map.put("successrate", formattedResult + "%");
        return map;
    }

    public static String fixNum(int num) {
        String finalStr = String.valueOf(num);
        if (num < 1000) {
            return finalStr;
        }
        if (num < 10000) {
            return GPTSkillAccesslogHelper.thousandFormat(num);
        }
        double finalResult = (double)num / 10000.0;
        String formattedResult = finalResult != Math.floor(finalResult) ? String.format("%.2f", finalResult) : String.format("%.0f", finalResult);
        return String.format(ResManager.loadKDString((String)"%s\u4e07", (String)"GPTSkillAccesslogHelper_0", (String)"fi-fgptas-business", (Object[])new Object[0]), formattedResult);
    }

    public static String thousandFormat(int str) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String formattedNumber = formatter.format(str);
        return formattedNumber;
    }

    public static int getCountBySkillNumber(String skillNumber, Date startDate, Date endDate) {
        if (Objects.isNull(skillNumber)) {
            return 0;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("skillnumber", "=", (Object)skillNumber));
        if (startDate != null && endDate != null) {
            filters.add(new QFilter("accesstime", ">=", (Object)startDate));
            filters.add(new QFilter("accesstime", "<=", (Object)endDate));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"GPTSkillAccesslogHelper.getCountBySkillNumber", (String)GPTAS_SKILLACCESSLOG, (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);
        return dataSet.count("id", false);
    }

    public static List<ComboItem> getSelectIndex() {
        DynamicObject[] skills = BusinessDataServiceHelper.load((String)"fgptas_skill", (String)"skilltype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        HashSet<String> set = new HashSet<String>(1);
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        for (DynamicObject skill : skills) {
            set.add("'" + skill.getString("skilltype") + "'");
            nameMap.put(skill.getString("skilltype"), skill.getString("name"));
        }
        String skillNames = StringUtils.join((Object[])set.toArray(), (String)",");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(GlobalStatusEnum.GLOBAL_STATUS.getLabel()));
        comboItem1.setValue(GlobalStatusEnum.GLOBAL_STATUS.getValue());
        comboItems.add(comboItem1);
        if (StringUtils.isBlank((CharSequence)skillNames)) {
            return comboItems;
        }
        String sql = "select fskillnumber, count(*) total from t_fgptas_skillaccesslog where fskillnumber in (" + skillNames + ") group by fskillnumber order by total desc";
        DataSet dataSet = DB.queryDataSet((String)"GPTSkillAccesslogHelper.getSelectIndex", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        HashSet<String> accessSkillTypes = new HashSet<String>(1);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String skillNumber = row.getString("fskillnumber");
            String skillName = (String)nameMap.get(skillNumber);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(skillName));
            comboItem.setValue(skillNumber);
            accessSkillTypes.add(skillNumber);
            comboItems.add(comboItem);
        }
        for (DynamicObject skill : skills) {
            if (accessSkillTypes.contains(skill.getString("skilltype"))) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(skill.getString("name")));
            comboItem.setValue(skill.getString("skilltype"));
            comboItems.add(comboItem);
        }
        return comboItems;
    }
}

