/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import java.util.Comparator;
import java.util.Date;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.helper.AuditConfigSearcher;
import org.apache.commons.lang3.StringUtils;

public class AuditConfig {
    private DynamicObject auditConfig;
    private final String entityNumber;
    private static final Log log = LogFactory.getLog(AuditConfig.class);

    public AuditConfig(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public DynamicObject getConfigDyo() {
        return this.auditConfig;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public DynamicObject getOrCreateUpdateBillAudit(Object billPK) {
        DynamicObject dataEntity = null;
        try {
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)this.entityNumber);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        AuditConfigSearcher searcher = new AuditConfigSearcher();
        this.auditConfig = searcher.search(dataEntity);
        if (this.auditConfig == null) {
            log.warn(String.format("\u5355\u636e%s_%s \u627e\u4e0d\u5230\u5ba1\u6838\u65b9\u6848\u3002", this.entityNumber, billPK));
            return null;
        }
        Object configPK = this.auditConfig.getPkValue();
        QFilter[] qFilters = new QFilter[]{new QFilter("entityobject", "=", (Object)this.entityNumber), new QFilter("entityid", "=", billPK), new QFilter("configid", "=", configPK)};
        try {
            DynamicObject billAuditDyo;
            DynamicObject queryObj = QueryServiceHelper.queryOne((String)"fgptas_billaudit", (String)"id,runtimestatus", (QFilter[])qFilters);
            if (queryObj == null) {
                log.info(String.format("\u5355\u636e%s_%s\u5c1d\u8bd5\u9884\u521b\u5efa\u9644\u4ef6\u5ba1\u6838", this.entityNumber, billPK));
                billAuditDyo = this.createBillAudit(dataEntity);
            } else {
                log.info(String.format("\u9644\u4ef6\u5ba1\u6838\u5df2\u7ecf\u521b\u5efa\uff0c\u5355\u636e%s_%s", this.entityNumber, billPK));
                billAuditDyo = this.updateBillAudit(queryObj.getLong("id"));
            }
            if (billAuditDyo != null) {
                log.info(String.format("\u5355\u636e%s_%s\u9644\u4ef6\u5ba1\u6838\u9884\u521b\u5efa\u6d41\u7a0b\u7ed3\u675f\uff0c\u7ee7\u7eed\u8fdb\u884c\u9644\u4ef6\u5ba1\u6838\u6d41\u7a0b", this.entityNumber, billPK));
                DynamicObject[] saved = AuditConfig.saveRequiresNew(new DynamicObject[]{billAuditDyo});
                return saved[0];
            }
        }
        catch (Exception e) {
            log.error(String.format("\u5355\u636e%s_%s\u9884\u521b\u5efa\u9644\u4ef6\u5ba1\u6838\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38", this.entityNumber, billPK), (Throwable)e);
        }
        return null;
    }

    private DynamicObject updateBillAudit(Object billAuditPK) {
        DynamicObject inDB = BusinessDataServiceHelper.loadSingle((Object)billAuditPK, (String)"fgptas_billaudit");
        inDB.set("configid", this.auditConfig.getPkValue());
        Date modifytime = this.auditConfig.getDate("modifytime");
        Date configtime = inDB.getDate("configtime");
        if (configtime == null || modifytime != null && configtime.compareTo(modifytime) < 0) {
            this.fullFill(inDB);
        }
        return inDB;
    }

    private DynamicObject createBillAudit(DynamicObject dataEntity) {
        String number;
        Object billPK = dataEntity.getPkValue();
        DynamicObject audit = BusinessDataServiceHelper.newDynamicObject((String)"fgptas_billaudit");
        audit.set("billstatus", (Object)"C");
        audit.set("entityid", billPK);
        audit.set("entityobject", (Object)this.entityNumber);
        audit.set("configid", this.auditConfig.getPkValue());
        try {
            String billNoKey = this.auditConfig.getString("billnokey");
            number = dataEntity.getString(billNoKey);
        }
        catch (Exception e) {
            number = CodeRuleServiceHelper.getNumber((String)"fgptas_billaudit", (DynamicObject)audit, null);
        }
        audit.set("billno", (Object)number);
        audit.set("runtimestatus", (Object)FGPTASAuditStatus.NEW.getKey());
        audit.set("ocr_status", (Object)OcrStatus.NEW.getKey());
        this.fullFill(audit);
        this.createRiskItem(audit);
        return audit;
    }

    private void fullFill(DynamicObject audit) {
        Date modifyTime = this.auditConfig.getDate("modifytime");
        audit.set("configtime", (Object)(modifyTime == null ? new Date() : modifyTime));
        this.createElement(this.auditConfig, audit);
    }

    private void createElement(DynamicObject auditConfig, DynamicObject audit) {
        String ocrTargetElement;
        StringJoiner elementJoin = new StringJoiner("");
        StringJoiner ocrElementJoin = new StringJoiner(";");
        DynamicObjectCollection elements = auditConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject element : elements) {
            String elementString = element.getString("element");
            String fileType = element.getString("filetype.type");
            if (StringUtils.isBlank((CharSequence)fileType)) continue;
            if ("1".equals(fileType)) {
                if (elementJoin.length() + elementString.length() > 1000) {
                    log.error(this.entityNumber + "\u5ba1\u6838\u8981\u7d20\u8d85\u8fc7\u4e861000\u5b57\u7b26\uff01\u65e0\u6cd5\u6dfb\u52a0\u6b64\u8981\u7d20\uff1a" + elementString);
                    break;
                }
                elementJoin.add(elementString);
                continue;
            }
            if (!"2".equals(fileType)) continue;
            String name = element.getString("filetype.name");
            String text = name + String.format(ResManager.loadKDString((String)"\u4e2d\u7684%s", (String)"AuditConfig_0", (String)"fi-fgptas-business", (Object[])new Object[0]), elementString);
            ocrElementJoin.add(text);
        }
        String textElement = elementJoin.toString();
        String ocrElement = ocrElementJoin.toString();
        String string = ocrTargetElement = StringUtils.isBlank((CharSequence)ocrElement) ? ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u7684\u4fe1\u606f", (String)"AuditConfig_1", (String)"fi-fgptas-business", (Object[])new Object[0]) : ocrElement;
        if (StringUtils.isBlank((CharSequence)textElement)) {
            audit.set("element", null);
            audit.set("runtimestatus", (Object)FGPTASAuditStatus.FGPTAS_CONFIG_ERROR.getKey());
        } else if (!textElement.equals(audit.getString("element"))) {
            audit.set("element", (Object)textElement);
            audit.set("runtimestatus", (Object)FGPTASAuditStatus.NEW.getKey());
        }
        if (!ocrTargetElement.equals(audit.getString("ocr_element"))) {
            audit.set("ocr_element", (Object)ocrTargetElement);
        }
    }

    void createRiskItem(DynamicObject audit) {
        DynamicObjectCollection riskEntryConfigList = this.auditConfig.getDynamicObjectCollection("riskentry");
        if (riskEntryConfigList == null || riskEntryConfigList.isEmpty()) {
            return;
        }
        riskEntryConfigList.sort(Comparator.comparingInt(c -> c.getInt("seq")));
        DynamicObjectCollection riskEntryList = audit.getDynamicObjectCollection("riskentry");
        log.info("\u6e05\u9664\u5df2\u6709\u98ce\u9669\u9879\uff0c\u6839\u636e\u5ba1\u6838\u65b9\u6848\u9884\u521b\u5efa\u98ce\u9669\u9879");
        riskEntryList.clear();
        for (DynamicObject riskEntryConfig : riskEntryConfigList) {
            if (!riskEntryConfig.getBoolean("item_enable")) continue;
            DynamicObject riskEntry = riskEntryList.addNew();
            riskEntry.set("item_name", riskEntryConfig.get("item_name"));
            riskEntry.set("multi_field", riskEntryConfig.get("multi_field"));
            riskEntry.set("item_rule", riskEntryConfig.get("item_rule"));
        }
    }

    public static DynamicObject[] saveRequiresNew(DynamicObject[] audits) {
        DynamicObject[] objects;
        try (TXHandle h = TX.requiresNew((String)"kd.fi.fgptas.business.audit.AuditHelper.createAudit");){
            try {
                objects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])audits);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        return objects;
    }
}

