/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import java.util.Arrays;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.helper.BillAuditHelper;
import kd.fi.fgptas.business.audit.helper.RetryOrmHelper;
import kd.fi.fgptas.business.audit.schedule.RagWaiting;

public class AuditProgressTaskV2
implements Runnable {
    private final String pageId;
    private final Long entityId;
    private final String entityObject;
    private boolean forced = false;
    public static final String CACHE_SOURCE_PAGE = "CACHE_SOURCE_PAGE";
    public static final String CACHE_TRACE_ID = "CACHE_TRACE_ID";
    public static final String CACHE_FORCED = "CACHE_FORCED";
    public static final String TASK_RUNNING = "task_running";
    private static final Log log = LogFactory.getLog(AuditProgressTaskV2.class);

    public AuditProgressTaskV2(String pageId, Long entityId, String entityObject) {
        this.pageId = pageId;
        this.entityId = entityId;
        this.entityObject = entityObject;
    }

    @Override
    public void run() {
        SessionManager sm = SessionManager.getCurrent();
        boolean existView = sm.existView(this.pageId);
        boolean fromExceptionPage = true;
        if (existView) {
            IPageCache pageCache = sm.getPageCache(this.pageId);
            String s = pageCache.get(CACHE_SOURCE_PAGE);
            fromExceptionPage = StringUtils.equals((CharSequence)"fgptas_no_audit_show", (CharSequence)s);
            this.forced = StringUtils.equals((CharSequence)(pageCache.get(CACHE_FORCED) + ""), (CharSequence)"true");
            String traceId = pageCache.get(CACHE_TRACE_ID);
            log.info("cache trace:" + traceId);
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                RequestContext.get().setTraceId(traceId);
            }
        }
        boolean running = true;
        long start = System.currentTimeMillis();
        int sleep = 10000;
        this.checkRetryInfo();
        boolean startCheckRag = true;
        try {
            log.info("start AuditProgressTaskV2 for page: " + this.pageId + ", bill: " + this.entityId + ", entity:" + this.entityObject);
            while (existView && running) {
                this.threadSleep(sleep);
                this.commitCache(sm.getPageCache(this.pageId), "true");
                DynamicObject billAudit = BillAuditHelper.findBillAudit(this.entityObject, this.entityId);
                if (billAudit == null) {
                    this.commitCache(sm.getPageCache(this.pageId), "false");
                    return;
                }
                OcrStatus ocrStatus = OcrStatus.keyOf(billAudit.getString("ocr_status"));
                FGPTASAuditStatus ragStatus = FGPTASAuditStatus.keyOf(billAudit.getString("runtimestatus"));
                if (fromExceptionPage) {
                    boolean bl = running = FGPTASAuditStatus.SUCCESS != ragStatus && OcrStatus.SUCCESS != ocrStatus;
                }
                if (running) {
                    boolean bl = running = OcrStatus.RUNNING == ocrStatus || FGPTASAuditStatus.isRunning(ragStatus) || BillAuditHelper.riskRunning(billAudit);
                }
                if (startCheckRag && FGPTASAuditStatus.EMBEDDING_PROCESSING == ragStatus) {
                    log.info("AuditProgressTaskV2 find [embedding processing] and then start a waiting process.");
                    startCheckRag = false;
                    FGPTASAuditHelper context = new FGPTASAuditHelper(this.entityObject, false);
                    context.setBillPK(this.entityId);
                    context.setForced(this.forced);
                    context.setTraceId(RequestContext.get().getTraceId());
                    RagWaiting.execute(context);
                }
                existView = sm.existView(this.pageId);
                sleep = 5000;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        log.info("end AuditProgressTaskV2 for page: " + this.pageId + ", bill: " + this.entityId + ", entity:" + this.entityObject);
        sm.getPageCache(this.pageId);
        this.commitCache(sm.getPageCache(this.pageId), "false");
        if (!existView) {
            log.error(String.format("\u5355\u636e%s-%s\uff0c\u9875\u9762%s\u88ab\u5173\u95ed\u4e86\u5bfc\u81f4\u9000\u51fa\u3002", this.entityObject, this.entityId, this.pageId));
        }
        log.info(String.format("\u5355\u636e%s-%s\uff0c\u5728\u754c\u9762%s\u6392\u961f\u65f6\u957f:%sms", this.entityObject, this.entityId, this.pageId, System.currentTimeMillis() - start));
    }

    private void checkRetryInfo() {
        DynamicObject billAudit = BillAuditHelper.findBillAudit(this.entityObject, this.entityId);
        if (billAudit != null) {
            RetryOrmHelper.insert(billAudit);
        }
        BillAuditHelper.gptCallAsync(this.entityObject, this.entityId, this.forced, false);
    }

    private void threadSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void commitCache(IPageCache pageCache, String running) {
        if (pageCache != null) {
            if ("false".equals(running)) {
                pageCache.batchRemove(Arrays.asList(CACHE_SOURCE_PAGE, CACHE_TRACE_ID));
            }
            pageCache.put(TASK_RUNNING, running);
            pageCache.saveChanges();
        }
    }
}

