/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.fi.fgptas.business.audit.FGPTASAuditHelper;
import kd.fi.fgptas.business.audit.IExcludeAttachment;

public class BasicExcludeAttachment
implements IExcludeAttachment {
    private static final String ATT_SIZE = "size";
    private static final String ATT_TYPE = "type";
    private static final Log log = LogFactory.getLog(FGPTASAuditHelper.class);
    private long maxSize = 0x3200000L;
    private Set<String> types = new HashSet<String>(Arrays.asList("pdf", "txt", "json"));
    private boolean init = false;

    @Override
    public boolean exclude(Map<String, Object> attachInfo) {
        if (!this.init) {
            try {
                this.init = true;
                String id = MetadataDao.getIdByNumber((String)"gai_repo_upload_files", (MetaCategory)MetaCategory.Form);
                FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
                Date modifyDate = formMeta.getModifyDate();
                List items = formMeta.getItems();
                Optional<ControlAp> fileUpload = items.stream().filter(item -> item.getKey().equals("file_upload")).findFirst();
                if (fileUpload.isPresent() && fileUpload.get() instanceof AttachmentPanelAp) {
                    AttachmentPanelAp uploadAp = (AttachmentPanelAp)fileUpload.get();
                    String extendName = uploadAp.getExtendName();
                    if (StringUtils.isNotBlank((CharSequence)extendName)) {
                        this.types = new HashSet<String>(Arrays.asList(extendName.trim().split(",")));
                    }
                    this.maxSize = (long)uploadAp.getMaxAtmSize() * 1024L * 1024L;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6gai_repo_upload_files\u7684\u9644\u4ef6\u9650\u5236\u5f02\u5e38\uff0c\u4f7f\u7528\u9ed8\u8ba4\u9650\u5236\u3002", (Throwable)e);
                this.maxSize = 0x3200000L;
                this.types = new HashSet<String>(Arrays.asList("pdf", "txt", "json"));
            }
        }
        Long size = (Long)attachInfo.get(ATT_SIZE);
        String type = (String)attachInfo.get(ATT_TYPE);
        if (size == null || size > this.maxSize || type == null || !this.types.contains(type)) {
            log.error(String.format("\u6587\u4ef6\u4e0d\u80fd\u5173\u8054\u77e5\u8bc6\u5e93\uff0c\u5927\u5c0f\uff1a%s\uff0c\u6700\u5927\u652f\u6301\uff1a%s\uff1b\u6587\u4ef6\u7c7b\u578b\uff1a%s\uff0c\u652f\u6301\u7c7b\u578b:%s", size + "", this.maxSize, type + "", this.types));
            return true;
        }
        return false;
    }
}

