/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;

public class BillAuditResult {
    private boolean success;
    private boolean changed;
    private ErrorCode error;
    private Throwable exception;
    private String traceId;

    public BillAuditResult() {
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            this.traceId = requestContext.getTraceId();
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public ErrorCode getError() {
        return this.error;
    }

    public void setError(ErrorCode errorCode) {
        if (errorCode == null) {
            this.success = true;
            this.error = null;
        } else {
            this.success = false;
            this.error = new ErrorCode(errorCode.getCode(), errorCode.getMessage());
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void removeErrorCode() {
        this.error = null;
    }

    public static BillAuditResult toError(ErrorCode errorCode) {
        BillAuditResult billAuditResult = new BillAuditResult();
        billAuditResult.setError(errorCode);
        return billAuditResult;
    }

    public static BillAuditResult toSuccess() {
        BillAuditResult billAuditResult = new BillAuditResult();
        billAuditResult.setSuccess(true);
        return billAuditResult;
    }

    public String toString() {
        return "BillAuditResult{success=" + this.success + ", changed=" + this.changed + ", error=" + this.error + ", exception=" + this.exception + ", traceId=" + this.traceId + '}';
    }
}

