/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fgptas.business.audit.AuditConfig;
import kd.fi.fgptas.business.audit.BillAuditResult;
import kd.fi.fgptas.business.audit.FGPTASAuditStatus;
import kd.fi.fgptas.business.audit.GaiRepoStatus;
import kd.fi.fgptas.business.audit.OcrStatus;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.helper.RequestContextHelper;
import kd.fi.fgptas.business.audit.helper.RetryOrmHelper;
import kd.fi.fgptas.business.audit.pojo.BillAuditHelperParam;
import kd.fi.fgptas.business.audit.strategy.AbsBillAudit;
import kd.fi.fgptas.business.audit.strategy.BillAuditFactory;
import kd.fi.fgptas.common.helper.DynamicObjectUtil;
import kd.fi.fgptas.common.utils.PrivacyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class FGPTASAuditHelper {
    private static final Log log = LogFactory.getLog(FGPTASAuditHelper.class);
    private static final Set<String> FAIL_FILE = new HashSet<String>(Arrays.asList("D", "G"));
    private static final String ATT_SIZE = "size";
    private static final String ATT_TYPE = "type";
    protected Object billPK;
    private String entityNumber;
    protected Object billAuditPk;
    protected AuditConfig auditConfig;
    private boolean useFgptasUser;
    private final Map<String, List<Map<String, Object>>> attachInfosByType = new HashMap<String, List<Map<String, Object>>>(2);
    private DynamicObject billAudit;
    private boolean forced = false;
    private boolean forceRisk = false;
    private String traceId;

    public FGPTASAuditHelper(BillAuditHelperParam param) {
        this.entityNumber = param.getEntityNumber();
        this.auditConfig = new AuditConfig(this.entityNumber);
        this.billPK = param.getEntityId();
        this.forced = param.isForceAll();
        this.forceRisk = param.isForceRisk();
        this.useFgptasUser = param.isUseFgptasUser();
        this.traceId = param.getTraceId();
    }

    public FGPTASAuditHelper(String entityNumber, boolean useFgptasUser) {
        this.entityNumber = entityNumber;
        this.auditConfig = new AuditConfig(entityNumber);
        this.useFgptasUser = useFgptasUser;
    }

    public List<Map<String, Object>> getAttachInfosByType(String type) {
        return this.attachInfosByType.getOrDefault(type, new ArrayList());
    }

    public Object getBillPK() {
        return this.billPK;
    }

    public void setBillPK(Object billPK) {
        this.billPK = billPK;
    }

    public Object getBillAuditPk() {
        return this.billAuditPk;
    }

    public AuditConfig getAuditConfig() {
        return this.auditConfig;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public DynamicObject getBillAudit() {
        return this.billAudit;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean isUseFgptasUser() {
        return this.useFgptasUser;
    }

    public void setUseFgptasUser(boolean useFgptasUser) {
        this.useFgptasUser = useFgptasUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BillAuditResult> process() {
        List<BillAuditResult> results;
        block9: {
            log.info(String.format("\u5f00\u59cb\u5904\u7406\u9644\u4ef6\u5ba1\u6838: bill_%s, entityNumber_%s, forced_%s, traceId_%s, useFgptasUser_%s", this.billPK, this.entityNumber, this.forced, this.traceId, this.useFgptasUser));
            results = new ArrayList<BillAuditResult>(2);
            BillAuditResult errorResult = this.postConstructReturnError();
            if (errorResult != null) {
                results.add(errorResult);
                log.error("\u9644\u4ef6\u5ba1\u6838\u9884\u521b\u5efa\u6216\u540e\u7f6e\u521b\u5efa\u5931\u8d25: " + SerializationUtils.toJsonString(results));
                return results;
            }
            try {
                String billNo = this.billAudit.getString("billno");
                DataMutex dataMutex = null;
                try {
                    dataMutex = DataMutex.create();
                    boolean lock = FGPTASAuditHelper.require(dataMutex, this.billAuditPk + "", billNo);
                    log.warn(String.format("bill:%s_%s tries to lock the bill audit and get %s", this.billPK, billNo, lock));
                    if (lock) {
                        if (this.forced || this.forceRisk) {
                            this.auditConfig.createRiskItem(this.billAudit);
                        }
                        results = this.executeBillAudit();
                    } else {
                        log.warn(String.format("bill:%s#%s is locked by another thread", this.billPK, billNo));
                        dataMutex = null;
                        results.add(BillAuditResult.toError(AuditErrorCode.OCCUPIED_OTHER_THREAD));
                    }
                    if (dataMutex == null) break block9;
                }
                catch (Throwable throwable) {
                    if (dataMutex != null) {
                        log.warn(String.format("bill:%s_%s tries to release the bill audit", this.billPK, billNo));
                        FGPTASAuditHelper.release(dataMutex, this.billAuditPk + "", billNo);
                    }
                    throw throwable;
                }
                log.warn(String.format("bill:%s_%s tries to release the bill audit", this.billPK, billNo));
                FGPTASAuditHelper.release(dataMutex, this.billAuditPk + "", billNo);
            }
            catch (Exception e) {
                BillAuditResult r = BillAuditResult.toError(AuditErrorCode.UNEXPECTED_ERROR_BUILDER.apply(e.getMessage()));
                r.setException(e);
                results.add(r);
            }
        }
        log.info("\u9644\u4ef6\u5ba1\u6838\u5b8c\u6210\uff1a" + SerializationUtils.toJsonString(results));
        return results;
    }

    private BillAuditResult postConstructReturnError() {
        if (StringUtils.isNotBlank((CharSequence)this.traceId)) {
            log.info(String.format("change trace id from %s to %s", RequestContext.get().getTraceId(), this.traceId));
            RequestContext.get().setTraceId(this.traceId);
        }
        log.info("current trace id: " + RequestContext.get().getTraceId());
        this.billAudit = this.auditConfig.getOrCreateUpdateBillAudit(this.billPK);
        if (this.billAudit == null) {
            return BillAuditResult.toError(AuditErrorCode.CONFIG_ERROR);
        }
        this.billAuditPk = this.billAudit.getPkValue();
        if (this.useFgptasUser) {
            long fgptasUser = this.auditConfig.getConfigDyo().getDynamicObject("fgptasuser").getLong("id");
            RequestContextHelper.copy(RequestContext.get(), fgptasUser + "");
        }
        if (!PrivacyUtil.checkCurrUserPrivacy()) {
            this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.PRICACY_ERROR.getKey());
            this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
            log.error("\u5ba1\u6838\u8981\u7d20\u914d\u7f6e\u7684GPT\u4eba\u5458\u672a\u7b7e\u7f72\u9690\u79c1\u534f\u8bae");
            return BillAuditResult.toError(AuditErrorCode.PRIVACY_ERROR);
        }
        return null;
    }

    @Deprecated
    public boolean gptAudit(boolean forced) {
        this.forced = forced;
        List<BillAuditResult> results = this.process();
        return !results.isEmpty() && results.stream().allMatch(BillAuditResult::isSuccess);
    }

    private List<BillAuditResult> executeBillAudit() {
        this.splitAttachment();
        ArrayList<BillAuditResult> results = new ArrayList<BillAuditResult>(2);
        for (Map.Entry<String, List<Map<String, Object>>> entrySet : this.attachInfosByType.entrySet()) {
            String key = entrySet.getKey();
            AbsBillAudit absBillAudit = BillAuditFactory.newBillAudit(key);
            absBillAudit.setContext(this);
            BillAuditResult billAuditResult = absBillAudit.processBillAudit();
            results.add(billAuditResult);
        }
        this.afterExecuteBillAudit(results);
        return results;
    }

    private void splitAttachment() {
        Set panels = AttachmentServiceHelper.getAttachmentsForApi((String)this.entityNumber, (Object)this.billPK).keySet();
        log.info(this.billPK + " has attachment panels: " + String.join((CharSequence)",", panels));
        List textAttachInfos = this.attachInfosByType.computeIfAbsent("1", k -> new ArrayList());
        List imageAttachInfos = this.attachInfosByType.computeIfAbsent("2", k -> new ArrayList());
        for (String attachKey : panels) {
            Map attachments = AttachmentServiceHelper.getAttachments((String)this.entityNumber, (Object[])new Object[]{this.billPK}, (String)attachKey, (boolean)false);
            List attachInfos = attachments.getOrDefault(this.billPK + "", new ArrayList());
            HashSet<String> textTypes = new HashSet<String>(Arrays.asList("txt", "json"));
            HashSet<String> imageTypes = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "bmp", "ofd"));
            for (Map attachInfo : attachInfos) {
                String name = attachInfo.get("name") + "";
                String fileExt = attachInfo.get(ATT_TYPE) + "";
                boolean imagePdf = false;
                boolean textPdf = false;
                if ("pdf".equalsIgnoreCase(fileExt)) {
                    InputStream is = FileServiceFactory.getAttachmentFileService().getInputStream(attachInfo.get("relativeUrl") + "");
                    try (PDDocument pdDocument = PDDocument.load((InputStream)is);){
                        int numberOfPdf = pdDocument.getNumberOfPages();
                        imagePdf = numberOfPdf == 1;
                        textPdf = numberOfPdf > 1;
                    }
                    catch (IOException e) {
                        log.error("fail to read pdf:[" + name + "]" + e);
                        continue;
                    }
                }
                if (imageTypes.contains(fileExt) || imagePdf) {
                    imageAttachInfos.add(attachInfo);
                    continue;
                }
                if (!textTypes.contains(fileExt) && !textPdf) continue;
                textAttachInfos.add(attachInfo);
            }
        }
    }

    private void afterExecuteBillAudit(List<BillAuditResult> results) {
        this.setRetryInfo(results);
        this.setRiskItem(results);
    }

    private void setRetryInfo(List<BillAuditResult> results) {
        boolean anyFail = results.stream().anyMatch(r -> !r.isSuccess());
        if (anyFail) {
            try {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.billAuditPk, (String)"fgptas_billaudit", (String)"billno,runtimestatus,ocr_status,ocr_error,riskentry");
                RetryOrmHelper.save(obj);
            }
            catch (Exception e) {
                log.error("fail to write retry info " + e);
            }
        } else {
            RetryOrmHelper.delete(this.billAuditPk);
        }
    }

    private void setRiskItem(List<BillAuditResult> results) {
        log.info("\u51c6\u5907\u8fdb\u884c\u98ce\u9669\u5ba1\u6838\uff1a" + results);
        StringBuilder attachSummaryBuilder = new StringBuilder();
        if (FGPTASAuditStatus.SUCCESS.getKey().equals(this.billAudit.getString("runtimestatus"))) {
            attachSummaryBuilder.append(this.billAudit.getString("output_tag")).append("\n");
        }
        if (OcrStatus.SUCCESS.getKey().equals(this.billAudit.getString("ocr_status"))) {
            attachSummaryBuilder.append(this.billAudit.getString("ocr_output_tag"));
        }
        if (StringUtils.isBlank((CharSequence)attachSummaryBuilder)) {
            return;
        }
        FGPTASAuditStatus ragStatus = FGPTASAuditStatus.keyOf(this.billAudit.getString("runtimestatus"));
        OcrStatus ocrStatus = OcrStatus.keyOf(this.billAudit.getString("ocr_status"));
        log.info(String.format("rag status:%s, ocr status:%s", new Object[]{ragStatus, ocrStatus}));
        if (!FGPTASAuditStatus.isFinished(ragStatus) || !OcrStatus.isFinished(ocrStatus, this.billAudit.getString("ocr_error"))) {
            log.info("\u672a\u5b8c\u6210\u8981\u7d20\u63d0\u53d6\u65e0\u6cd5\u8fdb\u884c\u98ce\u9669\u9884\u6d4b");
            return;
        }
        String attachSummary = attachSummaryBuilder.toString();
        boolean nonChanged = results.stream().noneMatch(BillAuditResult::isChanged);
        DynamicObjectCollection riskEntry = this.billAudit.getDynamicObjectCollection("riskentry");
        for (DynamicObject riskItem : riskEntry) {
            String riskStatus = riskItem.getString("riskstatus");
            if (nonChanged && "1".equals(riskStatus)) continue;
            String itemName = riskItem.getString("item_name");
            String itemRule = riskItem.getString("item_rule");
            String multiField = riskItem.getString("multi_field");
            String billSummary = "";
            if (StringUtils.isNotBlank((CharSequence)multiField)) {
                try {
                    billSummary = DynamicObjectUtil.toDisplayName((String)multiField, (String)this.entityNumber, (Object)this.billPK);
                }
                catch (Exception ex) {
                    log.error(itemName, (Throwable)ex);
                    continue;
                }
            }
            DynamicObject configEntity = this.auditConfig.getConfigDyo();
            long promptRisk = NumberUtils.toLong((String)(configEntity.getDynamicObject("prompt_risk").getPkValue() + ""), (long)0L);
            HashMap<String, String> variableMap = new HashMap<String, String>();
            variableMap.put("v1", billSummary);
            variableMap.put("v2", attachSummary);
            Object[] params = new Object[]{promptRisk, itemRule, variableMap};
            Object gptResult = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
            if (gptResult == null) {
                log.error(itemRule + "result: gptcall response is null");
                riskItem.set("riskresponse_tag", (Object)"GaiPromptService.syncCall answered nothing.");
                riskItem.set("riskstatus", (Object)"0");
                continue;
            }
            String jsonString = JSON.toJSONString((Object)gptResult);
            JSONObject gptJsonObject = JSON.parseObject((String)jsonString);
            if ("0".equals(gptJsonObject.get((Object)"errCode"))) {
                String llmValue = ((Map)gptJsonObject.get((Object)"data")).get("llmValue") + "";
                llmValue = FGPTASAuditHelper.renderLLMValue(llmValue);
                riskItem.set("riskresponse_tag", (Object)llmValue);
                riskItem.set("riskstatus", (Object)"1");
                continue;
            }
            log.error(itemRule + ", gptcall response:" + jsonString);
            riskItem.set("riskresponse_tag", (Object)jsonString);
            riskItem.set("riskstatus", (Object)"0");
        }
        FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit});
    }

    public boolean embedding() {
        boolean bl;
        long billPK = this.billAudit.getLong("entityid");
        FGPTASAuditStatus runtimeStatus = FGPTASAuditStatus.keyOf(this.billAudit.getString("runtimestatus"));
        if (runtimeStatus == null) {
            return false;
        }
        try {
            log.info(String.format("\u9644\u4ef6\u5ba1\u6838\u8fdb\u5165\u5411\u91cf\u5316\u6d41\u7a0b\uff0c\u5f53\u524d\u3010billno=%s, runtimestatus=%s\u3011", this.billAudit.getString("billno"), FGPTASAuditStatus.keyOf(this.billAudit.getString("runtimestatus")).name()));
            bl = this.syncGaiRepo();
        }
        catch (Exception e) {
            try {
                log.error(String.format("\u5355\u636e%s_%s\u540c\u6b65GPT\u77e5\u8bc6\u5e93\u5f02\u5e38", this.entityNumber, billPK), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit});
                throw throwable;
            }
        }
        FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit});
        return bl;
    }

    private boolean syncGaiRepo() {
        long repoId;
        String billAuditNo = this.billAudit.getString("billno");
        List<Map<String, Object>> attachInfos = this.attachInfosByType.get("1");
        if (attachInfos == null || attachInfos.isEmpty()) {
            log.error(String.format("\u9644\u4ef6\u5ba1\u6838%s\u5173\u8054\u7684\u5355\u636e%s\u90fd\u4e0d\u7b26\u5408\u9644\u4ef6\u89c4\u8303\uff0c\u65e0\u6cd5\u8fdb\u884c\u5411\u91cf\u5316\u3002", billAuditNo, this.billPK));
            DynamicObject gaiRepo = this.billAudit.getDynamicObject("gairepo");
            this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.NO_ATTACHMENT.getKey());
            if (gaiRepo != null) {
                this.billAudit.set("gairepo", null);
                this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
                long repoId2 = NumberUtils.toLong((String)(gaiRepo.getPkValue() + ""));
                Object[] params = new Object[]{repoId2};
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"deleteRepoById", (Object[])params);
            }
            return true;
        }
        if (FGPTASAuditStatus.FGPTAS_CONFIG_ERROR == FGPTASAuditStatus.keyOf(this.billAudit.getString("runtimestatus"))) {
            return false;
        }
        DynamicObject gaiRepo = this.billAudit.getDynamicObject("gairepo");
        DynamicObject auditConfigDyo = this.auditConfig.getConfigDyo();
        Map repoInfo = new HashMap(8);
        if (gaiRepo != null) {
            String oldMethod;
            repoId = NumberUtils.toLong((String)(gaiRepo.getPkValue() + ""), (long)0L);
            String curMethod = auditConfigDyo.getString("index_method");
            if (!curMethod.equals(oldMethod = (repoInfo = this.queryRepoInfo(repoId, data -> data)).get("indexMethod") + "")) {
                log.warn(String.format("\u7d22\u5f15\u65b9\u5f0f\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u9700\u8981\u5220\u9664\u5e76\u521b\u5efa\u91cd\u65b0\u521b\u5efa\u77e5\u8bc6\u5e93\u3002%s --> %s", oldMethod, curMethod));
                this.billAudit.set("gairepo", null);
                this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.NEW.getKey());
                this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
                Object[] params = new Object[]{repoId};
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"deleteRepoById", (Object[])params);
                gaiRepo = null;
            }
        }
        if (gaiRepo != null) {
            repoId = NumberUtils.toLong((String)(gaiRepo.getPkValue() + ""));
            boolean repoChanged = this.syncAttachmentInfo(attachInfos, repoId);
            Object status = repoChanged ? this.queryRepoInfo(repoId, data -> data.get("status")) : repoInfo.get("status");
            GaiRepoStatus repoStatus = GaiRepoStatus.keyOf(status + "");
            FGPTASAuditStatus billAuditStatus = FGPTASAuditStatus.keyOf(this.billAudit.getString("runtimestatus"));
            if (repoStatus == GaiRepoStatus.SUCCESS) {
                log.info(String.format("\u9644\u4ef6\u5ba1\u6838%s\u5411\u91cf\u5316\u5df2\u5b8c\u6210\u3002", billAuditNo));
                if (repoChanged || FGPTASAuditStatus.NEW == billAuditStatus || FGPTASAuditStatus.EMBEDDING_PROCESSING == billAuditStatus) {
                    this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.GPT_AUDIT_PROCESSING.getKey());
                }
                return true;
            }
            if (repoStatus == GaiRepoStatus.RUNNING || repoStatus == GaiRepoStatus.NEW) {
                this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey());
            } else if (repoStatus == GaiRepoStatus.FAIL) {
                this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_ERROR.getKey());
            }
        } else {
            repoId = NumberUtils.toLong((String)(this.createRepo(attachInfos, this.billAudit) + ""), (long)0L);
            if (repoId != 0L) {
                DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_repo_info");
                this.billAudit.set("gairepo", (Object)repo);
                this.billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.EMBEDDING_PROCESSING.getKey());
            }
        }
        this.billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{this.billAudit})[0];
        return false;
    }

    private Object createRepo(List<Map<String, Object>> attachInfos, DynamicObject billAudit) {
        DynamicObject dataEntity = this.auditConfig.getConfigDyo();
        String indexMethod = dataEntity.getString("index_method");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        String billno = billAudit.getString("billno");
        String prefix = ResManager.loadKDString((String)"\u9644\u4ef6\u5ba1\u6838_", (String)"FGPTASAuditHelper_1", (String)"fi-fgptas-business", (Object[])new Object[0]);
        paramsMap.put("desc", prefix + billno);
        paramsMap.put("indexMethod", indexMethod);
        paramsMap.put("name", prefix + billno);
        paramsMap.put(ATT_TYPE, "qa");
        paramsMap.put("useOrg", this.getUseOrg(billAudit));
        paramsMap.put("fileInfos", this.getFileInfos(attachInfos, null));
        String paramJson = SerializationUtils.toJsonString(paramsMap);
        Object[] params = new Object[]{paramJson};
        log.info("\u8c03\u7528GaiRagService#createRepo\uff0c\u8bf7\u6c42\u53c2\u6570" + paramJson);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"createRepo", (Object[])params);
        log.info("\u8c03\u7528GaiRagService#createRepo\uff0c\u8fd4\u56de\u7ed3\u679c" + result);
        if (StringUtils.isNotBlank((CharSequence)(result.get("status") + "")) && !Boolean.parseBoolean(result.get("status") + "")) {
            String error = ResManager.loadKDString((String)"\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25\u3002", (String)"FGPTASAuditHelper_2", (String)"fi-fgptas-business", (Object[])new Object[0]);
            throw new RuntimeException(error + result);
        }
        return result.get("data");
    }

    private long getUseOrg(DynamicObject billAudit) {
        long mainOrg = 0L;
        String userkey = this.auditConfig.getConfigDyo().getString("userkey");
        DynamicObject user = QueryServiceHelper.queryOne((String)this.entityNumber, (String)userkey, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billAudit.getLong("entityid"))});
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(user.getLong(userkey));
        mainOrg = this.getMainOrg(userIds);
        if (mainOrg == 0L) {
            user = this.auditConfig.getConfigDyo().getDynamicObject("fgptasuser");
            userIds = new ArrayList(1);
            userIds.add(user.getLong("id"));
            mainOrg = this.getMainOrg(userIds);
        }
        return mainOrg == 0L ? OrgUnitServiceHelper.getRootOrgId() : mainOrg;
    }

    private long getMainOrg(List<Long> userIds) {
        try {
            List userPositionList = UserServiceHelper.getPosition(userIds);
            Map userDyo = (Map)userPositionList.get(0);
            List depsMap = (List)userDyo.get("entryentity");
            return depsMap.stream().filter(m -> !Boolean.parseBoolean(m.get("ispartjob") + "")).map(m -> ((DynamicObject)m.get("dpt")).getLong("id")).findFirst().orElse(0L);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e3b\u804c\u5931\u8d25" + e);
            return 0L;
        }
    }

    private List<Map<String, Object>> getFileInfos(List<Map<String, Object>> attachInfos, Set<String> excludePaths) {
        if (attachInfos.isEmpty()) {
            return attachInfos;
        }
        ArrayList<Map<String, Object>> props = new ArrayList<Map<String, Object>>(attachInfos.size());
        for (Map<String, Object> attachInfo : attachInfos) {
            HashMap<String, Object> fileInfo = new HashMap<String, Object>(4);
            Object path = attachInfo.get("relativeUrl");
            if (excludePaths != null && excludePaths.contains(path)) continue;
            fileInfo.put("fileName", attachInfo.get("name"));
            String type = attachInfo.get(ATT_TYPE) + "";
            type = "txt".equalsIgnoreCase(type) ? "text" : type;
            fileInfo.put("fileType", type);
            fileInfo.put("filePath", path);
            fileInfo.put("fileSize", attachInfo.get(ATT_SIZE));
            props.add(fileInfo);
        }
        return props;
    }

    private <T> T queryRepoFilesInfo(Object repoId, Function<List<Map<String, Object>>, T> function) {
        Object[] params = new Object[]{repoId};
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"queryRepoFilesInfo", (Object[])params);
        if (Boolean.parseBoolean(result.get("status") + "")) {
            List data = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(result.get("data")), List.class);
            return function.apply(data);
        }
        log.error("\u8bf7\u6c42GPT\u5e73\u53f0\u5931\u8d25" + SerializationUtils.toJsonString((Object)result));
        throw new RuntimeException(result.toString());
    }

    public <T> T queryRepoInfo(Object repoId, Function<Map<String, Object>, T> function) {
        Object[] params = new Object[]{repoId};
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"queryRepoInfo", (Object[])params);
        if (Boolean.parseBoolean(result.get("status") + "")) {
            Map data = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(result.get("data")), Map.class);
            return function.apply(data);
        }
        log.error("\u8bf7\u6c42GPT\u5e73\u53f0\u5931\u8d25" + SerializationUtils.toJsonString((Object)result));
        throw new RuntimeException(result.toString());
    }

    private boolean syncAttachmentInfo(List<Map<String, Object>> attachInfos, long repoId) {
        List<Map<String, Object>> addAttach;
        HashSet deleteIds = new HashSet(8);
        HashSet<String> existPaths = new HashSet<String>(8);
        boolean changed = false;
        this.queryRepoFilesInfo(repoId, data -> {
            for (Map datum : data) {
                long filePK = NumberUtils.toLong((String)(datum.get("fileId") + ""), (long)0L);
                String filePath = (String)datum.get("filePath");
                String fileStatus = (String)datum.get("fileStatus");
                boolean needDelete = true;
                for (Map attachInfo : attachInfos) {
                    String relativeUrl = (String)attachInfo.get("relativeUrl");
                    if (!StringUtils.isNotBlank((CharSequence)relativeUrl) || !relativeUrl.equals(filePath)) continue;
                    needDelete = FAIL_FILE.contains(fileStatus);
                    break;
                }
                if (needDelete) {
                    deleteIds.add(filePK);
                    continue;
                }
                existPaths.add(filePath);
            }
            return null;
        });
        if (!deleteIds.isEmpty()) {
            changed = true;
            HashMap<String, Serializable> deleteParam = new HashMap<String, Serializable>();
            deleteParam.put("repoId", Long.valueOf(repoId));
            deleteParam.put("fileIds", deleteIds);
            String deleteJson = SerializationUtils.toJsonString(deleteParam);
            log.info("\u8c03\u7528GaiRagService#deleteRepoFiles\uff0c\u8bf7\u6c42\u53c2\u6570" + deleteJson);
            Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"deleteRepoFiles", (Object[])new Object[]{deleteJson});
            log.info("\u8c03\u7528GaiRagService#deleteRepoFiles\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c" + SerializationUtils.toJsonString((Object)result));
        }
        if (!(addAttach = this.getFileInfos(attachInfos, existPaths)).isEmpty()) {
            changed = true;
            HashMap<String, Object> addParam = new HashMap<String, Object>();
            addParam.put("repoId", repoId);
            addParam.put("fileInfos", addAttach);
            String addJson = SerializationUtils.toJsonString(addParam);
            log.info("\u8c03\u7528GaiRagService#deleteRepoFiles\uff0c\u8bf7\u6c42\u53c2\u6570" + addJson);
            Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"addRepoFiles", (Object[])new Object[]{addJson});
            log.info("\u8c03\u7528GaiRagService#deleteRepoFiles\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c" + SerializationUtils.toJsonString((Object)result));
        }
        return changed;
    }

    public boolean attachmentAudit(boolean forced) {
        if (this.billAuditPk == null || StringUtils.isBlank((CharSequence)this.entityNumber)) {
            log.error(String.format("\u65e0\u6cd5\u7ee7\u7eed\u9644\u4ef6\u5ba1\u6838\uff0c\u5165\u53c2\uff1apks:%s, entityNumber:%s\u3002", this.billAuditPk == null ? "null" : this.billAuditPk, this.entityNumber));
            return false;
        }
        DynamicObject auditConfig = this.auditConfig.getConfigDyo();
        DynamicObject billAudit = BusinessDataServiceHelper.loadSingle((Object)this.billAuditPk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fgptas_billaudit"));
        FGPTASAuditStatus status = FGPTASAuditStatus.keyOf(billAudit.getString("runtimestatus"));
        if (status == FGPTASAuditStatus.NO_ATTACHMENT || !forced && status == FGPTASAuditStatus.SUCCESS) {
            log.info(String.format("\u9644\u4ef6\u5ba1\u6838-RAG%s\u5df2\u5b8c\u6210\uff0c\u4e0d\u518d\u8fdb\u884c\u603b\u7ed3\u3002", this.billAuditPk));
            return true;
        }
        Object pkValue = billAudit.getDynamicObject("gairepo").getPkValue();
        long repoId = NumberUtils.toLong((String)(pkValue + ""), (long)0L);
        boolean disable = true;
        if (repoId != 0L) {
            try {
                Object s = this.queryRepoInfo(repoId, data -> data.get("status"));
                GaiRepoStatus repoStatus = GaiRepoStatus.keyOf(s + "");
                disable = repoStatus != GaiRepoStatus.SUCCESS;
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (disable) {
            log.error(String.format("%s\u5f53\u524d\u72b6\u6001%s\u4e0d\u80fd\u8fdb\u884cGPT\u603b\u7ed3\u6216\u8005\u4e0d\u9700\u8981\u603b\u7ed3\u3002", this.billAuditPk, status.name()));
            return true;
        }
        QFilter qfilter = new QFilter("entityobject", "=", (Object)this.entityNumber).and(new QFilter("enable", "=", (Object)"1"));
        String entityId = billAudit.getString("entityid");
        String entityNumber = billAudit.getString("entityobject.number");
        billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.GPT_AUDIT_PROCESSING.getKey());
        billAudit = FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{billAudit})[0];
        log.info(String.format("\u5355\u636e%s-%s\u5c06\u53d1\u8d77PT\u8c03\u7528", entityId, entityNumber));
        int count = 0;
        boolean gptSuccess = false;
        while (count++ < 2 && QueryServiceHelper.exists((String)"fgptas_auditconfig", (QFilter[])qfilter.toArray()) && !gptSuccess) {
            gptSuccess = this.gptCall(auditConfig, billAudit);
        }
        if (gptSuccess) {
            billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.SUCCESS.getKey());
        } else {
            billAudit.set("runtimestatus", (Object)FGPTASAuditStatus.GPT_ERROR.getKey());
        }
        FGPTASAuditHelper.saveRequiresNew(new DynamicObject[]{billAudit});
        return gptSuccess;
    }

    protected boolean gptCall(DynamicObject auditConfig, DynamicObject billAudit) {
        Object pkValue = billAudit.getPkValue();
        long promptId = auditConfig.getLong("prompt.id");
        if (promptId == 0L) {
            log.error("\u5355\u636e\u5ba1\u6838\u914d\u7f6e\u8868\u6ca1\u6709\u914d\u7f6e\u63d0\u793a\u5668");
            return false;
        }
        String input = billAudit.getString("element");
        HashMap variableMap = new HashMap();
        List<Long> repoIds = Collections.singletonList(billAudit.getLong("gairepo.id"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chatSessionId", pkValue + "#pre");
        params.put("promptId", promptId);
        params.put("input", input);
        params.put("varParams", variableMap);
        params.put("repoIds", repoIds);
        String paramJson = SerializationUtils.toJsonString(params);
        String llmValue = this.syncCallUseDynamicRepo(paramJson);
        if (StringUtils.isBlank((CharSequence)llmValue)) {
            log.error(String.format("GPT\u5f00\u53d1\u5e73\u53f0\uff1a\u9644\u4ef6\u5ba1\u6838-%s\u7684\u9884\u63d0\u95ee%s\u5f97\u4e0d\u5230\u56de\u590d\u3002", pkValue, input));
            return false;
        }
        billAudit.set("output_tag", (Object)llmValue);
        return true;
    }

    private String syncCallUseDynamicRepo(String paramJson) {
        try {
            long l = System.currentTimeMillis();
            log.info("GPT\u5f00\u53d1\u5e73\u53f0\uff1aGaiPromptService#syncCallUseDynamicRepo\u8bf7\u6c42\u53c2\u6570\uff1a" + paramJson);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseDynamicRepo", (Object[])new Object[]{paramJson});
            log.warn("GPT\u5f00\u53d1\u5e73\u53f0\uff1aGaiPromptService#syncCallUseDynamicRepo\u54cd\u5e94\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) + "\u6beb\u79d2\uff0c\u54cd\u5e94\uff1a" + result);
            boolean gptSuccess = (Boolean)result.get("status");
            Map data = (Map)result.get("data");
            if (!gptSuccess || data == null || StringUtils.isBlank((CharSequence)(data.get("llmValue") + ""))) {
                return null;
            }
            String llmValue = data.get("llmValue") + "";
            llmValue = FGPTASAuditHelper.renderLLMValue(llmValue);
            return llmValue;
        }
        catch (Exception e) {
            log.error("GPT\u5f00\u53d1\u5e73\u53f0\uff1aGaiPromptService#syncCallUseDynamicRepo\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static DynamicObject[] saveRequiresNew(DynamicObject[] audits) {
        DynamicObject[] objects;
        try (TXHandle h = TX.requiresNew((String)"kd.fi.fgptas.business.audit.FGPTASAuditHelper.saveRequiresNew");){
            try {
                objects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])audits);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        return objects;
    }

    private static boolean require(DataMutex dataMutex, String pk, String billNo) {
        String groupId = "default_netctrl";
        ArrayList mutexRequireList = new ArrayList(1);
        HashMap<String, Object> requireParam = new HashMap<String, Object>();
        requireParam.put("dataObjId", pk);
        requireParam.put("dataObjNumber", billNo);
        requireParam.put("groupId", groupId);
        requireParam.put("entityKey", "fgptas_billaudit");
        requireParam.put("operationKey", "cqgptaudit");
        requireParam.put("isStrict", true);
        requireParam.put("callSource", "default");
        mutexRequireList.add(requireParam);
        Map mutexResult = dataMutex.batchrequire(mutexRequireList);
        return mutexResult.get(pk) != null && (Boolean)mutexResult.get(pk) != false;
    }

    private static boolean release(DataMutex dataMutex, String pk, String billNo) {
        String groupId = "default_netctrl";
        ArrayList mutexRequireList = new ArrayList(1);
        HashMap<String, Object> requireParam = new HashMap<String, Object>();
        requireParam.put("dataObjId", pk);
        requireParam.put("dataObjNumber", billNo);
        requireParam.put("groupId", groupId);
        requireParam.put("entityKey", "fgptas_billaudit");
        requireParam.put("operationKey", "cqgptaudit");
        requireParam.put("isStrict", true);
        requireParam.put("callSource", "default");
        mutexRequireList.add(requireParam);
        Map mutexResult = dataMutex.batchRelease(mutexRequireList);
        return mutexResult.get(pk) != null && (Boolean)mutexResult.get(pk) != false;
    }

    public static String renderLLMValue(String llmValue) {
        llmValue = llmValue + "";
        llmValue = llmValue.replaceAll("#{5,}.*?#{5,}", "");
        llmValue = llmValue.replaceAll("<sup>.*?</sup>", "");
        return llmValue;
    }
}

