/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import java.util.Arrays;
import java.util.Optional;

public enum FGPTASAuditStatus {
    NEW("0"),
    EMBEDDING_PROCESSING("1"),
    GPT_AUDIT_PROCESSING("2"),
    SUCCESS("3"),
    NO_ATTACHMENT("4"),
    GPT_ERROR("5"),
    FGPTAS_CONFIG_ERROR("6"),
    EMBEDDING_ERROR("7"),
    PRICACY_ERROR("8"),
    CURR_PRICACY_ERROR("9");

    public final String key;

    private FGPTASAuditStatus(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static FGPTASAuditStatus keyOf(String key) {
        Optional<FGPTASAuditStatus> status = Arrays.stream(FGPTASAuditStatus.values()).filter(v -> v.key.equals(key)).findFirst();
        return status.orElse(null);
    }

    public static boolean isError(FGPTASAuditStatus status) {
        return EMBEDDING_ERROR == status || FGPTAS_CONFIG_ERROR == status || PRICACY_ERROR == status || CURR_PRICACY_ERROR == status || GPT_ERROR == status;
    }

    public static boolean isRunning(FGPTASAuditStatus status) {
        return EMBEDDING_PROCESSING == status || GPT_AUDIT_PROCESSING == status;
    }

    public static boolean isRepairable(FGPTASAuditStatus status) {
        return FGPTASAuditStatus.isError(status) || NEW == status || null == status;
    }

    public static boolean isFinished(FGPTASAuditStatus status) {
        return SUCCESS == status || NO_ATTACHMENT == status;
    }
}

