/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit;

import java.util.Arrays;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;

public enum OcrStatus {
    NEW("A"),
    RUNNING("B"),
    SUCCESS("C"),
    FAIL("D");

    String key;

    private OcrStatus(String key) {
        this.key = key;
    }

    public static OcrStatus keyOf(String key) {
        Optional<OcrStatus> exist = Arrays.stream(OcrStatus.values()).filter(s -> s.key.equals(key)).findFirst();
        return exist.orElse(null);
    }

    public String getKey() {
        return this.key;
    }

    public static boolean isRepairable(OcrStatus status, String errorMsg) {
        boolean noAtt = false;
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            noAtt = errorMsg.contains(AuditErrorCode.NO_ATTACHMENT.getCode());
        }
        return status == FAIL && !noAtt;
    }

    public static boolean isFinished(OcrStatus status, String errorMsg) {
        boolean noAtt = false;
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            noAtt = errorMsg.contains(AuditErrorCode.NO_ATTACHMENT.getCode());
        }
        return status == SUCCESS || noAtt;
    }
}

