/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fgptas.business.audit.baidu;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.fgptas.business.audit.baidu.Base64Util;
import kd.fi.fgptas.business.audit.baidu.HttpUtil;
import kd.fi.fgptas.business.audit.error.AuditErrorCode;
import kd.fi.fgptas.business.audit.error.ThrowErrorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BaiDuRequestHelper {
    private static final Log log = LogFactory.getLog(BaiDuRequestHelper.class);
    private static final String OCR_1 = "https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice";
    private static final String OCR_2 = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic";
    private static final String GET_TOKEN = "https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s";
    private static final Set<Integer> CODE_OF_INVALID_TOKEN = new HashSet<Integer>(Arrays.asList(100, 110, 111));
    private static final ThreadLocal<Integer> RETRY_TIMES = ThreadLocal.withInitial(() -> 1);
    private static final String ACCESS_TOKEN_KEY = "baidu_access_token";
    private static final String APP_KEY = "fgptas";

    private static String getToken() throws Exception {
        String url;
        String tokenResult;
        LinkedHashMap result;
        String clientSecret;
        String accessToken = (String)AppCache.get((String)APP_KEY).get(ACCESS_TOKEN_KEY, String.class);
        if (StringUtils.isNotBlank((CharSequence)accessToken) && !"null".equalsIgnoreCase(accessToken)) {
            return accessToken;
        }
        AppParam param = new AppParam(AppMetadataCache.getAppInfo((String)APP_KEY).getId(), Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        String clientId = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"clientid");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{clientId, clientSecret = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"clientsecret")})) {
            ThrowErrorUtil.throwError(AuditErrorCode.INVALID_OCR_CLIENT);
        }
        if (BaiDuRequestHelper.isError(result = (LinkedHashMap)SerializationUtils.fromJsonString((String)(tokenResult = HttpClientUtils.get((String)(url = String.format(GET_TOKEN, clientId, clientSecret)), (int)10000, (int)30000)), LinkedHashMap.class))) {
            log.error("get token fail:" + result);
            ThrowErrorUtil.throwError(AuditErrorCode.INVALID_OCR_CLIENT);
        }
        accessToken = result.get("access_token") + "";
        AppCache.get((String)APP_KEY).put(ACCESS_TOKEN_KEY, (Object)accessToken);
        return accessToken;
    }

    public static Map<String, Object> getOcr(String path, String type) {
        RETRY_TIMES.set(1);
        Map<String, Object> ocrResult = BaiDuRequestHelper.getOcr0(path, type);
        RETRY_TIMES.remove();
        return ocrResult;
    }

    private static Map<String, Object> getOcr0(String filePath, String type) {
        try {
            String param = BaiDuRequestHelper.getParam(filePath, type);
            String ocrResult = HttpUtil.post(OCR_1, BaiDuRequestHelper.getToken(), param);
            Map<String, Object> result = (Map<String, Object>)SerializationUtils.fromJsonString((String)ocrResult, LinkedHashMap.class);
            if (BaiDuRequestHelper.callOcr2(result)) {
                log.warn(filePath + ": unrecognized bill under multiple_invoice:" + ocrResult + " and start to accurate_basic");
                ocrResult = HttpUtil.post(OCR_2, BaiDuRequestHelper.getToken(), param);
                result = (Map)SerializationUtils.fromJsonString((String)ocrResult, LinkedHashMap.class);
            }
            log.info(filePath + ": baidu ocr result:" + ocrResult);
            if (BaiDuRequestHelper.isError(result) && RETRY_TIMES.get() > 0 && CODE_OF_INVALID_TOKEN.contains(NumberUtils.toInt((String)(result.get("error_code") + ""), (int)0))) {
                log.info("token is invalid. refresh then retry");
                RETRY_TIMES.set(RETRY_TIMES.get() - 1);
                result = BaiDuRequestHelper.getOcr0(filePath, type);
            }
            return result;
        }
        catch (Exception e) {
            RETRY_TIMES.remove();
            AppCache.get((String)APP_KEY).remove(ACCESS_TOKEN_KEY);
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static String getParam(String filePath, String type) throws Exception {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        log.info("get file by filePath:" + filePath);
        InputStream is = FileServiceFactory.getAttachmentFileService().getInputStream(filePath);
        while ((len = is.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        byte[] imgData = bos.toByteArray();
        log.info("image size:" + imgData.length);
        bos.close();
        is.close();
        String imgStr = Base64Util.encode(imgData);
        String imgParam = URLEncoder.encode(imgStr, "UTF-8");
        String p = "image=";
        if ("pdf".equalsIgnoreCase(type)) {
            p = "pdf_file=";
        } else if ("ofd".equalsIgnoreCase(type)) {
            p = "ofd_file=";
        }
        return p + imgParam;
    }

    private static boolean callOcr2(Map<String, Object> result) {
        List wordsResult = (List)result.get("words_result");
        Object wordsResultNum = result.get("words_result_num");
        int num = wordsResultNum == null ? 0 : (Integer)wordsResultNum;
        return num == 0 || num >= 1 && wordsResult.stream().noneMatch(r -> r.containsKey("result"));
    }

    public static boolean isError(Map<String, Object> result) {
        boolean error;
        boolean bl = error = result == null || result.containsKey("error_code") || result.containsKey("error");
        if (error) {
            AppCache.get((String)APP_KEY).remove(ACCESS_TOKEN_KEY);
        }
        return error;
    }
}

